/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHBaseFsck {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Configuration conf = TEST_UTIL.getConfiguration();
    private static final byte[] TABLE = Bytes.toBytes((String)"table");
    private static final byte[] FAM = Bytes.toBytes((String)"fam");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
    }

    private int doFsck(boolean fix) throws Exception {
        HBaseFsck fsck = new HBaseFsck(conf);
        fsck.displayFullReport();
        fsck.setTimeLag(0L);
        fsck.setFixErrors(fix);
        return fsck.doWork();
    }

    @Test
    public void testHBaseFsck() throws Exception {
        int result = this.doFsck(false);
        Assert.assertEquals((long)0L, (long)result);
        TEST_UTIL.createTable(TABLE, FAM);
        result = this.doFsck(false);
        Assert.assertEquals((long)0L, (long)result);
        HTable meta = new HTable(conf, HTableDescriptor.META_TABLEDESC.getName());
        ResultScanner scanner = meta.getScanner(new Scan());
        block0: for (Result res : scanner) {
            long startCode = Bytes.toLong((byte[])res.getValue(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER));
            for (JVMClusterUtil.RegionServerThread rs : TEST_UTIL.getHBaseCluster().getRegionServerThreads()) {
                HServerInfo hsi = rs.getRegionServer().getServerInfo();
                if (startCode == hsi.getStartCode()) continue;
                Put put = new Put(res.getRow());
                put.add(HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)hsi.getHostnamePort()));
                put.add(HConstants.CATALOG_FAMILY, HConstants.STARTCODE_QUALIFIER, Bytes.toBytes((long)hsi.getStartCode()));
                meta.put(put);
                break block0;
            }
        }
        result = this.doFsck(true);
        Assert.assertEquals((long)-1L, (long)result);
        Thread.sleep(15000L);
        result = this.doFsck(false);
        Assert.assertEquals((long)0L, (long)result);
        new HTable(conf, TABLE).getScanner(new Scan());
    }
}

