/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Merge;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TestMergeTool
extends HBaseTestCase {
    static final Log LOG = LogFactory.getLog(TestMergeTool.class);
    static final byte[] FAMILY = Bytes.toBytes((String)"contents");
    static final byte[] QUALIFIER = Bytes.toBytes((String)"dc");
    private final HRegionInfo[] sourceRegions = new HRegionInfo[5];
    private final HRegion[] regions = new HRegion[5];
    private HTableDescriptor desc;
    private byte[][][] rows;
    private MiniDFSCluster dfsCluster = null;

    @Override
    public void setUp() throws Exception {
        this.conf.setLong("hbase.zookeeper.recoverable.waittime", 1000L);
        this.conf.set("hbase.hstore.compactionThreshold", "2");
        this.desc = new HTableDescriptor("TestMergeTool");
        this.desc.addFamily(new HColumnDescriptor(FAMILY));
        this.sourceRegions[0] = new HRegionInfo(this.desc, Bytes.toBytes((String)"row_0200"), Bytes.toBytes((String)"row_0300"));
        this.sourceRegions[1] = new HRegionInfo(this.desc, Bytes.toBytes((String)"row_0250"), Bytes.toBytes((String)"row_0400"));
        this.sourceRegions[2] = new HRegionInfo(this.desc, Bytes.toBytes((String)"row_0100"), Bytes.toBytes((String)"row_0200"));
        this.sourceRegions[3] = new HRegionInfo(this.desc, Bytes.toBytes((String)"row_0500"), Bytes.toBytes((String)"row_0600"));
        this.sourceRegions[4] = new HRegionInfo(this.desc, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY);
        this.rows = new byte[5][][];
        this.rows[0] = Bytes.toByteArrays((String[])new String[]{"row_0210", "row_0280"});
        this.rows[1] = Bytes.toByteArrays((String[])new String[]{"row_0260", "row_0350", "row_035"});
        this.rows[2] = Bytes.toByteArrays((String[])new String[]{"row_0110", "row_0175", "row_0175", "row_0175"});
        this.rows[3] = Bytes.toByteArrays((String[])new String[]{"row_0525", "row_0560", "row_0560", "row_0560", "row_0560"});
        this.rows[4] = Bytes.toByteArrays((String[])new String[]{"row_0050", "row_1000", "row_1000", "row_1000", "row_1000", "row_1000"});
        this.dfsCluster = new MiniDFSCluster(this.conf, 2, true, (String[])null);
        this.fs = this.dfsCluster.getFileSystem();
        System.out.println("fs=" + this.fs);
        this.conf.set("fs.defaultFS", this.fs.getUri().toString());
        Path parentdir = this.fs.getHomeDirectory();
        this.conf.set("hbase.rootdir", parentdir.toString());
        this.fs.mkdirs(parentdir);
        FSUtils.setVersion((FileSystem)this.fs, (Path)parentdir);
        super.setUp();
        try {
            this.createRootAndMetaRegions();
            for (int i = 0; i < this.sourceRegions.length; ++i) {
                this.regions[i] = HRegion.createHRegion((HRegionInfo)this.sourceRegions[i], (Path)this.testDir, (Configuration)this.conf);
                for (int j = 0; j < this.rows[i].length; ++j) {
                    byte[] row = this.rows[i][j];
                    Put put = new Put(row);
                    put.add(FAMILY, QUALIFIER, row);
                    this.regions[i].put(put);
                }
                HRegion.addRegionToMETA((HRegion)this.meta, (HRegion)this.regions[i]);
            }
            this.closeRootAndMeta();
        }
        catch (Exception e) {
            TestMergeTool.shutdownDfs(this.dfsCluster);
            throw e;
        }
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        TestMergeTool.shutdownDfs(this.dfsCluster);
    }

    private HRegion mergeAndVerify(String msg, String regionName1, String regionName2, HLog log, int upperbound) throws Exception {
        Merge merger = new Merge(this.conf);
        LOG.info((Object)msg);
        System.out.println("fs2=" + this.conf.get("fs.defaultFS"));
        int errCode = ToolRunner.run((Configuration)this.conf, (Tool)merger, (String[])new String[]{this.desc.getNameAsString(), regionName1, regionName2});
        TestMergeTool.assertTrue((String)("'" + msg + "' failed"), (errCode == 0 ? 1 : 0) != 0);
        HRegionInfo mergedInfo = merger.getMergedHRegionInfo();
        HRegion merged = HRegion.openHRegion((HRegionInfo)mergedInfo, (HLog)log, (Configuration)this.conf);
        this.verifyMerge(merged, upperbound);
        merged.close();
        LOG.info((Object)("Verified " + msg));
        return merged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyMerge(HRegion merged, int upperbound) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(FAMILY);
        InternalScanner scanner = merged.getScanner(scan);
        try {
            boolean hasNext;
            ArrayList testRes = null;
            while (hasNext = scanner.next(testRes = new ArrayList())) {
            }
        }
        finally {
            scanner.close();
        }
        for (int i = 0; i < upperbound; ++i) {
            for (int j = 0; j < this.rows[i].length; ++j) {
                Get get = new Get(this.rows[i][j]);
                get.addFamily(FAMILY);
                Result result = merged.get(get, null);
                TestMergeTool.assertEquals((int)1, (int)result.size());
                byte[] bytes = result.sorted()[0].getValue();
                TestMergeTool.assertNotNull((String)Bytes.toStringBinary((byte[])this.rows[i][j]), (Object)bytes);
                TestMergeTool.assertTrue((boolean)Bytes.equals((byte[])bytes, (byte[])this.rows[i][j]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMergeTool() throws Exception {
        for (int i = 0; i < this.regions.length; ++i) {
            for (int j = 0; j < this.rows[i].length; ++j) {
                Get get = new Get(this.rows[i][j]);
                get.addFamily(FAMILY);
                Result result = this.regions[i].get(get, null);
                byte[] bytes = result.sorted()[0].getValue();
                TestMergeTool.assertNotNull((Object)bytes);
                TestMergeTool.assertTrue((boolean)Bytes.equals((byte[])bytes, (byte[])this.rows[i][j]));
            }
            this.regions[i].close();
            this.regions[i].getLog().closeAndDelete();
        }
        Path logPath = new Path("/tmp", ".logs_" + System.currentTimeMillis());
        LOG.info((Object)("Creating log " + logPath.toString()));
        Path oldLogDir = new Path("/tmp", ".oldlogs");
        HLog log = new HLog(this.fs, logPath, oldLogDir, this.conf);
        try {
            HRegion merged = this.mergeAndVerify("merging regions 0 and 1", this.sourceRegions[0].getRegionNameAsString(), this.sourceRegions[1].getRegionNameAsString(), log, 2);
            merged = this.mergeAndVerify("merging regions 0+1 and 2", merged.getRegionInfo().getRegionNameAsString(), this.sourceRegions[2].getRegionNameAsString(), log, 3);
            merged = this.mergeAndVerify("merging regions 0+1+2 and 3", merged.getRegionInfo().getRegionNameAsString(), this.sourceRegions[3].getRegionNameAsString(), log, 4);
            merged = this.mergeAndVerify("merging regions 0+1+2+3 and 4", merged.getRegionInfo().getRegionNameAsString(), this.sourceRegions[4].getRegionNameAsString(), log, this.rows.length);
        }
        finally {
            log.closeAndDelete();
        }
    }
}

