/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.MiniZooKeeperCluster;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class HBaseClusterTestCase
extends HBaseTestCase {
    private static final Log LOG = LogFactory.getLog(HBaseClusterTestCase.class);
    public MiniHBaseCluster cluster;
    protected MiniDFSCluster dfsCluster;
    protected MiniZooKeeperCluster zooKeeperCluster;
    protected int regionServers;
    protected boolean startDfs;
    private boolean openMetaTable = true;

    public HBaseClusterTestCase() {
        this(1);
    }

    public HBaseClusterTestCase(int regionServers) {
        this(regionServers, true);
    }

    public HBaseClusterTestCase(int regionServers, boolean startDfs) {
        this.startDfs = startDfs;
        this.regionServers = regionServers;
    }

    protected void setOpenMetaTable(boolean val) {
        this.openMetaTable = val;
    }

    protected void preHBaseClusterSetup() throws Exception {
    }

    protected void hBaseClusterSetup() throws Exception {
        File testDir = new File(this.getUnitTestdir(this.getName()).toString());
        if (testDir.exists()) {
            testDir.delete();
        }
        this.zooKeeperCluster = new MiniZooKeeperCluster();
        int clientPort = this.zooKeeperCluster.startup(testDir);
        this.conf.set("hbase.zookeeper.property.clientPort", Integer.toString(clientPort));
        Configuration c = new Configuration(this.conf);
        this.cluster = new MiniHBaseCluster(c, this.regionServers);
        if (this.openMetaTable) {
            new HTable(c, HConstants.META_TABLE_NAME);
        }
    }

    protected void postHBaseClusterSetup() throws Exception {
    }

    @Override
    protected void setUp() throws Exception {
        try {
            if (this.startDfs) {
                this.dfsCluster = new MiniDFSCluster(0, this.conf, 2, true, true, true, null, null, null, null);
                FileSystem filesystem = this.dfsCluster.getFileSystem();
                this.conf.set("fs.defaultFS", filesystem.getUri().toString());
                Path parentdir = filesystem.getHomeDirectory();
                this.conf.set("hbase.rootdir", parentdir.toString());
                filesystem.mkdirs(parentdir);
                FSUtils.setVersion((FileSystem)filesystem, (Path)parentdir);
            }
            super.setUp();
            this.preHBaseClusterSetup();
            this.hBaseClusterSetup();
            this.postHBaseClusterSetup();
        }
        catch (Exception e) {
            LOG.error((Object)"Exception in setup!", (Throwable)e);
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
            if (this.zooKeeperCluster != null) {
                this.zooKeeperCluster.shutdown();
            }
            if (this.dfsCluster != null) {
                HBaseClusterTestCase.shutdownDfs(this.dfsCluster);
            }
            throw e;
        }
    }

    @Override
    protected void tearDown() throws Exception {
        if (!this.openMetaTable) {
            new HTable(this.conf, HConstants.META_TABLE_NAME);
        }
        super.tearDown();
        try {
            HConnectionManager.deleteConnection((Configuration)this.conf, (boolean)true);
            if (this.cluster != null) {
                try {
                    this.cluster.shutdown();
                }
                catch (Exception e) {
                    LOG.warn((Object)"Closing mini dfs", (Throwable)e);
                }
                try {
                    this.zooKeeperCluster.shutdown();
                }
                catch (IOException e) {
                    LOG.warn((Object)"Shutting down ZooKeeper cluster", (Throwable)e);
                }
            }
            if (this.startDfs) {
                HBaseClusterTestCase.shutdownDfs(this.dfsCluster);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public void threadDumpingJoin() {
        if (this.cluster.getRegionServerThreads() != null) {
            for (JVMClusterUtil.RegionServerThread t : this.cluster.getRegionServerThreads()) {
                this.threadDumpingJoin((Thread)t);
            }
        }
        this.threadDumpingJoin((Thread)this.cluster.getMaster());
    }

    protected void threadDumpingJoin(Thread t) {
        if (t == null) {
            return;
        }
        long startTime = System.currentTimeMillis();
        while (t.isAlive()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOG.info((Object)"Continuing...", (Throwable)e);
            }
            if (System.currentTimeMillis() - startTime <= 60000L) continue;
            startTime = System.currentTimeMillis();
            ReflectionUtils.printThreadInfo((PrintWriter)new PrintWriter(System.out), (String)("Automatic Stack Trace every 60 seconds waiting on " + t.getName()));
        }
    }
}

