/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.Comparator;
import java.util.TreeSet;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.util.Bytes;

public class TestKeyValue
extends TestCase {
    private final Log LOG = LogFactory.getLog((String)((Object)((Object)this)).getClass().getName());
    private final byte[] rowA = Bytes.toBytes((String)"rowA");
    private final byte[] rowB = Bytes.toBytes((String)"rowB");
    private final byte[] family = Bytes.toBytes((String)"family");
    private final byte[] qualA = Bytes.toBytes((String)"qfA");

    public void testColumnCompare() throws Exception {
        byte[] a = Bytes.toBytes((String)"aaa");
        byte[] family1 = Bytes.toBytes((String)"abc");
        byte[] qualifier1 = Bytes.toBytes((String)"def");
        byte[] family2 = Bytes.toBytes((String)"abcd");
        byte[] qualifier2 = Bytes.toBytes((String)"ef");
        KeyValue aaa = new KeyValue(a, family1, qualifier1, 0L, KeyValue.Type.Put, a);
        TestKeyValue.assertFalse((boolean)aaa.matchingColumn(family2, qualifier2));
        TestKeyValue.assertTrue((boolean)aaa.matchingColumn(family1, qualifier1));
        aaa = new KeyValue(a, family2, qualifier2, 0L, KeyValue.Type.Put, a);
        TestKeyValue.assertFalse((boolean)aaa.matchingColumn(family1, qualifier1));
        TestKeyValue.assertTrue((boolean)aaa.matchingColumn(family2, qualifier2));
        byte[] nullQualifier = new byte[]{};
        aaa = new KeyValue(a, family1, nullQualifier, 0L, KeyValue.Type.Put, a);
        TestKeyValue.assertTrue((boolean)aaa.matchingColumn(family1, null));
        TestKeyValue.assertFalse((boolean)aaa.matchingColumn(family2, qualifier2));
    }

    public void testBasics() throws Exception {
        this.LOG.info((Object)("LOWKEY: " + KeyValue.LOWESTKEY.toString()));
        this.check(Bytes.toBytes((String)this.getName()), Bytes.toBytes((String)this.getName()), Bytes.toBytes((String)this.getName()), 1L, Bytes.toBytes((String)this.getName()));
        this.check(Bytes.toBytes((String)this.getName()), Bytes.toBytes((String)this.getName()), null, 1L, null);
        this.check(HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)this.getName()), null, 1L, null);
    }

    private void check(byte[] row, byte[] family, byte[] qualifier, long timestamp, byte[] value) {
        KeyValue kv = new KeyValue(row, family, qualifier, timestamp, value);
        TestKeyValue.assertTrue((Bytes.compareTo((byte[])kv.getRow(), (byte[])row) == 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((boolean)kv.matchingColumn(family, qualifier));
        this.LOG.info((Object)kv.toString());
    }

    public void testPlainCompare() throws Exception {
        byte[] a = Bytes.toBytes((String)"aaa");
        byte[] b = Bytes.toBytes((String)"bbb");
        byte[] fam = Bytes.toBytes((String)"col");
        byte[] qf = Bytes.toBytes((String)"umn");
        KeyValue aaa = new KeyValue(a, fam, qf, a);
        KeyValue bbb = new KeyValue(b, fam, qf, b);
        byte[] keyabb = aaa.getKey();
        byte[] keybbb = bbb.getKey();
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, bbb) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.KEY_COMPARATOR.compare(keyabb, 0, keyabb.length, keybbb, 0, keybbb.length) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(bbb, aaa) > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.KEY_COMPARATOR.compare(keybbb, 0, keybbb.length, keyabb, 0, keyabb.length) > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(bbb, bbb) == 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.KEY_COMPARATOR.compare(keybbb, 0, keybbb.length, keybbb, 0, keybbb.length) == 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, aaa) == 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.KEY_COMPARATOR.compare(keyabb, 0, keyabb.length, keyabb, 0, keyabb.length) == 0 ? 1 : 0) != 0);
        aaa = new KeyValue(a, fam, qf, 1L, a);
        bbb = new KeyValue(a, fam, qf, 2L, a);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, bbb) > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(bbb, aaa) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, aaa) == 0 ? 1 : 0) != 0);
        aaa = new KeyValue(a, fam, qf, 1L, KeyValue.Type.Delete, a);
        bbb = new KeyValue(a, fam, qf, 1L, a);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, bbb) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(bbb, aaa) > 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((KeyValue.COMPARATOR.compare(aaa, aaa) == 0 ? 1 : 0) != 0);
    }

    public void testMoreComparisons() throws Exception {
        long now = System.currentTimeMillis();
        KeyValue a = new KeyValue(Bytes.toBytes((String)".META.,,99999999999999"), now);
        KeyValue.RootComparator c = new KeyValue.RootComparator();
        KeyValue b = new KeyValue(Bytes.toBytes((String)".META.,,1"), now);
        TestKeyValue.assertTrue((c.compare(b, a) < 0 ? 1 : 0) != 0);
        KeyValue aa = new KeyValue(Bytes.toBytes((String)".META.,,1"), now);
        KeyValue bb = new KeyValue(Bytes.toBytes((String)".META.,,1"), Bytes.toBytes((String)"info"), Bytes.toBytes((String)"regioninfo"), 1235943454602L, (byte[])null);
        TestKeyValue.assertTrue((c.compare(aa, bb) < 0 ? 1 : 0) != 0);
        KeyValue aaa = new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,row_0500,1236020145502"), now);
        KeyValue bbb = new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,,99999999999999"), now);
        c = new KeyValue.MetaComparator();
        TestKeyValue.assertTrue((c.compare(bbb, aaa) < 0 ? 1 : 0) != 0);
        KeyValue aaaa = new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,,1236023996656"), Bytes.toBytes((String)"info"), Bytes.toBytes((String)"regioninfo"), 1236024396271L, (byte[])null);
        TestKeyValue.assertTrue((c.compare(aaaa, bbb) < 0 ? 1 : 0) != 0);
        KeyValue x = new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,row_0500,1236034574162"), Bytes.toBytes((String)"info"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null);
        KeyValue y = new KeyValue(Bytes.toBytes((String)"TestScanMultipleVersions,row_0500,1236034574162"), Bytes.toBytes((String)"info"), Bytes.toBytes((String)"regioninfo"), 1236034574912L, (byte[])null);
        TestKeyValue.assertTrue((c.compare(x, y) < 0 ? 1 : 0) != 0);
        this.comparisons((KeyValue.KVComparator)new KeyValue.MetaComparator());
        this.comparisons(new KeyValue.KVComparator());
        this.metacomparisons((KeyValue.MetaComparator)new KeyValue.RootComparator());
        this.metacomparisons(new KeyValue.MetaComparator());
    }

    public void testBadMetaCompareSingleDelim() {
        KeyValue.MetaComparator c = new KeyValue.MetaComparator();
        long now = System.currentTimeMillis();
        KeyValue a = new KeyValue(Bytes.toBytes((String)"table,a1"), now);
        KeyValue b = new KeyValue(Bytes.toBytes((String)"table,a2"), now);
        try {
            c.compare(a, b);
        }
        catch (IllegalArgumentException iae) {
            TestKeyValue.assertEquals((String)".META. key must have two ',' delimiters and have the following format: '<table>,<key>,<etc>'", (String)iae.getMessage());
            return;
        }
        TestKeyValue.fail((String)"Expected IllegalArgumentException");
    }

    public void testMetaComparatorTableKeysWithCommaOk() {
        KeyValue b;
        KeyValue.MetaComparator c = new KeyValue.MetaComparator();
        long now = System.currentTimeMillis();
        KeyValue a = new KeyValue(Bytes.toBytes((String)"table,key,with,commas1,1234"), now);
        TestKeyValue.assertTrue((c.compare(a, b = new KeyValue(Bytes.toBytes((String)"table,key,with,commas2,0123"), now)) < 0 ? 1 : 0) != 0);
    }

    public void testKeyValueBorderCases() throws IOException {
        KeyValue rowB;
        KeyValue rowA = new KeyValue(Bytes.toBytes((String)"testtable,www.hbase.org/,1234"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null);
        TestKeyValue.assertTrue((KeyValue.META_COMPARATOR.compare(rowA, rowB = new KeyValue(Bytes.toBytes((String)"testtable,www.hbase.org/%20,99999"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null)) < 0 ? 1 : 0) != 0);
        rowA = new KeyValue(Bytes.toBytes((String)"testtable,,1234"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null);
        rowB = new KeyValue(Bytes.toBytes((String)"testtable,$www.hbase.org/,99999"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null);
        TestKeyValue.assertTrue((KeyValue.META_COMPARATOR.compare(rowA, rowB) < 0 ? 1 : 0) != 0);
        rowA = new KeyValue(Bytes.toBytes((String)".META.,testtable,www.hbase.org/,1234,4321"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null);
        rowB = new KeyValue(Bytes.toBytes((String)".META.,testtable,www.hbase.org/%20,99999,99999"), Bytes.toBytes((String)"fam"), Bytes.toBytes((String)""), Long.MAX_VALUE, (byte[])null);
        TestKeyValue.assertTrue((KeyValue.ROOT_COMPARATOR.compare(rowA, rowB) < 0 ? 1 : 0) != 0);
    }

    private void metacomparisons(KeyValue.MetaComparator c) {
        long now = System.currentTimeMillis();
        TestKeyValue.assertTrue((c.compare(new KeyValue(Bytes.toBytes((String)".META.,a,,0,1"), now), new KeyValue(Bytes.toBytes((String)".META.,a,,0,1"), now)) == 0 ? 1 : 0) != 0);
        KeyValue a = new KeyValue(Bytes.toBytes((String)".META.,a,,0,1"), now);
        KeyValue b = new KeyValue(Bytes.toBytes((String)".META.,a,,0,2"), now);
        TestKeyValue.assertTrue((c.compare(a, b) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((c.compare(new KeyValue(Bytes.toBytes((String)".META.,a,,0,2"), now), new KeyValue(Bytes.toBytes((String)".META.,a,,0,1"), now)) > 0 ? 1 : 0) != 0);
    }

    private void comparisons(KeyValue.KVComparator c) {
        long now = System.currentTimeMillis();
        TestKeyValue.assertTrue((c.compare(new KeyValue(Bytes.toBytes((String)".META.,,1"), now), new KeyValue(Bytes.toBytes((String)".META.,,1"), now)) == 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((c.compare(new KeyValue(Bytes.toBytes((String)".META.,,1"), now), new KeyValue(Bytes.toBytes((String)".META.,,2"), now)) < 0 ? 1 : 0) != 0);
        TestKeyValue.assertTrue((c.compare(new KeyValue(Bytes.toBytes((String)".META.,,2"), now), new KeyValue(Bytes.toBytes((String)".META.,,1"), now)) > 0 ? 1 : 0) != 0);
    }

    public void testBinaryKeys() throws Exception {
        TreeSet<KeyValue> set = new TreeSet<KeyValue>((Comparator<KeyValue>)KeyValue.COMPARATOR);
        byte[] fam = Bytes.toBytes((String)"col");
        byte[] qf = Bytes.toBytes((String)"umn");
        byte[] nb = new byte[]{};
        KeyValue[] keys = new KeyValue[]{new KeyValue(Bytes.toBytes((String)"aaaaa,\u0000\u0000,2"), fam, qf, 2L, nb), new KeyValue(Bytes.toBytes((String)"aaaaa,\u0001,3"), fam, qf, 3L, nb), new KeyValue(Bytes.toBytes((String)"aaaaa,,1"), fam, qf, 1L, nb), new KeyValue(Bytes.toBytes((String)"aaaaa,\u1000,5"), fam, qf, 5L, nb), new KeyValue(Bytes.toBytes((String)"aaaaa,a,4"), fam, qf, 4L, nb), new KeyValue(Bytes.toBytes((String)"a,a,0"), fam, qf, 0L, nb)};
        for (int i = 0; i < keys.length; ++i) {
            set.add(keys[i]);
        }
        boolean assertion = false;
        int count = 0;
        try {
            for (KeyValue k : set) {
                TestKeyValue.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
            }
        }
        catch (AssertionFailedError e) {
            assertion = true;
        }
        TestKeyValue.assertTrue((boolean)assertion);
        set = new TreeSet(new KeyValue.MetaComparator());
        for (int i = 0; i < keys.length; ++i) {
            set.add(keys[i]);
        }
        count = 0;
        for (KeyValue k : set) {
            TestKeyValue.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
        }
        KeyValue[] rootKeys = new KeyValue[]{new KeyValue(Bytes.toBytes((String)".META.,aaaaa,\u0000\u0000,0,2"), fam, qf, 2L, nb), new KeyValue(Bytes.toBytes((String)".META.,aaaaa,\u0001,0,3"), fam, qf, 3L, nb), new KeyValue(Bytes.toBytes((String)".META.,aaaaa,,0,1"), fam, qf, 1L, nb), new KeyValue(Bytes.toBytes((String)".META.,aaaaa,\u1000,0,5"), fam, qf, 5L, nb), new KeyValue(Bytes.toBytes((String)".META.,aaaaa,a,0,4"), fam, qf, 4L, nb), new KeyValue(Bytes.toBytes((String)".META.,,0"), fam, qf, 0L, nb)};
        set = new TreeSet(new KeyValue.MetaComparator());
        for (int i = 0; i < keys.length; ++i) {
            set.add(rootKeys[i]);
        }
        assertion = false;
        count = 0;
        try {
            for (KeyValue k : set) {
                TestKeyValue.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
            }
        }
        catch (AssertionFailedError e) {
            assertion = true;
        }
        set = new TreeSet(new KeyValue.RootComparator());
        for (int i = 0; i < keys.length; ++i) {
            set.add(rootKeys[i]);
        }
        count = 0;
        for (KeyValue k : set) {
            TestKeyValue.assertTrue(((long)count++ == k.getTimestamp() ? 1 : 0) != 0);
        }
    }

    public void testStackedUpKeyValue() {
    }

    private void assertKVLess(KeyValue.KVComparator c, KeyValue less, KeyValue greater) {
        int cmp = c.compare(less, greater);
        TestKeyValue.assertTrue((cmp < 0 ? 1 : 0) != 0);
        cmp = c.compare(greater, less);
        TestKeyValue.assertTrue((cmp > 0 ? 1 : 0) != 0);
    }

    public void testFirstLastOnRow() {
        KeyValue.KVComparator c = KeyValue.COMPARATOR;
        long ts = 1L;
        KeyValue firstOnRowA = KeyValue.createFirstOnRow((byte[])this.rowA);
        KeyValue kvA_1 = new KeyValue(this.rowA, null, null, ts, KeyValue.Type.Put);
        KeyValue kvA_2 = new KeyValue(this.rowA, this.family, this.qualA, ts, KeyValue.Type.Put);
        KeyValue lastOnRowA = KeyValue.createLastOnRow((byte[])this.rowA);
        KeyValue firstOnRowB = KeyValue.createFirstOnRow((byte[])this.rowB);
        KeyValue kvB = new KeyValue(this.rowB, this.family, this.qualA, ts, KeyValue.Type.Put);
        this.assertKVLess(c, firstOnRowA, firstOnRowB);
        this.assertKVLess(c, firstOnRowA, kvA_1);
        this.assertKVLess(c, firstOnRowA, kvA_2);
        this.assertKVLess(c, kvA_1, kvA_2);
        this.assertKVLess(c, kvA_2, firstOnRowB);
        this.assertKVLess(c, kvA_1, firstOnRowB);
        this.assertKVLess(c, lastOnRowA, firstOnRowB);
        this.assertKVLess(c, firstOnRowB, kvB);
        this.assertKVLess(c, lastOnRowA, kvB);
        this.assertKVLess(c, kvA_2, lastOnRowA);
        this.assertKVLess(c, kvA_1, lastOnRowA);
        this.assertKVLess(c, firstOnRowA, lastOnRowA);
    }

    public void testConvertToKeyOnly() throws Exception {
        long ts = 1L;
        byte[] value = Bytes.toBytes((String)"a real value");
        byte[] evalue = new byte[]{};
        for (byte[] val : new byte[][]{value, evalue}) {
            for (boolean useLen : new boolean[]{false, true}) {
                KeyValue kv1 = new KeyValue(this.rowA, this.family, this.qualA, ts, val);
                KeyValue kv1ko = kv1.clone();
                TestKeyValue.assertTrue((boolean)kv1.equals((Object)kv1ko));
                kv1ko.convertToKeyOnly(useLen);
                TestKeyValue.assertTrue((boolean)kv1.equals((Object)kv1ko));
                TestKeyValue.assertTrue((kv1ko.getValue().length == (useLen ? 4 : 0) ? 1 : 0) != 0);
                if (!useLen) continue;
                TestKeyValue.assertEquals((int)kv1.getValueLength(), (int)Bytes.toInt((byte[])kv1ko.getValue()));
            }
        }
    }
}

