/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.EmptyWatcher;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestZooKeeper {
    private final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
        TEST_UTIL.getConfiguration().setBoolean("dfs.support.append", true);
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        TEST_UTIL.ensureSomeRegionServersAvailable(2);
    }

    @Test
    public void testClientSessionExpired() throws IOException, InterruptedException {
        this.LOG.info((Object)"testClientSessionExpired");
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        new HTable(c, HConstants.META_TABLE_NAME);
        String quorumServers = ZKConfig.getZKQuorumServersString((Configuration)c);
        int sessionTimeout = 5000;
        HConnection connection = HConnectionManager.getConnection((Configuration)c);
        ZooKeeperWatcher connectionZK = connection.getZooKeeperWatcher();
        long sessionID = connectionZK.getZooKeeper().getSessionId();
        byte[] password = connectionZK.getZooKeeper().getSessionPasswd();
        ZooKeeper zk = new ZooKeeper(quorumServers, sessionTimeout, (Watcher)EmptyWatcher.instance, sessionID, password);
        zk.close();
        Thread.sleep((long)sessionTimeout * 3L);
        ZKUtil.dump((ZooKeeperWatcher)connectionZK);
        System.err.println("ZooKeeper should have timed out");
        this.LOG.info((Object)("state=" + connectionZK.getZooKeeper().getState()));
        Assert.assertTrue((boolean)connectionZK.getZooKeeper().getState().equals((Object)ZooKeeper.States.CLOSED));
        ZooKeeperWatcher newConnectionZK = connection.getZooKeeperWatcher();
        this.LOG.info((Object)("state=" + newConnectionZK.getZooKeeper().getState()));
        Assert.assertTrue((boolean)newConnectionZK.getZooKeeper().getState().equals((Object)ZooKeeper.States.CONNECTED));
    }

    @Test
    public void testRegionServerSessionExpired() throws Exception {
        this.LOG.info((Object)"Starting testRegionServerSessionExpired");
        int metaIndex = TEST_UTIL.getMiniHBaseCluster().getServerWithMeta();
        TEST_UTIL.expireRegionServerSession(metaIndex);
        this.testSanity();
    }

    public void disabledTestMasterSessionExpired() throws Exception {
        this.LOG.info((Object)"Starting testMasterSessionExpired");
        TEST_UTIL.expireMasterSession();
        this.testSanity();
    }

    public void testSanity() throws Exception {
        HBaseAdmin admin = new HBaseAdmin(new Configuration(TEST_UTIL.getConfiguration()));
        String tableName = "test" + System.currentTimeMillis();
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor family = new HColumnDescriptor("fam");
        desc.addFamily(family);
        this.LOG.info((Object)("Creating table " + tableName));
        admin.createTable(desc);
        HTable table = new HTable(new Configuration(TEST_UTIL.getConfiguration()), tableName);
        Put put = new Put(Bytes.toBytes((String)"testrow"));
        put.add(Bytes.toBytes((String)"fam"), Bytes.toBytes((String)"col"), Bytes.toBytes((String)"testdata"));
        this.LOG.info((Object)("Putting table " + tableName));
        table.put(put);
    }

    @Test
    public void testMultipleZK() {
        try {
            HTable localMeta = new HTable(new Configuration(TEST_UTIL.getConfiguration()), HConstants.META_TABLE_NAME);
            Configuration otherConf = new Configuration(TEST_UTIL.getConfiguration());
            otherConf.set("hbase.zookeeper.quorum", "127.0.0.1");
            HTable ipMeta = new HTable(otherConf, HConstants.META_TABLE_NAME);
            localMeta.exists(new Get(HConstants.LAST_ROW));
            ipMeta.exists(new Get(HConstants.LAST_ROW));
            Assert.assertFalse((HConnectionManager.getConnection((Configuration)localMeta.getConfiguration()).getZooKeeperWatcher() == HConnectionManager.getConnection((Configuration)otherConf).getZooKeeperWatcher() ? 1 : 0) != 0);
            Assert.assertFalse((boolean)HConnectionManager.getConnection((Configuration)localMeta.getConfiguration()).getZooKeeperWatcher().getQuorum().equals(HConnectionManager.getConnection((Configuration)otherConf).getZooKeeperWatcher().getQuorum()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testZNodeDeletes() throws Exception {
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(new Configuration(TEST_UTIL.getConfiguration()), TestZooKeeper.class.getName(), null);
        ZKUtil.createWithParents((ZooKeeperWatcher)zkw, (String)"/l1/l2/l3/l4");
        try {
            ZKUtil.deleteNode((ZooKeeperWatcher)zkw, (String)"/l1/l2");
            Assert.fail((String)"We should not be able to delete if znode has childs");
        }
        catch (KeeperException ex) {
            Assert.assertNotNull((Object)ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)"/l1/l2/l3/l4", null));
        }
        ZKUtil.deleteNodeRecursively((ZooKeeperWatcher)zkw, (String)"/l1/l2");
        Assert.assertNull((Object)ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)"/l1/l2/l3/l4", null));
        ZKUtil.deleteNode((ZooKeeperWatcher)zkw, (String)"/l1");
        Assert.assertNull((Object)ZKUtil.getDataNoWatch((ZooKeeperWatcher)zkw, (String)"/l1/l2", null));
    }

    @Test
    public void testClusterKey() throws Exception {
        this.testKey("server", "2181", "hbase");
        this.testKey("server1,server2,server3", "2181", "hbase");
        try {
            ZKUtil.transformClusterKey((String)"2181:hbase");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void testKey(String ensemble, String port, String znode) throws IOException {
        Configuration conf = new Configuration();
        String key = ensemble + ":" + port + ":" + znode;
        String[] parts = ZKUtil.transformClusterKey((String)key);
        Assert.assertEquals((Object)ensemble, (Object)parts[0]);
        Assert.assertEquals((Object)port, (Object)parts[1]);
        Assert.assertEquals((Object)znode, (Object)parts[2]);
        ZKUtil.applyClusterKeyToConf((Configuration)conf, (String)key);
        Assert.assertEquals((Object)parts[0], (Object)conf.get("hbase.zookeeper.quorum"));
        Assert.assertEquals((Object)parts[1], (Object)conf.get("hbase.zookeeper.property.clientPort"));
        Assert.assertEquals((Object)parts[2], (Object)conf.get("zookeeper.znode.parent"));
        String reconstructedKey = ZKUtil.getZooKeeperClusterKey((Configuration)conf);
        Assert.assertEquals((Object)key, (Object)reconstructedKey);
    }
}

