/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class TimestampTestBase
extends HBaseTestCase {
    private static final long T0 = 10L;
    private static final long T1 = 100L;
    private static final long T2 = 200L;
    private static final byte[] FAMILY_NAME = Bytes.toBytes((String)"colfamily1");
    private static final byte[] QUALIFIER_NAME = Bytes.toBytes((String)"contents");
    private static final byte[] ROW = Bytes.toBytes((String)"row");

    public static void doTestDelete(HBaseTestCase.Incommon incommon, HBaseTestCase.FlushCache flusher) throws IOException {
        TimestampTestBase.put(incommon, 10L);
        TimestampTestBase.put(incommon, 100L);
        TimestampTestBase.put(incommon, 200L);
        TimestampTestBase.put(incommon);
        TimestampTestBase.assertVersions(incommon, new long[]{Long.MAX_VALUE, 200L, 100L});
        TimestampTestBase.delete(incommon);
        TimestampTestBase.assertVersions(incommon, new long[]{200L, 100L, 10L});
        flusher.flushcache();
        TimestampTestBase.assertVersions(incommon, new long[]{200L, 100L, 10L});
        TimestampTestBase.put(incommon);
        TimestampTestBase.assertVersions(incommon, new long[]{Long.MAX_VALUE, 200L, 100L});
        TimestampTestBase.delete(incommon, 200L);
        TimestampTestBase.assertVersions(incommon, new long[]{Long.MAX_VALUE, 100L, 10L});
        flusher.flushcache();
        TimestampTestBase.assertVersions(incommon, new long[]{Long.MAX_VALUE, 100L, 10L});
        TimestampTestBase.put(incommon, 200L);
        TimestampTestBase.delete(incommon, 100L);
        TimestampTestBase.put(incommon, 100L);
        Delete delete = new Delete(ROW);
        delete.deleteColumns(FAMILY_NAME, QUALIFIER_NAME, 200L);
        incommon.delete(delete, null, true);
        TimestampTestBase.assertOnlyLatest(incommon, Long.MAX_VALUE);
        flusher.flushcache();
        TimestampTestBase.assertOnlyLatest(incommon, Long.MAX_VALUE);
    }

    private static void assertOnlyLatest(HBaseTestCase.Incommon incommon, long currentTime) throws IOException {
        Get get = null;
        get = new Get(ROW);
        get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
        get.setMaxVersions(3);
        Result result = incommon.get(get);
        TimestampTestBase.assertEquals((int)1, (int)result.size());
        long time = Bytes.toLong((byte[])result.sorted()[0].getValue());
        TimestampTestBase.assertEquals((long)time, (long)currentTime);
    }

    public static void assertVersions(HBaseTestCase.Incommon incommon, long[] tss) throws IOException {
        Get get = null;
        get = new Get(ROW);
        get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
        Result r = incommon.get(get);
        byte[] bytes = r.getValue(FAMILY_NAME, QUALIFIER_NAME);
        long t = Bytes.toLong((byte[])bytes);
        TimestampTestBase.assertEquals((long)tss[0], (long)t);
        get = new Get(ROW);
        get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
        get.setMaxVersions(tss.length);
        Result result = incommon.get(get);
        KeyValue[] kvs = result.sorted();
        TimestampTestBase.assertEquals((int)kvs.length, (int)tss.length);
        for (int i = 0; i < kvs.length; ++i) {
            t = Bytes.toLong((byte[])kvs[i].getValue());
            TimestampTestBase.assertEquals((long)tss[i], (long)t);
        }
        long maxStamp = kvs[0].getTimestamp();
        get = new Get(ROW);
        get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
        get.setTimeRange(0L, maxStamp);
        get.setMaxVersions(kvs.length - 1);
        result = incommon.get(get);
        kvs = result.sorted();
        TimestampTestBase.assertEquals((int)kvs.length, (int)(tss.length - 1));
        for (int i = 1; i < kvs.length; ++i) {
            t = Bytes.toLong((byte[])kvs[i - 1].getValue());
            TimestampTestBase.assertEquals((long)tss[i], (long)t);
        }
        TimestampTestBase.assertScanContentTimestamp(incommon, tss[0]);
    }

    public static void doTestTimestampScanning(HBaseTestCase.Incommon incommon, HBaseTestCase.FlushCache flusher) throws IOException {
        TimestampTestBase.put(incommon, 10L);
        TimestampTestBase.put(incommon, 100L);
        TimestampTestBase.put(incommon, Long.MAX_VALUE);
        int count = TimestampTestBase.assertScanContentTimestamp(incommon, Long.MAX_VALUE);
        TimestampTestBase.assertEquals((int)count, (int)TimestampTestBase.assertScanContentTimestamp(incommon, 10L));
        TimestampTestBase.assertEquals((int)count, (int)TimestampTestBase.assertScanContentTimestamp(incommon, 100L));
        flusher.flushcache();
        TimestampTestBase.assertEquals((int)count, (int)TimestampTestBase.assertScanContentTimestamp(incommon, 10L));
        TimestampTestBase.assertEquals((int)count, (int)TimestampTestBase.assertScanContentTimestamp(incommon, 100L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int assertScanContentTimestamp(HBaseTestCase.Incommon in, long ts) throws IOException {
        HBaseTestCase.ScannerIncommon scanner = in.getScanner(COLUMNS[0], null, HConstants.EMPTY_START_ROW, ts);
        int count = 0;
        scanner.close();
        return count;
    }

    public static void put(HBaseTestCase.Incommon loader, long ts) throws IOException {
        TimestampTestBase.put(loader, Bytes.toBytes((long)ts), ts);
    }

    public static void put(HBaseTestCase.Incommon loader) throws IOException {
        long ts = Long.MAX_VALUE;
        TimestampTestBase.put(loader, Bytes.toBytes((long)ts), ts);
    }

    public static void put(HBaseTestCase.Incommon loader, byte[] bytes, long ts) throws IOException {
        Put put = new Put(ROW, ts, null);
        put.add(FAMILY_NAME, QUALIFIER_NAME, bytes);
        loader.put(put);
    }

    public static void delete(HBaseTestCase.Incommon loader) throws IOException {
        TimestampTestBase.delete(loader, null);
    }

    public static void delete(HBaseTestCase.Incommon loader, byte[] column) throws IOException {
        TimestampTestBase.delete(loader, column, Long.MAX_VALUE);
    }

    public static void delete(HBaseTestCase.Incommon loader, long ts) throws IOException {
        TimestampTestBase.delete(loader, null, ts);
    }

    public static void delete(HBaseTestCase.Incommon loader, byte[] column, long ts) throws IOException {
        Delete delete = ts == Long.MAX_VALUE ? new Delete(ROW) : new Delete(ROW, ts, null);
        delete.deleteColumn(FAMILY_NAME, QUALIFIER_NAME, ts);
        loader.delete(delete, null, true);
    }

    public static Result get(HBaseTestCase.Incommon loader) throws IOException {
        return loader.get(new Get(ROW));
    }
}

