/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaEditor;
import org.apache.hadoop.hbase.catalog.RootLocationEditor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.Progressable;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestCatalogTracker {
    private static final Log LOG = LogFactory.getLog(TestCatalogTracker.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final HServerAddress HSA = new HServerAddress("example.org:1234");
    private ZooKeeperWatcher watcher;
    private Abortable abortable;

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void afterClass() throws IOException {
        UTIL.getZkCluster().shutdown();
    }

    @Before
    public void before() throws IOException {
        this.abortable = new Abortable(){

            public void abort(String why, Throwable e) {
                LOG.info((Object)why, e);
            }
        };
        this.watcher = new ZooKeeperWatcher(UTIL.getConfiguration(), this.getClass().getSimpleName(), this.abortable);
    }

    @After
    public void after() {
        this.watcher.close();
    }

    private CatalogTracker constructAndStartCatalogTracker() throws IOException, InterruptedException {
        return this.constructAndStartCatalogTracker(null);
    }

    private CatalogTracker constructAndStartCatalogTracker(HConnection c) throws IOException, InterruptedException {
        CatalogTracker ct = new CatalogTracker(this.watcher, null, c, this.abortable, 0);
        ct.start();
        return ct;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThatIfMETAMovesWeAreNotified() throws IOException, InterruptedException, KeeperException {
        HConnection connection = (HConnection)Mockito.mock(HConnection.class);
        this.constructAndStartCatalogTracker(connection);
        try {
            RootLocationEditor.setRootLocation((ZooKeeperWatcher)this.watcher, (HServerAddress)new HServerAddress("example.com:1234"));
        }
        finally {
            RootLocationEditor.deleteRootLocation((ZooKeeperWatcher)this.watcher);
        }
    }

    @Test
    public void testInterruptWaitOnMetaAndRoot() throws IOException, InterruptedException {
        final CatalogTracker ct = this.constructAndStartCatalogTracker();
        HServerAddress hsa = ct.getRootLocation();
        junit.framework.Assert.assertNull((Object)hsa);
        HServerAddress meta = ct.getMetaLocation();
        junit.framework.Assert.assertNull((Object)meta);
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ct.waitForMeta();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Interrupted", e);
                }
            }
        };
        t.start();
        while (!t.isAlive()) {
            Threads.sleep((int)1);
        }
        Threads.sleep((int)1);
        Assert.assertTrue((boolean)t.isAlive());
        ct.stop();
        t.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetMetaServerConnectionFails() throws IOException, InterruptedException, KeeperException {
        HConnection connection = (HConnection)Mockito.mock(HConnection.class);
        ConnectException connectException = new ConnectException("Connection refused");
        HRegionInterface implementation = (HRegionInterface)Mockito.mock(HRegionInterface.class);
        Mockito.when((Object)implementation.get((byte[])Mockito.any(), (Get)Mockito.any())).thenThrow(new Throwable[]{connectException});
        Mockito.when((Object)connection.getHRegionConnection((HServerAddress)Matchers.anyObject(), Matchers.anyBoolean())).thenReturn((Object)implementation);
        junit.framework.Assert.assertNotNull((Object)connection.getHRegionConnection(new HServerAddress(), false));
        CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
        try {
            RootLocationEditor.setRootLocation((ZooKeeperWatcher)this.watcher, (HServerAddress)new HServerAddress("example.com:1234"));
            junit.framework.Assert.assertFalse((boolean)ct.verifyMetaRegionLocation(100L));
        }
        finally {
            RootLocationEditor.deleteRootLocation((ZooKeeperWatcher)this.watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testVerifyRootRegionLocationFails() throws IOException, InterruptedException, KeeperException {
        HConnection connection = (HConnection)Mockito.mock(HConnection.class);
        ConnectException connectException = new ConnectException("Connection refused");
        HRegionInterface implementation = (HRegionInterface)Mockito.mock(HRegionInterface.class);
        Mockito.when((Object)implementation.getRegionInfo((byte[])Mockito.any())).thenThrow(new Throwable[]{connectException});
        Mockito.when((Object)connection.getHRegionConnection((HServerAddress)Matchers.anyObject(), Matchers.anyBoolean())).thenReturn((Object)implementation);
        junit.framework.Assert.assertNotNull((Object)connection.getHRegionConnection(new HServerAddress(), false));
        CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
        try {
            RootLocationEditor.setRootLocation((ZooKeeperWatcher)this.watcher, (HServerAddress)new HServerAddress("example.com:1234"));
            junit.framework.Assert.assertFalse((boolean)ct.verifyRootRegionLocation(100L));
        }
        finally {
            RootLocationEditor.deleteRootLocation((ZooKeeperWatcher)this.watcher);
        }
    }

    @Test(expected=NotAllMetaRegionsOnlineException.class)
    public void testTimeoutWaitForRoot() throws IOException, InterruptedException {
        CatalogTracker ct = this.constructAndStartCatalogTracker();
        ct.waitForRoot(100L);
    }

    @Test(expected=NotAllMetaRegionsOnlineException.class)
    public void testTimeoutWaitForMeta() throws IOException, InterruptedException {
        CatalogTracker ct = this.constructAndStartCatalogTracker();
        ct.waitForMeta(100L);
    }

    @Test
    public void testNoTimeoutWaitForRoot() throws IOException, InterruptedException, KeeperException {
        CatalogTracker ct = this.constructAndStartCatalogTracker();
        HServerAddress hsa = ct.getRootLocation();
        junit.framework.Assert.assertNull((Object)hsa);
        WaitOnMetaThread t = new WaitOnMetaThread(ct);
        this.startWaitAliveThenWaitItLives(t, 1000);
        hsa = this.setRootLocation();
        t.join();
        junit.framework.Assert.assertTrue((boolean)ct.getRootLocation().equals((Object)hsa));
    }

    private HServerAddress setRootLocation() throws KeeperException {
        RootLocationEditor.setRootLocation((ZooKeeperWatcher)this.watcher, (HServerAddress)HSA);
        return HSA;
    }

    @Test
    public void testNoTimeoutWaitForMeta() throws IOException, InterruptedException, KeeperException {
        HConnection connection = (HConnection)Mockito.mock(HConnection.class);
        HRegionInterface mockHRI = (HRegionInterface)Mockito.mock(HRegionInterface.class);
        Mockito.when((Object)connection.getHRegionConnection((HServerAddress)Mockito.any(), Mockito.anyBoolean())).thenReturn((Object)mockHRI);
        CatalogTracker ct = this.constructAndStartCatalogTracker(connection);
        HServerAddress hsa = ct.getMetaLocation();
        junit.framework.Assert.assertNull((Object)hsa);
        WaitOnMetaThread t = new WaitOnMetaThread(ct){

            @Override
            void doWaiting() throws InterruptedException {
                this.ct.waitForMeta();
            }
        };
        this.startWaitAliveThenWaitItLives(t, 1000);
        ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
        kvs.add(new KeyValue(HConstants.EMPTY_BYTE_ARRAY, HConstants.CATALOG_FAMILY, HConstants.SERVER_QUALIFIER, Bytes.toBytes((String)HSA.toString())));
        Result result = new Result(kvs);
        Mockito.when((Object)mockHRI.get((byte[])Mockito.any(), (Get)Mockito.any())).thenReturn((Object)result);
        Mockito.when((Object)mockHRI.getRegionInfo((byte[])Mockito.any())).thenReturn((Object)HRegionInfo.FIRST_META_REGIONINFO);
        String node = ct.getMetaNodeTracker().getNode();
        ZKUtil.createAndFailSilent((ZooKeeperWatcher)this.watcher, (String)node);
        MetaEditor.updateMetaLocation((CatalogTracker)ct, (HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO, (HServerInfo)new HServerInfo(HSA, -1, "example.com"));
        ZKUtil.deleteNode((ZooKeeperWatcher)this.watcher, (String)node);
        t.join();
        junit.framework.Assert.assertTrue((boolean)ct.getMetaLocation().equals((Object)HSA));
    }

    private void startWaitAliveThenWaitItLives(Thread t, int ms) {
        t.start();
        while (!t.isAlive()) {
        }
        Threads.sleep((int)ms);
        junit.framework.Assert.assertTrue((String)("Assert " + t.getName() + " still waiting"), (boolean)t.isAlive());
    }

    class WaitOnMetaThread
    extends Thread {
        final CatalogTracker ct;

        WaitOnMetaThread(CatalogTracker ct) {
            super("WaitOnMeta");
            this.ct = ct;
        }

        @Override
        public void run() {
            try {
                this.doWaiting();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed wait", e);
            }
            LOG.info((Object)("Exiting " + this.getName()));
        }

        void doWaiting() throws InterruptedException {
            this.ct.waitForRoot();
        }
    }

    class CountingProgressable
    implements Progressable {
        final AtomicInteger counter = new AtomicInteger(0);

        CountingProgressable() {
        }

        public void progress() {
            this.counter.incrementAndGet();
        }
    }
}

