/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.catalog.RootLocationEditor;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Test;

public class TestCatalogTrackerOnCluster {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestCatalogTrackerOnCluster.class);

    @Test
    public void testBadOriginalRootLocation() throws Exception {
        UTIL.getConfiguration().setInt("ipc.socket.timeout", 3000);
        UTIL.startMiniCluster();
        UTIL.shutdownMiniHBaseCluster();
        ZooKeeperWatcher zookeeper = new ZooKeeperWatcher(UTIL.getConfiguration(), "Bad Root Location Writer", new Abortable(){

            public void abort(String why, Throwable e) {
                LOG.error((Object)"Abort was called on 'bad root location writer'", e);
            }
        });
        HServerAddress nonsense = new HServerAddress("example.org:1234");
        RootLocationEditor.setRootLocation((ZooKeeperWatcher)zookeeper, (HServerAddress)nonsense);
        UTIL.startMiniHBaseCluster(1, 1);
        UTIL.shutdownMiniCluster();
    }
}

