/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.catalog;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestMetaReaderEditor {
    private static final Log LOG = LogFactory.getLog(TestMetaReaderEditor.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private ZooKeeperWatcher zkw;
    private CatalogTracker ct;
    private static final Abortable ABORTABLE = new Abortable(){
        private final AtomicBoolean abort = new AtomicBoolean(false);

        public void abort(String why, Throwable e) {
            LOG.info((Object)why, e);
            this.abort.set(true);
        }
    };

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster();
    }

    @Before
    public void setup() throws IOException, InterruptedException {
        Configuration c = new Configuration(UTIL.getConfiguration());
        this.zkw = new ZooKeeperWatcher(c, "TestMetaReaderEditor", ABORTABLE);
        this.ct = new CatalogTracker(this.zkw, c, ABORTABLE);
        this.ct.start();
    }

    @AfterClass
    public static void afterClass() throws IOException {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testGetRegionsCatalogTables() throws IOException, InterruptedException {
        List regions = MetaReader.getTableRegions((CatalogTracker)this.ct, (byte[])HConstants.META_TABLE_NAME);
        Assert.assertTrue((regions.size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((MetaReader.getTableRegionsAndLocations((CatalogTracker)this.ct, (String)Bytes.toString((byte[])HConstants.META_TABLE_NAME)).size() >= 1 ? 1 : 0) != 0);
        Assert.assertTrue((MetaReader.getTableRegionsAndLocations((CatalogTracker)this.ct, (String)Bytes.toString((byte[])HConstants.ROOT_TABLE_NAME)).size() == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testTableExists() throws IOException {
        String name = "testTableExists";
        byte[] nameBytes = Bytes.toBytes((String)"testTableExists");
        Assert.assertFalse((boolean)MetaReader.tableExists((CatalogTracker)this.ct, (String)"testTableExists"));
        UTIL.createTable(nameBytes, HConstants.CATALOG_FAMILY);
        Assert.assertTrue((boolean)MetaReader.tableExists((CatalogTracker)this.ct, (String)"testTableExists"));
        HBaseAdmin admin = UTIL.getHBaseAdmin();
        admin.disableTable("testTableExists");
        admin.deleteTable("testTableExists");
        Assert.assertFalse((boolean)MetaReader.tableExists((CatalogTracker)this.ct, (String)"testTableExists"));
        Assert.assertTrue((boolean)MetaReader.tableExists((CatalogTracker)this.ct, (String)Bytes.toString((byte[])HConstants.META_TABLE_NAME)));
        Assert.assertTrue((boolean)MetaReader.tableExists((CatalogTracker)this.ct, (String)Bytes.toString((byte[])HConstants.ROOT_TABLE_NAME)));
    }

    @Test
    public void testGetRegion() throws IOException, InterruptedException {
        String name = "testGetRegion";
        LOG.info((Object)"Started testGetRegion");
        byte[] nameBytes = Bytes.toBytes((String)"testGetRegion");
        HTable t = UTIL.createTable(nameBytes, HConstants.CATALOG_FAMILY);
        int regionCount = UTIL.createMultiRegions(t, HConstants.CATALOG_FAMILY);
        List regions = MetaReader.getTableRegions((CatalogTracker)this.ct, (byte[])nameBytes);
        Assert.assertEquals((long)regionCount, (long)regions.size());
        Pair pair = MetaReader.getRegion((CatalogTracker)this.ct, (byte[])((HRegionInfo)regions.get(0)).getRegionName());
        Assert.assertEquals((Object)((HRegionInfo)regions.get(0)).getEncodedName(), (Object)((HRegionInfo)pair.getFirst()).getEncodedName());
        pair = MetaReader.getRegion((CatalogTracker)this.ct, (byte[])Bytes.toBytes((String)"nonexistent-region"));
        Assert.assertNull((Object)pair);
        pair = MetaReader.getRegion((CatalogTracker)this.ct, (byte[])HRegionInfo.FIRST_META_REGIONINFO.getRegionName());
        Assert.assertEquals((Object)HRegionInfo.FIRST_META_REGIONINFO.getEncodedName(), (Object)((HRegionInfo)pair.getFirst()).getEncodedName());
        LOG.info((Object)"Finished testGetRegion");
    }

    @Test
    public void testScanMetaForTable() throws IOException {
        String name = "testScanMetaForTable";
        LOG.info((Object)"Started testScanMetaForTable");
        UTIL.createTable(Bytes.toBytes((String)"testScanMetaForTable"), HConstants.CATALOG_FAMILY);
        for (int i = 3; i < 3; ++i) {
            UTIL.createTable(Bytes.toBytes((String)("testScanMetaForTable" + i)), HConstants.CATALOG_FAMILY);
        }
        byte[] greaterName = Bytes.toBytes((String)"testScanMetaForTablf");
        UTIL.createTable(greaterName, HConstants.CATALOG_FAMILY);
        Assert.assertEquals((long)1L, (long)MetaReader.getTableRegions((CatalogTracker)this.ct, (byte[])Bytes.toBytes((String)"testScanMetaForTable")).size());
        for (int i = 3; i < 3; ++i) {
            Assert.assertEquals((long)1L, (long)MetaReader.getTableRegions((CatalogTracker)this.ct, (byte[])Bytes.toBytes((String)("testScanMetaForTable" + i))).size());
        }
        Assert.assertEquals((long)1L, (long)MetaReader.getTableRegions((CatalogTracker)this.ct, (byte[])greaterName).size());
    }
}

