/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestMetaScanner {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMetaScanner() throws Exception {
        this.LOG.info((Object)"Starting testMetaScanner");
        byte[] TABLENAME = Bytes.toBytes((String)"testMetaScanner");
        byte[] FAMILY = Bytes.toBytes((String)"family");
        TEST_UTIL.createTable(TABLENAME, FAMILY);
        Configuration conf = TEST_UTIL.getConfiguration();
        HTable table = new HTable(conf, TABLENAME);
        TEST_UTIL.createMultiRegions(conf, table, FAMILY, new byte[][]{HConstants.EMPTY_START_ROW, Bytes.toBytes((String)"region_a"), Bytes.toBytes((String)"region_b")});
        TEST_UTIL.countRows(table);
        MetaScanner.MetaScannerVisitor visitor = (MetaScanner.MetaScannerVisitor)Mockito.mock(MetaScanner.MetaScannerVisitor.class);
        ((MetaScanner.MetaScannerVisitor)Mockito.doReturn((Object)true).when((Object)visitor)).processRow((Result)Mockito.anyObject());
        MetaScanner.metaScan((Configuration)conf, (MetaScanner.MetaScannerVisitor)visitor, (byte[])TABLENAME);
        ((MetaScanner.MetaScannerVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)3))).processRow((Result)Mockito.anyObject());
        Mockito.reset((Object[])new MetaScanner.MetaScannerVisitor[]{visitor});
        ((MetaScanner.MetaScannerVisitor)Mockito.doReturn((Object)true).when((Object)visitor)).processRow((Result)Mockito.anyObject());
        MetaScanner.metaScan((Configuration)conf, (MetaScanner.MetaScannerVisitor)visitor, (byte[])TABLENAME, (byte[])HConstants.EMPTY_BYTE_ARRAY, (int)1000);
        ((MetaScanner.MetaScannerVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)3))).processRow((Result)Mockito.anyObject());
        Mockito.reset((Object[])new MetaScanner.MetaScannerVisitor[]{visitor});
        ((MetaScanner.MetaScannerVisitor)Mockito.doReturn((Object)true).when((Object)visitor)).processRow((Result)Mockito.anyObject());
        MetaScanner.metaScan((Configuration)conf, (MetaScanner.MetaScannerVisitor)visitor, (byte[])TABLENAME, (byte[])Bytes.toBytes((String)"region_ac"), (int)1000);
        ((MetaScanner.MetaScannerVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)2))).processRow((Result)Mockito.anyObject());
        Mockito.reset((Object[])new MetaScanner.MetaScannerVisitor[]{visitor});
        ((MetaScanner.MetaScannerVisitor)Mockito.doReturn((Object)true).when((Object)visitor)).processRow((Result)Mockito.anyObject());
        MetaScanner.metaScan((Configuration)conf, (MetaScanner.MetaScannerVisitor)visitor, (byte[])TABLENAME, (byte[])Bytes.toBytes((String)"region_ac"), (int)1);
        ((MetaScanner.MetaScannerVisitor)Mockito.verify((Object)visitor, (VerificationMode)Mockito.times((int)1))).processRow((Result)Mockito.anyObject());
    }
}

