/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class TestResult
extends TestCase {
    static final byte[] row = Bytes.toBytes((String)"row");
    static final byte[] family = Bytes.toBytes((String)"family");
    static final byte[] value = Bytes.toBytes((String)"value");

    static KeyValue[] genKVs(byte[] row, byte[] family, byte[] value, long timestamp, int cols) {
        KeyValue[] kvs = new KeyValue[cols];
        for (int i = 0; i < cols; ++i) {
            kvs[i] = new KeyValue(row, family, Bytes.toBytes((int)i), timestamp, Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i)));
        }
        return kvs;
    }

    public void testBasic() throws Exception {
        KeyValue[] kvs = TestResult.genKVs(row, family, value, 1L, 100);
        Arrays.sort(kvs, KeyValue.COMPARATOR);
        Result r = new Result(kvs);
        for (int i = 0; i < 100; ++i) {
            byte[] qf = Bytes.toBytes((int)i);
            List ks = r.getColumn(family, qf);
            TestResult.assertEquals((int)1, (int)ks.size());
            HBaseTestCase.assertByteEquals(qf, ((KeyValue)ks.get(0)).getQualifier());
            TestResult.assertEquals(ks.get(0), (Object)r.getColumnLatest(family, qf));
            HBaseTestCase.assertByteEquals(Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i)), r.getValue(family, qf));
            TestResult.assertTrue((boolean)r.containsColumn(family, qf));
        }
    }

    public void testMultiVersion() throws Exception {
        KeyValue[] kvs1 = TestResult.genKVs(row, family, value, 1L, 100);
        KeyValue[] kvs2 = TestResult.genKVs(row, family, value, 200L, 100);
        KeyValue[] kvs = new KeyValue[kvs1.length + kvs2.length];
        System.arraycopy(kvs1, 0, kvs, 0, kvs1.length);
        System.arraycopy(kvs2, 0, kvs, kvs1.length, kvs2.length);
        Arrays.sort(kvs, KeyValue.COMPARATOR);
        Result r = new Result(kvs);
        for (int i = 0; i < 100; ++i) {
            byte[] qf = Bytes.toBytes((int)i);
            List ks = r.getColumn(family, qf);
            TestResult.assertEquals((int)2, (int)ks.size());
            HBaseTestCase.assertByteEquals(qf, ((KeyValue)ks.get(0)).getQualifier());
            TestResult.assertEquals((long)200L, (long)((KeyValue)ks.get(0)).getTimestamp());
            TestResult.assertEquals(ks.get(0), (Object)r.getColumnLatest(family, qf));
            HBaseTestCase.assertByteEquals(Bytes.add((byte[])value, (byte[])Bytes.toBytes((int)i)), r.getValue(family, qf));
            TestResult.assertTrue((boolean)r.containsColumn(family, qf));
        }
    }

    public void testCompareResults() throws Exception {
        byte[] value1 = Bytes.toBytes((String)"value1");
        byte[] qual = Bytes.toBytes((String)"qual");
        KeyValue kv1 = new KeyValue(row, family, qual, value);
        KeyValue kv2 = new KeyValue(row, family, qual, value1);
        Result r1 = new Result(new KeyValue[]{kv1});
        Result r2 = new Result(new KeyValue[]{kv2});
        Result.compareResults((Result)r1, (Result)r1);
        try {
            Result.compareResults((Result)r1, (Result)r2);
            TestResult.fail();
        }
        catch (Exception x) {
            TestResult.assertTrue((boolean)x.getMessage().startsWith("This result was different:"));
        }
    }
}

