/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class TestPrefixFilter
extends TestCase {
    Filter mainFilter;
    static final char FIRST_CHAR = 'a';
    static final char LAST_CHAR = 'e';
    static final String HOST_PREFIX = "org.apache.site-";
    static byte[] GOOD_BYTES = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.mainFilter = new PrefixFilter(Bytes.toBytes((String)HOST_PREFIX));
    }

    public void testPrefixOnRow() throws Exception {
        this.prefixRowTests(this.mainFilter);
    }

    public void testPrefixOnRowInsideWhileMatchRow() throws Exception {
        this.prefixRowTests((Filter)new WhileMatchFilter(this.mainFilter), true);
    }

    public void testSerialization() throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(stream);
        this.mainFilter.write((DataOutput)out);
        out.close();
        byte[] buffer = stream.toByteArray();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(buffer));
        PrefixFilter newFilter = new PrefixFilter();
        newFilter.readFields((DataInput)in);
        this.prefixRowTests((Filter)newFilter);
    }

    private void prefixRowTests(Filter filter) throws Exception {
        this.prefixRowTests(filter, false);
    }

    private void prefixRowTests(Filter filter, boolean lastFilterAllRemaining) throws Exception {
        for (char c = 'a'; c <= 'e'; c = (char)(c + '\u0001')) {
            byte[] t = this.createRow(c);
            TestPrefixFilter.assertFalse((String)("Failed with character " + c), (boolean)filter.filterRowKey(t, 0, t.length));
            TestPrefixFilter.assertFalse((boolean)filter.filterAllRemaining());
        }
        String yahooSite = "com.yahoo.www";
        byte[] yahooSiteBytes = Bytes.toBytes((String)yahooSite);
        TestPrefixFilter.assertTrue((String)("Failed with character " + yahooSite), (boolean)filter.filterRowKey(yahooSiteBytes, 0, yahooSiteBytes.length));
        TestPrefixFilter.assertEquals((boolean)filter.filterAllRemaining(), (boolean)lastFilterAllRemaining);
    }

    private byte[] createRow(char c) {
        return Bytes.toBytes((String)(HOST_PREFIX + Character.toString(c)));
    }

    static {
        try {
            GOOD_BYTES = "abc".getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            TestPrefixFilter.fail();
        }
    }
}

