/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import junit.framework.TestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.SingleColumnValueExcludeFilter;
import org.apache.hadoop.hbase.util.Bytes;

public class TestSingleColumnValueExcludeFilter
extends TestCase {
    private static final byte[] ROW = Bytes.toBytes((String)"test");
    private static final byte[] COLUMN_FAMILY = Bytes.toBytes((String)"test");
    private static final byte[] COLUMN_QUALIFIER = Bytes.toBytes((String)"foo");
    private static final byte[] COLUMN_QUALIFIER_2 = Bytes.toBytes((String)"foo_2");
    private static final byte[] VAL_1 = Bytes.toBytes((String)"a");
    private static final byte[] VAL_2 = Bytes.toBytes((String)"ab");

    public void testFilterKeyValue() throws Exception {
        SingleColumnValueExcludeFilter filter = new SingleColumnValueExcludeFilter(COLUMN_FAMILY, COLUMN_QUALIFIER, CompareFilter.CompareOp.EQUAL, VAL_1);
        KeyValue kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1);
        TestSingleColumnValueExcludeFilter.assertTrue((String)"otherColumn", (filter.filterKeyValue(kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_1);
        TestSingleColumnValueExcludeFilter.assertTrue((String)"testedMatch", (filter.filterKeyValue(kv) == Filter.ReturnCode.SKIP ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1);
        TestSingleColumnValueExcludeFilter.assertTrue((String)"otherColumn", (filter.filterKeyValue(kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        TestSingleColumnValueExcludeFilter.assertFalse((String)"allRemainingWhenMatch", (boolean)filter.filterAllRemaining());
        filter.reset();
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1);
        TestSingleColumnValueExcludeFilter.assertTrue((String)"otherColumn", (filter.filterKeyValue(kv) == Filter.ReturnCode.INCLUDE ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER, VAL_2);
        TestSingleColumnValueExcludeFilter.assertTrue((String)"testedMismatch", (filter.filterKeyValue(kv) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
        kv = new KeyValue(ROW, COLUMN_FAMILY, COLUMN_QUALIFIER_2, VAL_1);
        TestSingleColumnValueExcludeFilter.assertTrue((String)"otherColumn", (filter.filterKeyValue(kv) == Filter.ReturnCode.NEXT_ROW ? 1 : 0) != 0);
    }
}

