/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.HalfStoreFileReader;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;

public class TestHalfStoreFileReader {
    static final int SIZE = 1000;

    @Test
    public void testHalfScanAndReseek() throws IOException {
        HBaseTestingUtility test_util = new HBaseTestingUtility();
        String root_dir = HBaseTestingUtility.getTestDir("TestHalfStoreFile").toString();
        Path p = new Path(root_dir, "test");
        FileSystem fs = FileSystem.get((Configuration)test_util.getConfiguration());
        HFile.Writer w = new HFile.Writer(fs, p, 1024, "none", KeyValue.KEY_COMPARATOR);
        List<KeyValue> items = this.genSomeKeys();
        for (KeyValue kv : items) {
            w.append(kv);
        }
        w.close();
        HFile.Reader r = new HFile.Reader(fs, p, null, false);
        r.loadFileInfo();
        byte[] midkey = r.midkey();
        KeyValue midKV = KeyValue.createKeyValueFromKey((byte[])midkey);
        midkey = midKV.getRow();
        Reference bottom = new Reference(midkey, Reference.Range.bottom);
        this.doTestOfScanAndReseek(p, fs, bottom);
        Reference top = new Reference(midkey, Reference.Range.top);
        this.doTestOfScanAndReseek(p, fs, top);
    }

    private void doTestOfScanAndReseek(Path p, FileSystem fs, Reference bottom) throws IOException {
        KeyValue curr;
        HalfStoreFileReader halfreader = new HalfStoreFileReader(fs, p, null, bottom);
        halfreader.loadFileInfo();
        HFileScanner scanner = halfreader.getScanner(false, false);
        scanner.seekTo();
        do {
            curr = scanner.getKeyValue();
            KeyValue reseekKv = this.getLastOnCol(curr);
            int ret = scanner.reseekTo(reseekKv.getKey());
            Assert.assertTrue((String)("reseek to returned: " + ret), (ret > 0 ? 1 : 0) != 0);
        } while (scanner.next());
        int ret = scanner.reseekTo(this.getLastOnCol(curr).getKey());
        Assert.assertTrue((ret > 0 ? 1 : 0) != 0);
    }

    private KeyValue getLastOnCol(KeyValue curr) {
        return KeyValue.createLastOnRow((byte[])curr.getBuffer(), (int)curr.getRowOffset(), (int)curr.getRowLength(), (byte[])curr.getBuffer(), (int)curr.getFamilyOffset(), (int)curr.getFamilyLength(), (byte[])curr.getBuffer(), (int)curr.getQualifierOffset(), (int)curr.getQualifierLength());
    }

    static byte[] _b(String s) {
        return Bytes.toBytes((String)s);
    }

    List<KeyValue> genSomeKeys() {
        ArrayList<KeyValue> ret = new ArrayList<KeyValue>(1000);
        for (int i = 0; i < 1000; ++i) {
            KeyValue kv = new KeyValue(TestHalfStoreFileReader._b(String.format("row_%04d", i)), TestHalfStoreFileReader._b("family"), TestHalfStoreFileReader._b("qualifier"), 1000L, TestHalfStoreFileReader._b("value"));
            ret.add(kv);
        }
        return ret;
    }
}

