/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.io.HbaseObjectWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparator;
import org.junit.Assert;

public class TestHbaseObjectWritable
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testReadObjectDataInputConfiguration() throws IOException {
        Configuration conf = HBaseConfiguration.create();
        int COUNT = 101;
        TestHbaseObjectWritable.assertTrue((boolean)this.doType(conf, 101, Integer.TYPE).equals(101));
        byte[] testing = "testing".getBytes();
        byte[] result = (byte[])this.doType(conf, testing, testing.getClass());
        TestHbaseObjectWritable.assertTrue((WritableComparator.compareBytes((byte[])testing, (int)0, (int)testing.length, (byte[])result, (int)0, (int)result.length) == 0 ? 1 : 0) != 0);
        boolean exception = false;
        try {
            this.doType(conf, new Object(), Object.class);
        }
        catch (UnsupportedOperationException uoe) {
            exception = true;
        }
        TestHbaseObjectWritable.assertTrue((boolean)exception);
        int A = 65;
        byte[] bytes = new byte[]{65};
        Object obj = this.doType(conf, bytes, byte[].class);
        TestHbaseObjectWritable.assertTrue((((byte[])obj)[0] == 65 ? 1 : 0) != 0);
        obj = this.doType(conf, new Text(""), Text.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof Text));
        ArrayList<String> list = new ArrayList<String>();
        list.add("hello");
        list.add("world");
        list.add("universe");
        obj = this.doType(conf, list, List.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof List));
        Assert.assertArrayEquals((Object[])list.toArray(), (Object[])((List)obj).toArray());
        ArrayList<String> arr = new ArrayList<String>();
        arr.add("hello");
        arr.add("world");
        arr.add("universe");
        obj = this.doType(conf, arr, ArrayList.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof ArrayList));
        Assert.assertArrayEquals((Object[])list.toArray(), (Object[])((ArrayList)obj).toArray());
        obj = this.doType(conf, new PrefixFilter(HConstants.EMPTY_BYTE_ARRAY), PrefixFilter.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof PrefixFilter));
    }

    public void testCustomWritable() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        CustomWritable custom = new CustomWritable("test phrase");
        Object obj = this.doType(conf, custom, CustomWritable.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof Writable));
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof CustomWritable));
        TestHbaseObjectWritable.assertEquals((String)"test phrase", (String)((CustomWritable)obj).getValue());
        CustomFilter filt = new CustomFilter("mykey");
        FilterList filtlist = new FilterList(FilterList.Operator.MUST_PASS_ALL);
        filtlist.addFilter((Filter)filt);
        obj = this.doType(conf, filtlist, FilterList.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof FilterList));
        TestHbaseObjectWritable.assertNotNull((Object)((FilterList)obj).getFilters());
        TestHbaseObjectWritable.assertEquals((int)1, (int)((FilterList)obj).getFilters().size());
        Filter child = (Filter)((FilterList)obj).getFilters().get(0);
        TestHbaseObjectWritable.assertTrue((boolean)(child instanceof CustomFilter));
        TestHbaseObjectWritable.assertEquals((String)"mykey", (String)((CustomFilter)child).getKey());
    }

    public void testCustomSerializable() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        CustomSerializable custom = new CustomSerializable("test phrase");
        Object obj = this.doType(conf, custom, CustomSerializable.class);
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof Serializable));
        TestHbaseObjectWritable.assertTrue((boolean)(obj instanceof CustomSerializable));
        TestHbaseObjectWritable.assertEquals((String)"test phrase", (String)((CustomSerializable)obj).getValue());
    }

    private Object doType(Configuration conf, Object value, Class<?> clazz) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteStream);
        HbaseObjectWritable.writeObject((DataOutput)out, (Object)value, clazz, (Configuration)conf);
        out.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(byteStream.toByteArray());
        DataInputStream dis = new DataInputStream(bais);
        Object product = HbaseObjectWritable.readObject((DataInput)dis, (Configuration)conf);
        dis.close();
        return product;
    }

    public static class CustomFilter
    extends FilterBase {
        private String key = null;

        public CustomFilter() {
        }

        public CustomFilter(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.key);
        }

        public void readFields(DataInput in) throws IOException {
            this.key = Text.readString((DataInput)in);
        }
    }

    public static class CustomWritable
    implements Writable {
        private String value = null;

        public CustomWritable() {
        }

        public CustomWritable(String val) {
            this.value = val;
        }

        public String getValue() {
            return this.value;
        }

        public void write(DataOutput out) throws IOException {
            Text.writeString((DataOutput)out, (String)this.value);
        }

        public void readFields(DataInput in) throws IOException {
            this.value = Text.readString((DataInput)in);
        }
    }

    public static class CustomSerializable
    implements Serializable {
        private static final long serialVersionUID = 1048445561865740632L;
        private String value = null;

        public CustomSerializable() {
        }

        public CustomSerializable(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

