/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.io.hfile.CachedBlockQueue;

public class TestCachedBlockQueue
extends TestCase {
    public void testQueue() throws Exception {
        CachedBlock cb1 = new CachedBlock(1000L, "cb1", 1L);
        CachedBlock cb2 = new CachedBlock(1500L, "cb2", 2L);
        CachedBlock cb3 = new CachedBlock(1000L, "cb3", 3L);
        CachedBlock cb4 = new CachedBlock(1500L, "cb4", 4L);
        CachedBlock cb5 = new CachedBlock(1000L, "cb5", 5L);
        CachedBlock cb6 = new CachedBlock(1750L, "cb6", 6L);
        CachedBlock cb7 = new CachedBlock(1000L, "cb7", 7L);
        CachedBlock cb8 = new CachedBlock(1500L, "cb8", 8L);
        CachedBlock cb9 = new CachedBlock(1000L, "cb9", 9L);
        CachedBlock cb10 = new CachedBlock(1500L, "cb10", 10L);
        CachedBlockQueue queue = new CachedBlockQueue(10000L, 1000L);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb1);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb2);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb3);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb4);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb5);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb6);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb7);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb8);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb9);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb10);
        long expectedSize = cb1.heapSize() + cb2.heapSize() + cb3.heapSize() + cb4.heapSize() + cb5.heapSize() + cb6.heapSize() + cb7.heapSize() + cb8.heapSize();
        TestCachedBlockQueue.assertEquals((long)queue.heapSize(), (long)expectedSize);
        LinkedList blocks = queue.get();
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb1");
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb2");
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb3");
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb4");
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb5");
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb6");
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb7");
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb8");
    }

    public void testQueueSmallBlockEdgeCase() throws Exception {
        CachedBlock cb1 = new CachedBlock(1000L, "cb1", 1L);
        CachedBlock cb2 = new CachedBlock(1500L, "cb2", 2L);
        CachedBlock cb3 = new CachedBlock(1000L, "cb3", 3L);
        CachedBlock cb4 = new CachedBlock(1500L, "cb4", 4L);
        CachedBlock cb5 = new CachedBlock(1000L, "cb5", 5L);
        CachedBlock cb6 = new CachedBlock(1750L, "cb6", 6L);
        CachedBlock cb7 = new CachedBlock(1000L, "cb7", 7L);
        CachedBlock cb8 = new CachedBlock(1500L, "cb8", 8L);
        CachedBlock cb9 = new CachedBlock(1000L, "cb9", 9L);
        CachedBlock cb10 = new CachedBlock(1500L, "cb10", 10L);
        CachedBlockQueue queue = new CachedBlockQueue(10000L, 1000L);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb1);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb2);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb3);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb4);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb5);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb6);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb7);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb8);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb9);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb10);
        CachedBlock cb0 = new CachedBlock(10L + CachedBlock.PER_BLOCK_OVERHEAD, "cb0", 0L);
        queue.add((org.apache.hadoop.hbase.io.hfile.CachedBlock)cb0);
        long expectedSize = cb1.heapSize() + cb2.heapSize() + cb3.heapSize() + cb4.heapSize() + cb5.heapSize() + cb6.heapSize() + cb7.heapSize() + cb8.heapSize() + cb0.heapSize();
        TestCachedBlockQueue.assertEquals((long)queue.heapSize(), (long)expectedSize);
        LinkedList blocks = queue.get();
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb0");
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb1");
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb2");
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb3");
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb4");
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb5");
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb6");
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb7");
        TestCachedBlockQueue.assertEquals((String)((org.apache.hadoop.hbase.io.hfile.CachedBlock)blocks.poll()).getName(), (String)"cb8");
    }

    private static class CachedBlock
    extends org.apache.hadoop.hbase.io.hfile.CachedBlock {
        public CachedBlock(long heapSize, String name, long accessTime) {
            super(name, ByteBuffer.allocate((int)(heapSize - PER_BLOCK_OVERHEAD)), accessTime, false);
        }
    }
}

