/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.Bytes;

public class TestSeekTo
extends HBaseTestCase {
    static KeyValue toKV(String row) {
        return new KeyValue(Bytes.toBytes((String)row), Bytes.toBytes((String)"family"), Bytes.toBytes((String)"qualifier"), Bytes.toBytes((String)"value"));
    }

    static String toRowStr(KeyValue kv) {
        return Bytes.toString((byte[])kv.getRow());
    }

    Path makeNewFile() throws IOException {
        Path ncTFile = new Path(this.testDir, "basic.hfile");
        FSDataOutputStream fout = this.fs.create(ncTFile);
        int blocksize = TestSeekTo.toKV("a").getLength() * 3;
        HFile.Writer writer = new HFile.Writer(fout, blocksize, "none", null);
        writer.append(TestSeekTo.toKV("c"));
        writer.append(TestSeekTo.toKV("e"));
        writer.append(TestSeekTo.toKV("g"));
        writer.append(TestSeekTo.toKV("i"));
        writer.append(TestSeekTo.toKV("k"));
        writer.close();
        fout.close();
        return ncTFile;
    }

    public void testSeekBefore() throws Exception {
        Path p = this.makeNewFile();
        HFile.Reader reader = new HFile.Reader(this.fs, p, null, false);
        reader.loadFileInfo();
        HFileScanner scanner = reader.getScanner(false, true);
        TestSeekTo.assertEquals((boolean)false, (boolean)scanner.seekBefore(TestSeekTo.toKV("a").getKey()));
        TestSeekTo.assertEquals((boolean)false, (boolean)scanner.seekBefore(TestSeekTo.toKV("c").getKey()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(TestSeekTo.toKV("d").getKey()));
        TestSeekTo.assertEquals((String)"c", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(TestSeekTo.toKV("e").getKey()));
        TestSeekTo.assertEquals((String)"c", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(TestSeekTo.toKV("f").getKey()));
        TestSeekTo.assertEquals((String)"e", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(TestSeekTo.toKV("g").getKey()));
        TestSeekTo.assertEquals((String)"e", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(TestSeekTo.toKV("h").getKey()));
        TestSeekTo.assertEquals((String)"g", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(TestSeekTo.toKV("i").getKey()));
        TestSeekTo.assertEquals((String)"g", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(TestSeekTo.toKV("j").getKey()));
        TestSeekTo.assertEquals((String)"i", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(TestSeekTo.toKV("k").getKey()));
        TestSeekTo.assertEquals((String)"i", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((boolean)true, (boolean)scanner.seekBefore(TestSeekTo.toKV("l").getKey()));
        TestSeekTo.assertEquals((String)"k", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
    }

    public void testSeekTo() throws Exception {
        Path p = this.makeNewFile();
        HFile.Reader reader = new HFile.Reader(this.fs, p, null, false);
        reader.loadFileInfo();
        TestSeekTo.assertEquals((int)2, (int)reader.blockIndex.count);
        HFileScanner scanner = reader.getScanner(false, true);
        TestSeekTo.assertEquals((int)-1, (int)scanner.seekTo(TestSeekTo.toKV("a").getKey()));
        TestSeekTo.assertEquals((int)1, (int)scanner.seekTo(TestSeekTo.toKV("d").getKey()));
        TestSeekTo.assertEquals((String)"c", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)1, (int)scanner.seekTo(TestSeekTo.toKV("h").getKey()));
        TestSeekTo.assertEquals((String)"g", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
        TestSeekTo.assertEquals((int)1, (int)scanner.seekTo(TestSeekTo.toKV("l").getKey()));
        TestSeekTo.assertEquals((String)"k", (String)TestSeekTo.toRowStr(scanner.getKeyValue()));
    }

    public void testBlockContainingKey() throws Exception {
        Path p = this.makeNewFile();
        HFile.Reader reader = new HFile.Reader(this.fs, p, null, false);
        reader.loadFileInfo();
        System.out.println(reader.blockIndex.toString());
        int klen = TestSeekTo.toKV("a").getKey().length;
        TestSeekTo.assertEquals((int)-1, (int)reader.blockIndex.blockContainingKey(TestSeekTo.toKV("a").getKey(), 0, klen));
        TestSeekTo.assertEquals((int)0, (int)reader.blockIndex.blockContainingKey(TestSeekTo.toKV("c").getKey(), 0, klen));
        TestSeekTo.assertEquals((int)0, (int)reader.blockIndex.blockContainingKey(TestSeekTo.toKV("d").getKey(), 0, klen));
        TestSeekTo.assertEquals((int)0, (int)reader.blockIndex.blockContainingKey(TestSeekTo.toKV("e").getKey(), 0, klen));
        TestSeekTo.assertEquals((int)0, (int)reader.blockIndex.blockContainingKey(TestSeekTo.toKV("g").getKey(), 0, klen));
        TestSeekTo.assertEquals((int)0, (int)reader.blockIndex.blockContainingKey(TestSeekTo.toKV("h").getKey(), 0, klen));
        TestSeekTo.assertEquals((int)1, (int)reader.blockIndex.blockContainingKey(TestSeekTo.toKV("i").getKey(), 0, klen));
        TestSeekTo.assertEquals((int)1, (int)reader.blockIndex.blockContainingKey(TestSeekTo.toKV("j").getKey(), 0, klen));
        TestSeekTo.assertEquals((int)1, (int)reader.blockIndex.blockContainingKey(TestSeekTo.toKV("k").getKey(), 0, klen));
        TestSeekTo.assertEquals((int)1, (int)reader.blockIndex.blockContainingKey(TestSeekTo.toKV("l").getKey(), 0, klen));
    }
}

