/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import java.util.Arrays;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapred.TableRecordReader;
import org.apache.hadoop.hbase.mapreduce.TableRecordReaderImpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestTableInputFormat {
    private static final Log LOG = LogFactory.getLog(TestTableInputFormat.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    static final byte[] FAMILY = Bytes.toBytes((String)"family");
    private static final byte[][] columns = new byte[][]{FAMILY};

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void afterClass() throws IOException {
        UTIL.getMiniHBaseCluster().shutdown();
    }

    @Before
    public void before() throws IOException {
        LOG.info((Object)"before");
        UTIL.ensureSomeRegionServersAvailable(1);
        LOG.info((Object)"before done");
    }

    public static HTable createTable(byte[] tableName) throws IOException {
        HTable table = UTIL.createTable(tableName, FAMILY);
        Put p = new Put("aaa".getBytes());
        p.add(FAMILY, null, "value aaa".getBytes());
        table.put(p);
        p = new Put("bbb".getBytes());
        p.add(FAMILY, null, "value bbb".getBytes());
        table.put(p);
        return table;
    }

    static boolean checkResult(Result r, ImmutableBytesWritable key, byte[] expectedKey, byte[] expectedValue) {
        Assert.assertEquals((long)0L, (long)key.compareTo(expectedKey));
        NavigableMap vals = r.getFamilyMap(FAMILY);
        byte[] value = (byte[])vals.values().iterator().next();
        Assert.assertTrue((boolean)Arrays.equals(value, expectedValue));
        return true;
    }

    static void runTestMapred(HTable table) throws IOException {
        TableRecordReader trr = new TableRecordReader();
        trr.setStartRow("aaa".getBytes());
        trr.setEndRow("zzz".getBytes());
        trr.setHTable(table);
        trr.setInputColumns(columns);
        trr.init();
        Result r = new Result();
        ImmutableBytesWritable key = new ImmutableBytesWritable();
        boolean more = trr.next(key, r);
        Assert.assertTrue((boolean)more);
        TestTableInputFormat.checkResult(r, key, "aaa".getBytes(), "value aaa".getBytes());
        more = trr.next(key, r);
        Assert.assertTrue((boolean)more);
        TestTableInputFormat.checkResult(r, key, "bbb".getBytes(), "value bbb".getBytes());
        more = trr.next(key, r);
        Assert.assertFalse((boolean)more);
    }

    static void runTestMapreduce(HTable table) throws IOException, InterruptedException {
        TableRecordReaderImpl trr = new TableRecordReaderImpl();
        Scan s = new Scan();
        s.setStartRow("aaa".getBytes());
        s.setStopRow("zzz".getBytes());
        s.addFamily(FAMILY);
        trr.setScan(s);
        trr.setHTable(table);
        trr.init();
        Result r = new Result();
        ImmutableBytesWritable key = new ImmutableBytesWritable();
        boolean more = trr.nextKeyValue();
        Assert.assertTrue((boolean)more);
        key = trr.getCurrentKey();
        r = trr.getCurrentValue();
        TestTableInputFormat.checkResult(r, key, "aaa".getBytes(), "value aaa".getBytes());
        more = trr.nextKeyValue();
        Assert.assertTrue((boolean)more);
        key = trr.getCurrentKey();
        r = trr.getCurrentValue();
        TestTableInputFormat.checkResult(r, key, "bbb".getBytes(), "value bbb".getBytes());
        more = trr.nextKeyValue();
        Assert.assertFalse((boolean)more);
    }

    static HTable createIOEScannerTable(byte[] name) throws IOException {
        Answer<ResultScanner> a = new Answer<ResultScanner>(){
            boolean first = true;

            public ResultScanner answer(InvocationOnMock invocation) throws Throwable {
                if (this.first) {
                    this.first = false;
                    Scan scan = (Scan)Mockito.mock(Scan.class);
                    ((Scan)Mockito.doReturn((Object)"bogus".getBytes()).when((Object)scan)).getStartRow();
                    ResultScanner scanner = (ResultScanner)Mockito.mock(ResultScanner.class);
                    ((ResultScanner)Mockito.doThrow((Throwable)new IOException("Injected exception")).when((Object)scanner)).next();
                    return scanner;
                }
                return (ResultScanner)invocation.callRealMethod();
            }
        };
        HTable htable = (HTable)Mockito.spy((Object)TestTableInputFormat.createTable(name));
        ((HTable)Mockito.doAnswer((Answer)a).when((Object)htable)).getScanner((Scan)Matchers.anyObject());
        return htable;
    }

    static HTable createDNRIOEScannerTable(byte[] name) throws IOException {
        Answer<ResultScanner> a = new Answer<ResultScanner>(){
            boolean first = true;

            public ResultScanner answer(InvocationOnMock invocation) throws Throwable {
                if (this.first) {
                    this.first = false;
                    Scan scan = (Scan)Mockito.mock(Scan.class);
                    ((Scan)Mockito.doReturn((Object)"bogus".getBytes()).when((Object)scan)).getStartRow();
                    ResultScanner scanner = (ResultScanner)Mockito.mock(ResultScanner.class);
                    invocation.callRealMethod();
                    ((ResultScanner)Mockito.doThrow((Throwable)new UnknownScannerException("Injected simulated TimeoutException")).when((Object)scanner)).next();
                    return scanner;
                }
                return (ResultScanner)invocation.callRealMethod();
            }
        };
        HTable htable = (HTable)Mockito.spy((Object)TestTableInputFormat.createTable(name));
        ((HTable)Mockito.doAnswer((Answer)a).when((Object)htable)).getScanner((Scan)Matchers.anyObject());
        return htable;
    }

    @Test
    public void testTableRecordReader() throws IOException {
        HTable table = TestTableInputFormat.createTable("table1".getBytes());
        TestTableInputFormat.runTestMapred(table);
    }

    @Test
    public void testTableRecordReaderScannerFail() throws IOException {
        HTable htable = TestTableInputFormat.createIOEScannerTable("table2".getBytes());
        TestTableInputFormat.runTestMapred(htable);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testTableRecordReaderScannerTimeout() throws IOException {
        HTable htable = TestTableInputFormat.createDNRIOEScannerTable("table3".getBytes());
        TestTableInputFormat.runTestMapred(htable);
    }

    @Test
    public void testTableRecordReaderMapreduce() throws IOException, InterruptedException {
        HTable table = TestTableInputFormat.createTable("table1-mr".getBytes());
        TestTableInputFormat.runTestMapreduce(table);
    }

    @Test
    public void testTableRecordReaderScannerFailMapreduce() throws IOException, InterruptedException {
        HTable htable = TestTableInputFormat.createIOEScannerTable("table2-mr".getBytes());
        TestTableInputFormat.runTestMapreduce(htable);
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testTableRecordReaderScannerTimeoutMapreduce() throws IOException, InterruptedException {
        HTable htable = TestTableInputFormat.createDNRIOEScannerTable("table3-mr".getBytes());
        TestTableInputFormat.runTestMapreduce(htable);
    }
}

