/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PerformanceEvaluation;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.mapreduce.HFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.KeyValueSortReducer;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.mapreduce.NMapInputFormat;
import org.apache.hadoop.hbase.mapreduce.SimpleTotalOrderPartitioner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHFileOutputFormat {
    private static final int ROWSPERSPLIT = 1024;
    private static final byte[] FAMILY_NAME = PerformanceEvaluation.FAMILY_NAME;
    private static final byte[] TABLE_NAME = Bytes.toBytes((String)"TestTable");
    private HBaseTestingUtility util = new HBaseTestingUtility();
    private static Log LOG = LogFactory.getLog(TestHFileOutputFormat.class);

    @Before
    public void cleanupDir() throws IOException {
        this.util.cleanupTestDir();
    }

    private void setupRandomGeneratorMapper(Job job) {
        job.setInputFormatClass(NMapInputFormat.class);
        job.setMapperClass(RandomKVGeneratingMapper.class);
        job.setMapOutputKeyClass(ImmutableBytesWritable.class);
        job.setMapOutputValueClass(KeyValue.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void test_LATEST_TIMESTAMP_isReplaced() throws IOException, InterruptedException {
        Path dir;
        Configuration conf;
        block3: {
            conf = new Configuration(this.util.getConfiguration());
            RecordWriter writer = null;
            TaskAttemptContext context = null;
            dir = HBaseTestingUtility.getTestDir("test_LATEST_TIMESTAMP_isReplaced");
            try {
                Job job = new Job(conf);
                FileOutputFormat.setOutputPath((Job)job, (Path)dir);
                context = new TaskAttemptContext(job.getConfiguration(), new TaskAttemptID());
                HFileOutputFormat hof = new HFileOutputFormat();
                writer = hof.getRecordWriter(context);
                byte[] b = Bytes.toBytes((String)"b");
                KeyValue kv = new KeyValue(b, b, b);
                KeyValue original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertFalse((boolean)original.equals((Object)kv));
                Assert.assertTrue((boolean)Bytes.equals((byte[])original.getRow(), (byte[])kv.getRow()));
                Assert.assertTrue((boolean)original.matchingColumn(kv.getFamily(), kv.getQualifier()));
                Assert.assertNotSame((Object)original.getTimestamp(), (Object)kv.getTimestamp());
                Assert.assertNotSame((Object)Long.MAX_VALUE, (Object)kv.getTimestamp());
                kv = new KeyValue(b, b, b, kv.getTimestamp() - 1L, b);
                original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertTrue((boolean)original.equals((Object)kv));
                if (writer == null || context == null) break block3;
            }
            catch (Throwable throwable) {
                if (writer != null && context != null) {
                    writer.close(context);
                }
                dir.getFileSystem(conf).delete(dir, true);
                throw throwable;
            }
            writer.close(context);
        }
        dir.getFileSystem(conf).delete(dir, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void test_TIMERANGE() throws IOException, InterruptedException {
        Path dir;
        Configuration conf;
        block3: {
            conf = new Configuration(this.util.getConfiguration());
            RecordWriter writer = null;
            TaskAttemptContext context = null;
            dir = HBaseTestingUtility.getTestDir("test_TIMERANGE_present");
            LOG.info((Object)("Timerange dir writing to dir: " + dir));
            try {
                Job job = new Job(conf);
                FileOutputFormat.setOutputPath((Job)job, (Path)dir);
                context = new TaskAttemptContext(job.getConfiguration(), new TaskAttemptID());
                HFileOutputFormat hof = new HFileOutputFormat();
                writer = hof.getRecordWriter(context);
                byte[] b = Bytes.toBytes((String)"b");
                KeyValue kv = new KeyValue(b, b, b, 2000L, b);
                KeyValue original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertEquals((Object)original, (Object)kv);
                kv = new KeyValue(b, b, b, 1000L, b);
                original = kv.clone();
                writer.write((Object)new ImmutableBytesWritable(), (Object)kv);
                Assert.assertEquals((Object)original, (Object)kv);
                writer.close(context);
                FileSystem fs = FileSystem.get((Configuration)conf);
                Path path = HFileOutputFormat.getOutputPath((JobContext)job);
                FileStatus[] sub1 = fs.listStatus(path);
                FileStatus[] sub2 = fs.listStatus(sub1[0].getPath());
                FileStatus[] sub3 = fs.listStatus(sub2[0].getPath());
                FileStatus[] file = fs.listStatus(sub3[0].getPath());
                HFile.Reader rd = new HFile.Reader(fs, file[0].getPath(), null, true);
                Map finfo = rd.loadFileInfo();
                byte[] range = (byte[])finfo.get("TIMERANGE".getBytes());
                Assert.assertNotNull((Object)range);
                TimeRangeTracker timeRangeTracker = new TimeRangeTracker();
                Writables.copyWritable((byte[])range, (Writable)timeRangeTracker);
                LOG.info((Object)(timeRangeTracker.getMinimumTimestamp() + "...." + timeRangeTracker.getMaximumTimestamp()));
                Assert.assertEquals((long)1000L, (long)timeRangeTracker.getMinimumTimestamp());
                Assert.assertEquals((long)2000L, (long)timeRangeTracker.getMaximumTimestamp());
                if (writer == null || context == null) break block3;
            }
            catch (Throwable throwable) {
                if (writer != null && context != null) {
                    writer.close(context);
                }
                dir.getFileSystem(conf).delete(dir, true);
                throw throwable;
            }
            writer.close(context);
        }
        dir.getFileSystem(conf).delete(dir, true);
    }

    @Test
    public void testWritingPEData() throws Exception {
        Configuration conf = this.util.getConfiguration();
        Path testDir = HBaseTestingUtility.getTestDir("testWritingPEData");
        FileSystem fs = testDir.getFileSystem(conf);
        conf.setInt("io.sort.mb", 20);
        conf.setLong("hbase.hregion.max.filesize", 65536L);
        Job job = new Job(conf, "testWritingPEData");
        this.setupRandomGeneratorMapper(job);
        byte[] startKey = new byte[10];
        byte[] endKey = new byte[10];
        Arrays.fill(startKey, (byte)0);
        Arrays.fill(endKey, (byte)-1);
        job.setPartitionerClass(SimpleTotalOrderPartitioner.class);
        SimpleTotalOrderPartitioner.setStartKey((Configuration)job.getConfiguration(), (byte[])startKey);
        SimpleTotalOrderPartitioner.setEndKey((Configuration)job.getConfiguration(), (byte[])endKey);
        job.setReducerClass(KeyValueSortReducer.class);
        job.setOutputFormatClass(HFileOutputFormat.class);
        job.setNumReduceTasks(4);
        FileOutputFormat.setOutputPath((Job)job, (Path)testDir);
        Assert.assertTrue((boolean)job.waitForCompletion(false));
        FileStatus[] files = fs.listStatus(testDir);
        Assert.assertTrue((files.length > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testJobConfiguration() throws Exception {
        Job job = new Job();
        HTable table = (HTable)Mockito.mock(HTable.class);
        byte[][] mockKeys = new byte[][]{HConstants.EMPTY_BYTE_ARRAY, Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"zzz")};
        ((HTable)Mockito.doReturn((Object)mockKeys).when((Object)table)).getStartKeys();
        HFileOutputFormat.configureIncrementalLoad((Job)job, (HTable)table);
        Assert.assertEquals((long)job.getNumReduceTasks(), (long)4L);
    }

    private byte[][] generateRandomStartKeys(int numKeys) {
        Random random = new Random();
        byte[][] ret = new byte[numKeys][];
        ret[0] = HConstants.EMPTY_BYTE_ARRAY;
        for (int i = 1; i < numKeys; ++i) {
            ret[i] = PerformanceEvaluation.generateValue(random);
        }
        return ret;
    }

    @Test
    public void testMRIncrementalLoad() throws Exception {
        this.doIncrementalLoadTest(false);
    }

    @Test
    public void testMRIncrementalLoadWithSplit() throws Exception {
        this.doIncrementalLoadTest(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doIncrementalLoadTest(boolean shouldChangeRegions) throws Exception {
        Configuration conf = this.util.getConfiguration();
        Path testDir = HBaseTestingUtility.getTestDir("testLocalMRIncrementalLoad");
        byte[][] startKeys = this.generateRandomStartKeys(5);
        try {
            this.util.startMiniCluster();
            HBaseAdmin admin = new HBaseAdmin(conf);
            HTable table = this.util.createTable(TABLE_NAME, FAMILY_NAME);
            int numRegions = this.util.createMultiRegions(this.util.getConfiguration(), table, FAMILY_NAME, startKeys);
            Assert.assertEquals((String)"Should make 5 regions", (long)numRegions, (long)5L);
            Assert.assertEquals((String)"Should start with empty table", (long)0L, (long)this.util.countRows(table));
            this.util.startMiniMapReduceCluster();
            this.runIncrementalPELoad(conf, table, testDir);
            Assert.assertEquals((String)"HFOF should not touch actual table", (long)0L, (long)this.util.countRows(table));
            if (shouldChangeRegions) {
                LOG.info((Object)"Changing regions in table");
                admin.disableTable(table.getTableName());
                while (this.util.getMiniHBaseCluster().getMaster().getAssignmentManager().isRegionsInTransition()) {
                    Threads.sleep((int)1000);
                    LOG.info((Object)"Waiting on table to finish disabling");
                }
                byte[][] newStartKeys = this.generateRandomStartKeys(15);
                this.util.createMultiRegions(this.util.getConfiguration(), table, FAMILY_NAME, newStartKeys);
                admin.enableTable(table.getTableName());
                while (table.getRegionsInfo().size() != 15 || !admin.isTableAvailable(table.getTableName())) {
                    Thread.sleep(1000L);
                    LOG.info((Object)"Waiting for new region assignment to happen");
                }
            }
            new LoadIncrementalHFiles(conf).doBulkLoad(testDir, table);
            int expectedRows = NMapInputFormat.getNumMapTasks(conf) * 1024;
            Assert.assertEquals((String)"LoadIncrementalHFiles should put expected data in table", (long)expectedRows, (long)this.util.countRows(table));
            String tableDigestBefore = this.util.checksumRows(table);
            admin.disableTable(TABLE_NAME);
            while (!admin.isTableDisabled(TABLE_NAME)) {
                Thread.sleep(1000L);
                LOG.info((Object)"Waiting for table to disable");
            }
            admin.enableTable(TABLE_NAME);
            this.util.waitTableAvailable(TABLE_NAME, 30000L);
            Assert.assertEquals((String)"Data should remain after reopening of regions", (Object)tableDigestBefore, (Object)this.util.checksumRows(table));
        }
        finally {
            this.util.shutdownMiniMapReduceCluster();
            this.util.shutdownMiniCluster();
        }
    }

    private void runIncrementalPELoad(Configuration conf, HTable table, Path outDir) throws Exception {
        Job job = new Job(conf, "testLocalMRIncrementalLoad");
        this.setupRandomGeneratorMapper(job);
        HFileOutputFormat.configureIncrementalLoad((Job)job, (HTable)table);
        FileOutputFormat.setOutputPath((Job)job, (Path)outDir);
        Assert.assertEquals((long)table.getRegionsInfo().size(), (long)job.getNumReduceTasks());
        Assert.assertTrue((boolean)job.waitForCompletion(true));
    }

    public static void main(String[] args) throws Exception {
        new TestHFileOutputFormat().manualTest(args);
    }

    public void manualTest(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        this.util = new HBaseTestingUtility(conf);
        if ("newtable".equals(args[0])) {
            byte[] tname = args[1].getBytes();
            HTable table = this.util.createTable(tname, FAMILY_NAME);
            HBaseAdmin admin = new HBaseAdmin(conf);
            admin.disableTable(tname);
            this.util.createMultiRegions(conf, table, FAMILY_NAME, this.generateRandomStartKeys(5));
            admin.enableTable(tname);
        } else if ("incremental".equals(args[0])) {
            byte[] tname = args[1].getBytes();
            HTable table = new HTable(conf, tname);
            Path outDir = new Path("incremental-out");
            this.runIncrementalPELoad(conf, table, outDir);
        } else {
            throw new RuntimeException("usage: TestHFileOutputFormat newtable | incremental");
        }
    }

    static class RandomKVGeneratingMapper
    extends Mapper<NullWritable, NullWritable, ImmutableBytesWritable, KeyValue> {
        private int keyLength;
        private static final int KEYLEN_DEFAULT = 10;
        private static final String KEYLEN_CONF = "randomkv.key.length";
        private int valLength;
        private static final int VALLEN_DEFAULT = 10;
        private static final String VALLEN_CONF = "randomkv.val.length";

        RandomKVGeneratingMapper() {
        }

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            Configuration conf = context.getConfiguration();
            this.keyLength = conf.getInt(KEYLEN_CONF, 10);
            this.valLength = conf.getInt(VALLEN_CONF, 10);
        }

        protected void map(NullWritable n1, NullWritable n2, Mapper.Context context) throws IOException, InterruptedException {
            byte[] keyBytes = new byte[this.keyLength];
            byte[] valBytes = new byte[this.valLength];
            int taskId = context.getTaskAttemptID().getTaskID().getId();
            assert (taskId < 127) : "Unit tests dont support > 127 tasks!";
            Random random = new Random();
            for (int i = 0; i < 1024; ++i) {
                random.nextBytes(keyBytes);
                keyBytes[this.keyLength - 1] = (byte)(taskId & 0xFF);
                random.nextBytes(valBytes);
                ImmutableBytesWritable key = new ImmutableBytesWritable(keyBytes);
                KeyValue kv = new KeyValue(keyBytes, PerformanceEvaluation.FAMILY_NAME, PerformanceEvaluation.QUALIFIER_NAME, valBytes);
                context.write((Object)key, (Object)kv);
            }
        }
    }
}

