/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.ImportTsv;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.GenericOptionsParser;
import org.junit.Assert;
import org.junit.Test;

public class TestImportTsv {
    @Test
    public void testTsvParserSpecParsing() {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
        parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col1:scol1", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(1));
        this.assertBytesEquals(Bytes.toBytes((String)"scol1"), parser.getQualifier(1));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
        parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col1:scol1,col1:scol2", "\t");
        Assert.assertNull((Object)parser.getFamily(0));
        Assert.assertNull((Object)parser.getQualifier(0));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(1));
        this.assertBytesEquals(Bytes.toBytes((String)"scol1"), parser.getQualifier(1));
        this.assertBytesEquals(Bytes.toBytes((String)"col1"), parser.getFamily(2));
        this.assertBytesEquals(Bytes.toBytes((String)"scol2"), parser.getQualifier(2));
        Assert.assertEquals((long)0L, (long)parser.getRowKeyColumnIndex());
    }

    @Test
    public void testTsvParser() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("col_a,col_b:qual,HBASE_ROW_KEY,col_d", "\t");
        this.assertBytesEquals(Bytes.toBytes((String)"col_a"), parser.getFamily(0));
        this.assertBytesEquals(HConstants.EMPTY_BYTE_ARRAY, parser.getQualifier(0));
        this.assertBytesEquals(Bytes.toBytes((String)"col_b"), parser.getFamily(1));
        this.assertBytesEquals(Bytes.toBytes((String)"qual"), parser.getQualifier(1));
        Assert.assertNull((Object)parser.getFamily(2));
        Assert.assertNull((Object)parser.getQualifier(2));
        Assert.assertEquals((long)2L, (long)parser.getRowKeyColumnIndex());
        byte[] line = Bytes.toBytes((String)"val_a\tval_b\tval_c\tval_d");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
        this.checkParsing(parsed, Splitter.on((String)"\t").split((CharSequence)Bytes.toString((byte[])line)));
    }

    private void checkParsing(ImportTsv.TsvParser.ParsedLine parsed, Iterable<String> expected) {
        ArrayList<String> parsedCols = new ArrayList<String>();
        for (int i = 0; i < parsed.getColumnCount(); ++i) {
            parsedCols.add(Bytes.toString((byte[])parsed.getLineBytes(), (int)parsed.getColumnOffset(i), (int)parsed.getColumnLength(i)));
        }
        if (!Iterables.elementsEqual(parsedCols, expected)) {
            Assert.fail((String)("Expected: " + Joiner.on((String)",").join(expected) + "\n" + "Got:" + Joiner.on((String)",").join(parsedCols)));
        }
    }

    private void assertBytesEquals(byte[] a, byte[] b) {
        Assert.assertEquals((Object)Bytes.toStringBinary((byte[])a), (Object)Bytes.toStringBinary((byte[])b));
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineExcessiveColumns() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col_a", "\t");
        byte[] line = Bytes.toBytes((String)"val_a\tval_b\tval_c");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineZeroColumn() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col_a", "\t");
        byte[] line = Bytes.toBytes((String)"");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineOnlyKey() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("HBASE_ROW_KEY,col_a", "\t");
        byte[] line = Bytes.toBytes((String)"key_only");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
    }

    @Test(expected=ImportTsv.TsvParser.BadTsvLineException.class)
    public void testTsvParserBadTsvLineNoRowKey() throws ImportTsv.TsvParser.BadTsvLineException {
        ImportTsv.TsvParser parser = new ImportTsv.TsvParser("col_a,HBASE_ROW_KEY", "\t");
        byte[] line = Bytes.toBytes((String)"only_cola_data_and_no_row_key");
        ImportTsv.TsvParser.ParsedLine parsed = parser.parse(line, line.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMROnTable() throws Exception {
        String TABLE_NAME = "TestTable";
        String FAMILY = "FAM";
        String INPUT_FILE = "InputFile.esv";
        String[] args = new String[]{"-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B", "-Dimporttsv.separator=\u001b", TABLE_NAME, INPUT_FILE};
        HBaseTestingUtility htu1 = new HBaseTestingUtility();
        MiniHBaseCluster cluster = htu1.startMiniCluster();
        GenericOptionsParser opts = new GenericOptionsParser(cluster.getConfiguration(), args);
        Configuration conf = opts.getConfiguration();
        args = opts.getRemainingArgs();
        try {
            FileSystem fs = FileSystem.get((Configuration)conf);
            FSDataOutputStream op = fs.create(new Path(INPUT_FILE), true);
            String line = "KEY\u001bVALUE1\u001bVALUE2\n";
            op.write(line.getBytes("UTF-8"));
            op.close();
            byte[] FAM = Bytes.toBytes((String)FAMILY);
            byte[] TAB = Bytes.toBytes((String)TABLE_NAME);
            byte[] QA = Bytes.toBytes((String)"A");
            byte[] QB = Bytes.toBytes((String)"B");
            HTableDescriptor desc = new HTableDescriptor(TAB);
            desc.addFamily(new HColumnDescriptor(FAM));
            new HBaseAdmin(conf).createTable(desc);
            Job job = ImportTsv.createSubmittableJob((Configuration)conf, (String[])args);
            job.waitForCompletion(false);
            Assert.assertTrue((boolean)job.isSuccessful());
            HTable table = new HTable(new Configuration(conf), TAB);
            boolean verified = false;
            long pause = conf.getLong("hbase.client.pause", 5000L);
            int numRetries = conf.getInt("hbase.client.retries.number", 5);
            for (int i = 0; i < numRetries; ++i) {
                try {
                    Scan scan = new Scan();
                    scan.addFamily(FAM);
                    ResultScanner resScanner = table.getScanner(scan);
                    for (Result res : resScanner) {
                        Assert.assertTrue((res.size() == 2 ? 1 : 0) != 0);
                        List kvs = res.list();
                        Assert.assertEquals((Object)TestImportTsv.toU8Str(((KeyValue)kvs.get(0)).getRow()), (Object)TestImportTsv.toU8Str(Bytes.toBytes((String)"KEY")));
                        Assert.assertEquals((Object)TestImportTsv.toU8Str(((KeyValue)kvs.get(1)).getRow()), (Object)TestImportTsv.toU8Str(Bytes.toBytes((String)"KEY")));
                        Assert.assertEquals((Object)TestImportTsv.toU8Str(((KeyValue)kvs.get(0)).getValue()), (Object)TestImportTsv.toU8Str(Bytes.toBytes((String)"VALUE1")));
                        Assert.assertEquals((Object)TestImportTsv.toU8Str(((KeyValue)kvs.get(1)).getValue()), (Object)TestImportTsv.toU8Str(Bytes.toBytes((String)"VALUE2")));
                    }
                    verified = true;
                    break;
                }
                catch (NullPointerException e) {
                    try {
                        Thread.sleep(pause);
                    }
                    catch (InterruptedException e2) {
                        // empty catch block
                    }
                    continue;
                }
            }
            Assert.assertTrue((boolean)verified);
        }
        finally {
            cluster.shutdown();
        }
    }

    public static String toU8Str(byte[] bytes) throws UnsupportedEncodingException {
        return new String(bytes, "UTF-8");
    }
}

