/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.File;
import java.io.IOException;
import java.util.NavigableMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestTableInputFormatScan {
    static final Log LOG = LogFactory.getLog(TestTableInputFormatScan.class);
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    static final byte[] TABLE_NAME = Bytes.toBytes((String)"scantest");
    static final byte[] INPUT_FAMILY = Bytes.toBytes((String)"contents");
    static final String KEY_STARTROW = "startRow";
    static final String KEY_LASTROW = "stpRow";
    private static HTable table = null;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.enableDebug(TableInputFormat.class);
        TEST_UTIL.enableDebug(TableInputFormatBase.class);
        TEST_UTIL.startMiniCluster(3);
        table = TEST_UTIL.createTable(TABLE_NAME, INPUT_FAMILY);
        TEST_UTIL.createMultiRegions(table, INPUT_FAMILY);
        TEST_UTIL.loadTable(table, INPUT_FAMILY);
        TEST_UTIL.startMiniMapReduceCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniMapReduceCluster();
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
        Configuration c = TEST_UTIL.getConfiguration();
        FileUtil.fullyDelete((File)new File(c.get("hadoop.tmp.dir")));
    }

    @Test
    public void testScanEmptyToEmpty() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan(null, null, null);
    }

    @Test
    public void testScanEmptyToAPP() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan(null, "app", "apo");
    }

    @Test
    public void testScanEmptyToBBA() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan(null, "bba", "baz");
    }

    @Test
    public void testScanEmptyToBBB() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan(null, "bbb", "bba");
    }

    @Test
    public void testScanEmptyToOPP() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan(null, "opp", "opo");
    }

    @Test
    public void testScanOBBToOPP() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan("obb", "opp", "opo");
    }

    @Test
    public void testScanOBBToQPP() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan("obb", "qpp", "qpo");
    }

    @Test
    public void testScanOPPToEmpty() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan("opp", null, "zzz");
    }

    @Test
    public void testScanYYXToEmpty() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan("yyx", null, "zzz");
    }

    @Test
    public void testScanYYYToEmpty() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan("yyy", null, "zzz");
    }

    @Test
    public void testScanYZYToEmpty() throws IOException, InterruptedException, ClassNotFoundException {
        this.testScan("yzy", null, "zzz");
    }

    private void testScan(String start, String stop, String last) throws IOException, InterruptedException, ClassNotFoundException {
        String jobName = "Scan" + (start != null ? start.toUpperCase() : "Empty") + "To" + (stop != null ? stop.toUpperCase() : "Empty");
        LOG.info((Object)("Before map/reduce startup - job " + jobName));
        Configuration c = new Configuration(TEST_UTIL.getConfiguration());
        Scan scan = new Scan();
        scan.addFamily(INPUT_FAMILY);
        if (start != null) {
            scan.setStartRow(Bytes.toBytes((String)start));
        }
        c.set(KEY_STARTROW, start != null ? start : "");
        if (stop != null) {
            scan.setStopRow(Bytes.toBytes((String)stop));
        }
        c.set(KEY_LASTROW, last != null ? last : "");
        LOG.info((Object)("scan before: " + scan));
        Job job = new Job(c, jobName);
        TableMapReduceUtil.initTableMapperJob((String)Bytes.toString((byte[])TABLE_NAME), (Scan)scan, ScanMapper.class, ImmutableBytesWritable.class, ImmutableBytesWritable.class, (Job)job);
        job.setReducerClass(ScanReducer.class);
        job.setNumReduceTasks(1);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(job.getJobName()));
        LOG.info((Object)("Started " + job.getJobName()));
        job.waitForCompletion(true);
        Assert.assertTrue((boolean)job.isComplete());
        LOG.info((Object)("After map/reduce completion - job " + jobName));
    }

    public static class ScanReducer
    extends Reducer<ImmutableBytesWritable, ImmutableBytesWritable, NullWritable, NullWritable> {
        private String first = null;
        private String last = null;

        protected void reduce(ImmutableBytesWritable key, Iterable<ImmutableBytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            int count = 0;
            for (ImmutableBytesWritable value : values) {
                String val = Bytes.toStringBinary((byte[])value.get());
                LOG.info((Object)("reduce: key[" + count + "] -> " + Bytes.toStringBinary((byte[])key.get()) + ", value -> " + val));
                if (this.first == null) {
                    this.first = val;
                }
                this.last = val;
                ++count;
            }
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            Configuration c = context.getConfiguration();
            String startRow = c.get(TestTableInputFormatScan.KEY_STARTROW);
            String lastRow = c.get(TestTableInputFormatScan.KEY_LASTROW);
            LOG.info((Object)("cleanup: first -> \"" + this.first + "\", start row -> \"" + startRow + "\""));
            LOG.info((Object)("cleanup: last -> \"" + this.last + "\", last row -> \"" + lastRow + "\""));
            if (startRow != null && startRow.length() > 0) {
                Assert.assertEquals((Object)startRow, (Object)this.first);
            }
            if (lastRow != null && lastRow.length() > 0) {
                Assert.assertEquals((Object)lastRow, (Object)this.last);
            }
        }
    }

    public static class ScanMapper
    extends TableMapper<ImmutableBytesWritable, ImmutableBytesWritable> {
        public void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            if (value.size() != 1) {
                throw new IOException("There should only be one input column");
            }
            NavigableMap cf = value.getMap();
            if (!cf.containsKey(INPUT_FAMILY)) {
                throw new IOException("Wrong input columns. Missing: '" + Bytes.toString((byte[])INPUT_FAMILY) + "'.");
            }
            String val = Bytes.toStringBinary((byte[])value.getValue(INPUT_FAMILY, null));
            LOG.info((Object)("map: key -> " + Bytes.toStringBinary((byte[])key.get()) + ", value -> " + val));
            context.write((Object)key, (Object)key);
        }
    }
}

