/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClockOutOfSyncException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Test;

public class TestClockSkewDetection {
    private static final Log LOG = LogFactory.getLog(TestClockSkewDetection.class);

    @Test
    public void testClockSkewDetection() throws Exception {
        final Configuration conf = HBaseConfiguration.create();
        ServerManager sm = new ServerManager(new Server(){

            public CatalogTracker getCatalogTracker() {
                return null;
            }

            public Configuration getConfiguration() {
                return conf;
            }

            public String getServerName() {
                return null;
            }

            public ZooKeeperWatcher getZooKeeper() {
                return null;
            }

            public void abort(String why, Throwable e) {
            }

            public boolean isStopped() {
                return false;
            }

            public void stop(String why) {
            }
        }, null, null, false);
        LOG.debug((Object)"regionServerStartup 1");
        HServerInfo hsi1 = new HServerInfo(new HServerAddress("example.org:1234"), System.currentTimeMillis(), -1, "example.com");
        sm.regionServerStartup(hsi1, System.currentTimeMillis());
        long maxSkew = 30000L;
        try {
            LOG.debug((Object)"regionServerStartup 2");
            HServerInfo hsi2 = new HServerInfo(new HServerAddress("example.org:1235"), System.currentTimeMillis(), -1, "example.com");
            sm.regionServerStartup(hsi2, System.currentTimeMillis() - maxSkew * 2L);
            Assert.assertTrue((String)"HMaster should have thrown an ClockOutOfSyncException but didn't.", (boolean)false);
        }
        catch (ClockOutOfSyncException e) {
            LOG.info((Object)("Recieved expected exception: " + (Object)((Object)e)));
        }
    }
}

