/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import org.apache.hadoop.hbase.master.DeadServer;
import org.junit.Assert;
import org.junit.Test;

public class TestDeadServer {
    @Test
    public void testIsDead() {
        DeadServer ds = new DeadServer(2);
        String hostname123 = "127.0.0.1,123,3";
        Assert.assertFalse((boolean)ds.isDeadServer("127.0.0.1,123,3", false));
        Assert.assertFalse((boolean)ds.isDeadServer("127.0.0.1,123,3", true));
        ds.add("127.0.0.1,123,3");
        Assert.assertTrue((boolean)ds.isDeadServer("127.0.0.1,123,3", false));
        Assert.assertFalse((boolean)ds.isDeadServer("127.0.0.1:1", true));
        Assert.assertFalse((boolean)ds.isDeadServer("127.0.0.1:1234", true));
        Assert.assertTrue((boolean)ds.isDeadServer("127.0.0.1:123", true));
        Assert.assertTrue((boolean)ds.areDeadServersInProgress());
        ds.finish("127.0.0.1,123,3");
        Assert.assertFalse((boolean)ds.areDeadServersInProgress());
        String hostname1234 = "127.0.0.2,1234,4";
        ds.add("127.0.0.2,1234,4");
        Assert.assertTrue((boolean)ds.isDeadServer("127.0.0.1,123,3", false));
        Assert.assertTrue((boolean)ds.isDeadServer("127.0.0.2,1234,4", false));
        Assert.assertTrue((boolean)ds.areDeadServersInProgress());
        ds.finish("127.0.0.2,1234,4");
        Assert.assertFalse((boolean)ds.areDeadServersInProgress());
        String hostname12345 = "127.0.0.2,12345,4";
        ds.add("127.0.0.2,12345,4");
        Assert.assertTrue((boolean)ds.isDeadServer("127.0.0.2,1234,4", false));
        Assert.assertTrue((boolean)ds.isDeadServer("127.0.0.2,12345,4", false));
        Assert.assertTrue((boolean)ds.areDeadServersInProgress());
        ds.finish("127.0.0.2,12345,4");
        Assert.assertFalse((boolean)ds.areDeadServersInProgress());
        String deadServer = "127.0.0.1,9090,112321";
        Assert.assertFalse((boolean)ds.cleanPreviousInstance("127.0.0.1,9090,112321"));
        ds.add("127.0.0.1,9090,112321");
        Assert.assertTrue((boolean)ds.isDeadServer("127.0.0.1,9090,112321"));
        String deadServerHostComingAlive = "127.0.0.1,9090,112321";
        Assert.assertTrue((boolean)ds.cleanPreviousInstance("127.0.0.1,9090,112321"));
        Assert.assertFalse((boolean)ds.isDeadServer("127.0.0.1,9090,112321"));
        Assert.assertFalse((boolean)ds.cleanPreviousInstance("127.0.0.1,9090,112321"));
    }
}

