/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLoadBalancer {
    private static final Log LOG = LogFactory.getLog(TestLoadBalancer.class);
    private static LoadBalancer loadBalancer;
    private static Random rand;
    int[][] clusterStateMocks = new int[][]{{0}, {1}, {10}, {0, 0}, {2, 0}, {2, 1}, {2, 2}, {2, 3}, {2, 4}, {1, 1}, {0, 1}, {10, 1}, {14, 1432}, {47, 53}, {0, 1, 2}, {1, 2, 3}, {0, 2, 2}, {0, 3, 0}, {0, 4, 0}, {20, 20, 0}, {0, 1, 2, 3}, {4, 0, 0, 0}, {5, 0, 0, 0}, {6, 6, 0, 0}, {6, 2, 0, 0}, {6, 1, 0, 0}, {6, 0, 0, 0}, {4, 4, 4, 7}, {4, 4, 4, 8}, {0, 0, 0, 7}, {1, 1, 1, 1, 4}, {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 10}, {6, 6, 5, 6, 6, 6, 6, 6, 6, 1}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 54}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 55}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 56}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 16}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 8}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 9}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 10}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 123}, {1, 1, 1, 1, 1, 1, 1, 1, 1, 155}, {0, 0, 144, 1, 1, 1, 1, 1123, 133, 138, 12, 1444}, {0, 0, 144, 1, 0, 4, 1, 1123, 133, 138, 12, 1444}, {1538, 1392, 1561, 1557, 1535, 1553, 1385, 1542, 1619}};
    int[][] regionsAndServersMocks = new int[][]{{0, 0}, {0, 1}, {1, 1}, {2, 1}, {10, 1}, {1, 2}, {2, 2}, {3, 2}, {1, 3}, {2, 3}, {3, 3}, {25, 3}, {2, 10}, {2, 100}, {12, 10}, {12, 100}};
    private Queue<HRegionInfo> regionQueue = new LinkedList<HRegionInfo>();
    private Queue<HServerInfo> serverQueue = new LinkedList<HServerInfo>();

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.regions.slop", "0");
        loadBalancer = new LoadBalancer(conf);
        rand = new Random();
    }

    @Test
    public void testRandomizer() {
        for (int[] mockCluster : this.clusterStateMocks) {
            if (mockCluster.length < 5) continue;
            Map<HServerInfo, List<HRegionInfo>> servers = this.mockClusterServers(mockCluster);
            for (Map.Entry<HServerInfo, List<HRegionInfo>> e : servers.entrySet()) {
                List<HRegionInfo> original = e.getValue();
                if (original.size() < 5) continue;
                boolean same = true;
                for (int i = 0; i < 10 && same; ++i) {
                    ArrayList<HRegionInfo> copy = new ArrayList<HRegionInfo>(original);
                    System.out.println("Randomizing before " + copy.size());
                    for (HRegionInfo hri : copy) {
                        System.out.println(hri.getEncodedName());
                    }
                    List randomized = LoadBalancer.randomize(copy);
                    System.out.println("Randomizing after " + randomized.size());
                    for (HRegionInfo hri : randomized) {
                        System.out.println(hri.getEncodedName());
                    }
                    if (((Object)original).equals(randomized)) continue;
                    same = false;
                    break;
                }
                Assert.assertFalse((boolean)same);
            }
        }
    }

    @Test
    public void testBalanceCluster() throws Exception {
        for (int[] mockCluster : this.clusterStateMocks) {
            Map<HServerInfo, List<HRegionInfo>> servers = this.mockClusterServers(mockCluster);
            LOG.info((Object)("Mock Cluster : " + this.printMock(servers) + " " + this.printStats(servers)));
            List plans = loadBalancer.balanceCluster(servers);
            List<HServerInfo> balancedCluster = this.reconcile(servers, plans);
            LOG.info((Object)("Mock Balance : " + this.printMock(balancedCluster)));
            this.assertClusterAsBalanced(balancedCluster);
            for (Map.Entry<HServerInfo, List<HRegionInfo>> entry : servers.entrySet()) {
                this.returnRegions(entry.getValue());
                this.returnServer(entry.getKey());
            }
        }
    }

    public void assertClusterAsBalanced(List<HServerInfo> servers) {
        int numServers = servers.size();
        int numRegions = 0;
        int maxRegions = 0;
        int minRegions = Integer.MAX_VALUE;
        for (HServerInfo server : servers) {
            int nr = server.getLoad().getNumberOfRegions();
            if (nr > maxRegions) {
                maxRegions = nr;
            }
            if (nr < minRegions) {
                minRegions = nr;
            }
            numRegions += nr;
        }
        if (maxRegions - minRegions < 2) {
            return;
        }
        int min = numRegions / numServers;
        int max = numRegions % numServers == 0 ? min : min + 1;
        for (HServerInfo server : servers) {
            Assert.assertTrue((server.getLoad().getNumberOfRegions() <= max ? 1 : 0) != 0);
            Assert.assertTrue((server.getLoad().getNumberOfRegions() >= min ? 1 : 0) != 0);
        }
    }

    @Test
    public void testImmediateAssignment() throws Exception {
        for (int[] mock : this.regionsAndServersMocks) {
            LOG.debug((Object)("testImmediateAssignment with " + mock[0] + " regions and " + mock[1] + " servers"));
            List<HRegionInfo> regions = this.randomRegions(mock[0]);
            List<HServerInfo> servers = this.randomServers(mock[1], 0);
            Map assignments = LoadBalancer.immediateAssignment(regions, servers);
            this.assertImmediateAssignment(regions, servers, assignments);
            this.returnRegions(regions);
            this.returnServers(servers);
        }
    }

    private void assertImmediateAssignment(List<HRegionInfo> regions, List<HServerInfo> servers, Map<HRegionInfo, HServerInfo> assignments) {
        for (HRegionInfo region : regions) {
            Assert.assertTrue((boolean)assignments.containsKey(region));
        }
    }

    @Test
    public void testBulkAssignment() throws Exception {
        for (int[] mock : this.regionsAndServersMocks) {
            LOG.debug((Object)("testBulkAssignment with " + mock[0] + " regions and " + mock[1] + " servers"));
            List<HRegionInfo> regions = this.randomRegions(mock[0]);
            List<HServerInfo> servers = this.randomServers(mock[1], 0);
            Map assignments = LoadBalancer.roundRobinAssignment(regions, servers);
            float average = (float)regions.size() / (float)servers.size();
            int min = (int)Math.floor(average);
            int max = (int)Math.ceil(average);
            if (assignments != null && !assignments.isEmpty()) {
                for (List regionList : assignments.values()) {
                    Assert.assertTrue((regionList.size() == min || regionList.size() == max ? 1 : 0) != 0);
                }
            }
            this.returnRegions(regions);
            this.returnServers(servers);
        }
    }

    @Test
    public void testRetainAssignment() throws Exception {
        List<HServerInfo> servers = this.randomServers(10, 10);
        List<HRegionInfo> regions = this.randomRegions(100);
        TreeMap<HRegionInfo, HServerAddress> existing = new TreeMap<HRegionInfo, HServerAddress>();
        for (int i = 0; i < regions.size(); ++i) {
            existing.put(regions.get(i), servers.get(i % servers.size()).getServerAddress());
        }
        Map assignment = LoadBalancer.retainAssignment(existing, servers);
        this.assertRetainedAssignment(existing, servers, assignment);
        ArrayList<HServerInfo> servers2 = new ArrayList<HServerInfo>(servers);
        servers2.add(this.randomServer(10));
        servers2.add(this.randomServer(10));
        assignment = LoadBalancer.retainAssignment(existing, servers2);
        this.assertRetainedAssignment(existing, servers2, assignment);
        ArrayList<HServerInfo> servers3 = new ArrayList<HServerInfo>(servers);
        servers3.remove(servers3.size() - 1);
        servers3.remove(servers3.size() - 2);
        assignment = LoadBalancer.retainAssignment(existing, servers3);
        this.assertRetainedAssignment(existing, servers3, assignment);
    }

    private void assertRetainedAssignment(Map<HRegionInfo, HServerAddress> existing, List<HServerInfo> servers, Map<HServerInfo, List<HRegionInfo>> assignment) {
        TreeSet<HServerInfo> onlineServerSet = new TreeSet<HServerInfo>(servers);
        TreeSet<HRegionInfo> assignedRegions = new TreeSet<HRegionInfo>();
        for (Map.Entry<HServerInfo, List<HRegionInfo>> a : assignment.entrySet()) {
            Assert.assertTrue((String)"Region assigned to server that was not listed as online", (boolean)onlineServerSet.contains(a.getKey()));
            for (HRegionInfo r : a.getValue()) {
                assignedRegions.add(r);
            }
        }
        Assert.assertEquals((long)existing.size(), (long)assignedRegions.size());
        TreeSet<HServerAddress> onlineAddresses = new TreeSet<HServerAddress>();
        for (HServerInfo hServerInfo : servers) {
            onlineAddresses.add(hServerInfo.getServerAddress());
        }
        for (Map.Entry entry : assignment.entrySet()) {
            for (HRegionInfo r : (List)entry.getValue()) {
                HServerAddress address = existing.get(r);
                if (address == null || !onlineAddresses.contains(address)) continue;
                Assert.assertTrue((boolean)((HServerInfo)entry.getKey()).getServerAddress().equals((Object)address));
            }
        }
    }

    private String printStats(Map<HServerInfo, List<HRegionInfo>> servers) {
        int numServers = servers.size();
        int totalRegions = 0;
        for (HServerInfo server : servers.keySet()) {
            totalRegions += server.getLoad().getNumberOfRegions();
        }
        float average = (float)totalRegions / (float)numServers;
        int max = (int)Math.ceil(average);
        int min = (int)Math.floor(average);
        return "[srvr=" + numServers + " rgns=" + totalRegions + " avg=" + average + " max=" + max + " min=" + min + "]";
    }

    private String printMock(Map<HServerInfo, List<HRegionInfo>> servers) {
        return this.printMock(Arrays.asList(servers.keySet().toArray(new HServerInfo[servers.size()])));
    }

    private String printMock(List<HServerInfo> balancedCluster) {
        TreeSet<HServerInfo> sorted = new TreeSet<HServerInfo>(balancedCluster);
        HServerInfo[] arr = sorted.toArray(new HServerInfo[sorted.size()]);
        StringBuilder sb = new StringBuilder(sorted.size() * 4 + 4);
        sb.append("{ ");
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                sb.append(" , ");
            }
            sb.append(arr[i].getLoad().getNumberOfRegions());
        }
        sb.append(" }");
        return sb.toString();
    }

    private List<HServerInfo> reconcile(Map<HServerInfo, List<HRegionInfo>> servers, List<LoadBalancer.RegionPlan> plans) {
        if (plans != null) {
            for (LoadBalancer.RegionPlan plan : plans) {
                plan.getSource().getLoad().setNumberOfRegions(plan.getSource().getLoad().getNumberOfRegions() - 1);
                plan.getDestination().getLoad().setNumberOfRegions(plan.getDestination().getLoad().getNumberOfRegions() + 1);
            }
        }
        return Arrays.asList(servers.keySet().toArray(new HServerInfo[servers.size()]));
    }

    private Map<HServerInfo, List<HRegionInfo>> mockClusterServers(int[] mockCluster) {
        int numServers = mockCluster.length;
        TreeMap<HServerInfo, List<HRegionInfo>> servers = new TreeMap<HServerInfo, List<HRegionInfo>>();
        for (int i = 0; i < numServers; ++i) {
            int numRegions = mockCluster[i];
            HServerInfo server = this.randomServer(numRegions);
            List<HRegionInfo> regions = this.randomRegions(numRegions);
            servers.put(server, regions);
        }
        return servers;
    }

    private List<HRegionInfo> randomRegions(int numRegions) {
        ArrayList<HRegionInfo> regions = new ArrayList<HRegionInfo>(numRegions);
        byte[] start = new byte[16];
        byte[] end = new byte[16];
        rand.nextBytes(start);
        rand.nextBytes(end);
        for (int i = 0; i < numRegions; ++i) {
            if (!this.regionQueue.isEmpty()) {
                regions.add(this.regionQueue.poll());
                continue;
            }
            Bytes.putInt((byte[])start, (int)0, (int)(numRegions << 1));
            Bytes.putInt((byte[])end, (int)0, (int)((numRegions << 1) + 1));
            HRegionInfo hri = new HRegionInfo(new HTableDescriptor(Bytes.toBytes((String)("table" + i))), start, end);
            regions.add(hri);
        }
        return regions;
    }

    private void returnRegions(List<HRegionInfo> regions) {
        this.regionQueue.addAll(regions);
    }

    private HServerInfo randomServer(int numRegions) {
        if (!this.serverQueue.isEmpty()) {
            HServerInfo server = this.serverQueue.poll();
            server.getLoad().setNumberOfRegions(numRegions);
            return server;
        }
        String host = "127.0.0.1";
        int port = rand.nextInt(60000);
        long startCode = rand.nextLong();
        HServerInfo hsi = new HServerInfo(new HServerAddress(host, port), startCode, port, host);
        hsi.getLoad().setNumberOfRegions(numRegions);
        return hsi;
    }

    private List<HServerInfo> randomServers(int numServers, int numRegionsPerServer) {
        ArrayList<HServerInfo> servers = new ArrayList<HServerInfo>(numServers);
        for (int i = 0; i < numServers; ++i) {
            servers.add(this.randomServer(numRegionsPerServer));
        }
        return servers;
    }

    private void returnServer(HServerInfo server) {
        this.serverQueue.add(server);
    }

    private void returnServers(List<HServerInfo> servers) {
        this.serverQueue.addAll(servers);
    }
}

