/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.master.LogCleaner;
import org.apache.hadoop.hbase.replication.ReplicationZookeeper;
import org.apache.hadoop.hbase.replication.regionserver.Replication;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestLogsCleaner {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testLogCleaning() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.replication", true);
        Replication.decorateMasterConfiguration((Configuration)conf);
        DummyServer server = new DummyServer();
        ReplicationZookeeper zkHelper = new ReplicationZookeeper((Server)server, new AtomicBoolean(true));
        Path oldLogDir = new Path(HBaseTestingUtility.getTestDir(), ".oldlogs");
        String fakeMachineName = URLEncoder.encode(server.getServerName(), "UTF8");
        FileSystem fs = FileSystem.get((Configuration)conf);
        LogCleaner cleaner = new LogCleaner(1000, (Stoppable)server, conf, fs, oldLogDir);
        long now = System.currentTimeMillis();
        fs.delete(oldLogDir, true);
        fs.mkdirs(oldLogDir);
        fs.createNewFile(new Path(oldLogDir, "a"));
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + "a"));
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + now));
        System.out.println("Now is: " + now);
        for (int i = 0; i < 30; ++i) {
            Path fileName = new Path(oldLogDir, fakeMachineName + "." + (now - 6000000L - (long)i));
            fs.createNewFile(fileName);
            if (i % 10 != 0) continue;
            zkHelper.addLogToList(fileName.getName(), fakeMachineName);
            System.out.println("Replication log file: " + fileName);
        }
        for (FileStatus stat : fs.listStatus(oldLogDir)) {
            System.out.println(stat.getPath().toString());
        }
        fs.createNewFile(new Path(oldLogDir, fakeMachineName + "." + (now + 10000L)));
        Assert.assertEquals((long)34L, (long)fs.listStatus(oldLogDir).length);
        cleaner.chore();
        Assert.assertEquals((long)5L, (long)fs.listStatus(oldLogDir).length);
        for (FileStatus file : fs.listStatus(oldLogDir)) {
            System.out.println("Kept log files: " + file.getPath().getName());
        }
    }

    static class DummyServer
    implements Server {
        DummyServer() {
        }

        public Configuration getConfiguration() {
            return TEST_UTIL.getConfiguration();
        }

        public ZooKeeperWatcher getZooKeeper() {
            try {
                return new ZooKeeperWatcher(this.getConfiguration(), "dummy server", (Abortable)this);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }

        public CatalogTracker getCatalogTracker() {
            return null;
        }

        public String getServerName() {
            return "regionserver,60020,000000";
        }

        public void abort(String why, Throwable e) {
        }

        public void stop(String why) {
        }

        public boolean isStopped() {
            return false;
        }
    }
}

