/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.executor.RegionTransitionData;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKTable;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.junit.Assert;
import org.junit.Test;

public class TestMasterFailover {
    private static final Log LOG = LogFactory.getLog(TestMasterFailover.class);

    @Test(timeout=180000L)
    public void testSimpleMasterFailover() throws Exception {
        int NUM_MASTERS = 3;
        int NUM_RS = 3;
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 3);
        conf.setInt("hbase.master.wait.on.regionservers.maxtostart", 3);
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniCluster(3, 3);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        for (JVMClusterUtil.MasterThread mt : masterThreads) {
            Assert.assertTrue((boolean)mt.isAlive());
        }
        int numActive = 0;
        int activeIndex = -1;
        String activeName = null;
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            ++numActive;
            activeIndex = i;
            activeName = masterThreads.get(i).getMaster().getServerName();
        }
        Assert.assertEquals((long)1L, (long)numActive);
        Assert.assertEquals((long)3L, (long)masterThreads.size());
        LOG.debug((Object)"\n\nStopping a backup master\n");
        int backupIndex = activeIndex == 0 ? 1 : activeIndex - 1;
        cluster.stopMaster(backupIndex, false);
        cluster.waitOnMaster(backupIndex);
        for (int i = 0; i < masterThreads.size(); ++i) {
            if (!masterThreads.get(i).getMaster().isActiveMaster()) continue;
            Assert.assertTrue((boolean)activeName.equals(masterThreads.get(i).getMaster().getServerName()));
            activeIndex = i;
        }
        Assert.assertEquals((long)1L, (long)numActive);
        Assert.assertEquals((long)2L, (long)masterThreads.size());
        LOG.debug((Object)"\n\nStopping the active master\n");
        cluster.stopMaster(activeIndex, false);
        cluster.waitOnMaster(activeIndex);
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        LOG.debug((Object)"\n\nVerifying backup master is now active\n");
        Assert.assertEquals((long)1L, (long)masterThreads.size());
        Assert.assertTrue((boolean)masterThreads.get(0).getMaster().isActiveMaster());
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testShouldCheckMasterFailOverWhenMETAIsInOpenedState() throws Exception {
        boolean NUM_MASTERS = true;
        int NUM_RS = 2;
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.master.assignment.timeoutmonitor.period", 2000);
        conf.setInt("hbase.master.assignment.timeoutmonitor.timeout", 8000);
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniCluster(1, 2);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        for (JVMClusterUtil.MasterThread mt : masterThreads) {
            Assert.assertTrue((boolean)mt.isAlive());
        }
        Assert.assertEquals((long)1L, (long)masterThreads.size());
        Assert.assertEquals((long)1L, (long)masterThreads.size());
        List<JVMClusterUtil.RegionServerThread> regionServerThreads = cluster.getRegionServerThreads();
        int count = -1;
        HRegion metaRegion = null;
        for (JVMClusterUtil.RegionServerThread regionServerThread : regionServerThreads) {
            HRegionServer regionServer = regionServerThread.getRegionServer();
            metaRegion = regionServer.getOnlineRegion(HRegionInfo.FIRST_META_REGIONINFO.getRegionName());
            ++count;
            regionServer.abort("");
            if (null == metaRegion) continue;
            break;
        }
        HRegionServer regionServer = cluster.getRegionServer(count);
        cluster.shutdown();
        ZooKeeperWatcher zkw = HBaseTestingUtility.createAndForceNodeToOpenedState(TEST_UTIL, metaRegion, regionServer.getServerName());
        TEST_UTIL.startMiniHBaseCluster(1, 1);
        this.log("Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=180000L)
    public void testMasterFailoverWithMockedRIT() throws Exception {
        RegionTransitionData rtd;
        boolean NUM_MASTERS = true;
        int NUM_RS = 3;
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.master.assignment.timeoutmonitor.period", 2000);
        conf.setInt("hbase.master.assignment.timeoutmonitor.timeout", 4000);
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 3);
        conf.setInt("hbase.master.wait.on.regionservers.maxtostart", 3);
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniCluster(1, 3);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        this.log("Cluster started");
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "unittest", new Abortable(){

            public void abort(String why, Throwable e) {
                throw new RuntimeException("Fatal ZK error, why=" + why, e);
            }
        });
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        Assert.assertEquals((long)1L, (long)masterThreads.size());
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster master = masterThreads.get(0).getMaster();
        Assert.assertTrue((boolean)master.isActiveMaster());
        Assert.assertTrue((boolean)master.isInitialized());
        master.balanceSwitch(false);
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[][] SPLIT_KEYS = new byte[][]{new byte[0], Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"jjj")};
        byte[] enabledTable = Bytes.toBytes((String)"enabledTable");
        HTableDescriptor htdEnabled = new HTableDescriptor(enabledTable);
        htdEnabled.addFamily(new HColumnDescriptor(FAMILY));
        List<HRegionInfo> enabledRegions = TEST_UTIL.createMultiRegionsInMeta(TEST_UTIL.getConfiguration(), htdEnabled, SPLIT_KEYS);
        byte[] disabledTable = Bytes.toBytes((String)"disabledTable");
        HTableDescriptor htdDisabled = new HTableDescriptor(disabledTable);
        htdDisabled.addFamily(new HColumnDescriptor(FAMILY));
        List<HRegionInfo> disabledRegions = TEST_UTIL.createMultiRegionsInMeta(TEST_UTIL.getConfiguration(), htdDisabled, SPLIT_KEYS);
        this.log("Regions in META have been created");
        Assert.assertEquals((long)2L, (long)cluster.countServedRegions());
        HRegionServer hrs = cluster.getRegionServer(0);
        String serverName = hrs.getServerName();
        HServerInfo hsiAlive = hrs.getServerInfo();
        ArrayList<HRegionInfo> enabledAndAssignedRegions = new ArrayList<HRegionInfo>();
        enabledAndAssignedRegions.add(enabledRegions.remove(0));
        enabledAndAssignedRegions.add(enabledRegions.remove(0));
        ArrayList<HRegionInfo> disabledAndAssignedRegions = new ArrayList<HRegionInfo>();
        disabledAndAssignedRegions.add(disabledRegions.remove(0));
        disabledAndAssignedRegions.add(disabledRegions.remove(0));
        for (HRegionInfo hri : enabledAndAssignedRegions) {
            master.assignmentManager.regionPlans.put(hri.getEncodedName(), new LoadBalancer.RegionPlan(hri, null, hsiAlive));
            master.assignRegion(hri);
        }
        for (HRegionInfo hri : disabledAndAssignedRegions) {
            master.assignmentManager.regionPlans.put(hri.getEncodedName(), new LoadBalancer.RegionPlan(hri, null, hsiAlive));
            master.assignRegion(hri);
        }
        this.log("Waiting for assignment to finish");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        this.log("Assignment completed");
        this.log("Aborting master");
        cluster.abortMaster(0);
        cluster.waitOnMaster(0);
        this.log("Master has aborted");
        ArrayList<HRegionInfo> regionsThatShouldBeOnline = new ArrayList<HRegionInfo>();
        ArrayList<HRegionInfo> regionsThatShouldBeOffline = new ArrayList<HRegionInfo>();
        this.log("Beginning to mock scenarios");
        ZKTable zktable = new ZKTable(zkw);
        zktable.setDisabledTable(Bytes.toString((byte[])disabledTable));
        HRegionInfo region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)serverName);
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        int version = ZKAssign.createNodeClosing((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)serverName);
        ZKAssign.transitionNodeClosed((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)serverName, (int)version);
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        version = ZKAssign.createNodeClosing((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)serverName);
        ZKAssign.transitionNodeClosed((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)serverName, (int)version);
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)serverName);
        ZKAssign.transitionNodeOpening((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)serverName);
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)serverName);
        hrs.openRegion(region);
        while ((rtd = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)region.getEncodedName())) == null || rtd.getEventType() != EventHandler.EventType.RS_ZK_REGION_OPENED) {
            Thread.sleep(100L);
        }
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)serverName);
        hrs.openRegion(region);
        while ((rtd = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)region.getEncodedName())) == null || rtd.getEventType() != EventHandler.EventType.RS_ZK_REGION_OPENED) {
            Thread.sleep(100L);
        }
        this.log("Done mocking data up in ZK");
        this.log("Starting up a new master");
        master = cluster.startMaster().getMaster();
        this.log("Waiting for master to be ready");
        cluster.waitForActiveAndReadyMaster();
        this.log("Master is ready");
        this.log("Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        this.log("No more RIT in ZK, now doing final test verification");
        TreeSet onlineRegions = new TreeSet();
        for (JVMClusterUtil.RegionServerThread rst : cluster.getRegionServerThreads()) {
            onlineRegions.addAll(rst.getRegionServer().getOnlineRegions());
        }
        for (HRegionInfo hri : regionsThatShouldBeOnline) {
            Assert.assertTrue((boolean)onlineRegions.contains(hri));
        }
        for (HRegionInfo hri : regionsThatShouldBeOffline) {
            Assert.assertFalse((boolean)onlineRegions.contains(hri));
        }
        this.log("Done with verification, all passed, shutting down cluster");
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test(timeout=180000L)
    public void testMasterFailoverWithMockedRITOnDeadRS() throws Exception {
        RegionTransitionData rtd;
        boolean NUM_MASTERS = true;
        int NUM_RS = 2;
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.master.assignment.timeoutmonitor.period", 2000);
        conf.setInt("hbase.master.assignment.timeoutmonitor.timeout", 4000);
        conf.setInt("hbase.master.wait.on.regionservers.mintostart", 1);
        conf.setInt("hbase.master.wait.on.regionservers.maxtostart", 2);
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniCluster(1, 2);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        this.log("Cluster started");
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "unittest", new Abortable(){

            public void abort(String why, Throwable e) {
                LOG.error((Object)("Fatal ZK Error: " + why), e);
                Assert.assertFalse((String)"Fatal ZK error", (boolean)true);
            }
        });
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        Assert.assertEquals((long)1L, (long)masterThreads.size());
        Assert.assertTrue((boolean)cluster.waitForActiveAndReadyMaster());
        HMaster master = masterThreads.get(0).getMaster();
        Assert.assertTrue((boolean)master.isActiveMaster());
        Assert.assertTrue((boolean)master.isInitialized());
        master.balanceSwitch(false);
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[][] SPLIT_KEYS = new byte[][]{new byte[0], Bytes.toBytes((String)"aaa"), Bytes.toBytes((String)"bbb"), Bytes.toBytes((String)"ccc"), Bytes.toBytes((String)"ddd"), Bytes.toBytes((String)"eee"), Bytes.toBytes((String)"fff"), Bytes.toBytes((String)"ggg"), Bytes.toBytes((String)"hhh"), Bytes.toBytes((String)"iii"), Bytes.toBytes((String)"jjj")};
        byte[] enabledTable = Bytes.toBytes((String)"enabledTable");
        HTableDescriptor htdEnabled = new HTableDescriptor(enabledTable);
        htdEnabled.addFamily(new HColumnDescriptor(FAMILY));
        List<HRegionInfo> enabledRegions = TEST_UTIL.createMultiRegionsInMeta(TEST_UTIL.getConfiguration(), htdEnabled, SPLIT_KEYS);
        byte[] disabledTable = Bytes.toBytes((String)"disabledTable");
        HTableDescriptor htdDisabled = new HTableDescriptor(disabledTable);
        htdDisabled.addFamily(new HColumnDescriptor(FAMILY));
        List<HRegionInfo> disabledRegions = TEST_UTIL.createMultiRegionsInMeta(TEST_UTIL.getConfiguration(), htdDisabled, SPLIT_KEYS);
        this.log("Regions in META have been created");
        Assert.assertEquals((long)2L, (long)cluster.countServedRegions());
        HRegionServer hrs = cluster.getRegionServer(0);
        HServerInfo hsiAlive = hrs.getServerInfo();
        HRegionServer hrsDead = cluster.getRegionServer(1);
        String deadServerName = hrsDead.getServerName();
        HServerInfo hsiDead = hrsDead.getServerInfo();
        ArrayList<HRegionInfo> enabledAndAssignedRegions = new ArrayList<HRegionInfo>();
        enabledAndAssignedRegions.add(enabledRegions.remove(0));
        enabledAndAssignedRegions.add(enabledRegions.remove(0));
        ArrayList<HRegionInfo> disabledAndAssignedRegions = new ArrayList<HRegionInfo>();
        disabledAndAssignedRegions.add(disabledRegions.remove(0));
        disabledAndAssignedRegions.add(disabledRegions.remove(0));
        for (HRegionInfo hri : enabledAndAssignedRegions) {
            master.assignmentManager.regionPlans.put(hri.getEncodedName(), new LoadBalancer.RegionPlan(hri, null, hsiAlive));
            master.assignRegion(hri);
        }
        for (HRegionInfo hri : disabledAndAssignedRegions) {
            master.assignmentManager.regionPlans.put(hri.getEncodedName(), new LoadBalancer.RegionPlan(hri, null, hsiAlive));
            master.assignRegion(hri);
        }
        ArrayList<HRegionInfo> enabledAndOnDeadRegions = new ArrayList<HRegionInfo>();
        enabledAndOnDeadRegions.add(enabledRegions.remove(0));
        enabledAndOnDeadRegions.add(enabledRegions.remove(0));
        ArrayList<HRegionInfo> disabledAndOnDeadRegions = new ArrayList<HRegionInfo>();
        disabledAndOnDeadRegions.add(disabledRegions.remove(0));
        disabledAndOnDeadRegions.add(disabledRegions.remove(0));
        for (HRegionInfo hri : enabledAndOnDeadRegions) {
            master.assignmentManager.regionPlans.put(hri.getEncodedName(), new LoadBalancer.RegionPlan(hri, null, hsiDead));
            master.assignRegion(hri);
        }
        for (HRegionInfo hri : disabledAndOnDeadRegions) {
            master.assignmentManager.regionPlans.put(hri.getEncodedName(), new LoadBalancer.RegionPlan(hri, null, hsiDead));
            master.assignRegion(hri);
        }
        this.log("Waiting for assignment to finish");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        this.log("Assignment completed");
        this.log("Aborting master");
        cluster.abortMaster(0);
        cluster.waitOnMaster(0);
        this.log("Master has aborted");
        ArrayList<HRegionInfo> regionsThatShouldBeOnline = new ArrayList<HRegionInfo>();
        ArrayList<HRegionInfo> regionsThatShouldBeOffline = new ArrayList<HRegionInfo>();
        this.log("Beginning to mock scenarios");
        ZKTable zktable = new ZKTable(zkw);
        zktable.setDisabledTable(Bytes.toString((byte[])disabledTable));
        HRegionInfo region = (HRegionInfo)enabledAndOnDeadRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeClosing((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)deadServerName);
        LOG.debug((Object)("\n\nRegion of enabled table was CLOSING on dead RS\n" + region + "\n\n"));
        region = (HRegionInfo)disabledAndOnDeadRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        ZKAssign.createNodeClosing((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)deadServerName);
        LOG.debug((Object)("\n\nRegion of disabled table was CLOSING on dead RS\n" + region + "\n\n"));
        region = (HRegionInfo)enabledAndOnDeadRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        int version = ZKAssign.createNodeClosing((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)deadServerName);
        ZKAssign.transitionNodeClosed((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)deadServerName, (int)version);
        LOG.debug((Object)("\n\nRegion of enabled table was CLOSED on dead RS\n" + region + "\n\n"));
        region = (HRegionInfo)disabledAndOnDeadRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        version = ZKAssign.createNodeClosing((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)deadServerName);
        ZKAssign.transitionNodeClosed((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)deadServerName, (int)version);
        LOG.debug((Object)("\n\nRegion of disabled table was CLOSED on dead RS\n" + region + "\n\n"));
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)deadServerName);
        ZKAssign.transitionNodeOpening((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)deadServerName);
        LOG.debug((Object)("\n\nRegion of enabled table was OPENING on dead RS\n" + region + "\n\n"));
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)deadServerName);
        ZKAssign.transitionNodeOpening((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)deadServerName);
        LOG.debug((Object)("\n\nRegion of disabled table was OPENING on dead RS\n" + region + "\n\n"));
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)deadServerName);
        hrsDead.openRegion(region);
        while ((rtd = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)region.getEncodedName())) == null || rtd.getEventType() != EventHandler.EventType.RS_ZK_REGION_OPENED) {
            Thread.sleep(100L);
        }
        LOG.debug((Object)("\n\nRegion of enabled table was OPENED on dead RS\n" + region + "\n\n"));
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)deadServerName);
        hrsDead.openRegion(region);
        while ((rtd = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)region.getEncodedName())) == null || rtd.getEventType() != EventHandler.EventType.RS_ZK_REGION_OPENED) {
            Thread.sleep(100L);
        }
        LOG.debug((Object)("\n\nRegion of disabled table was OPENED on dead RS\n" + region + "\n\n"));
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)deadServerName);
        hrsDead.openRegion(region);
        while (true) {
            if ((rtd = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)region.getEncodedName())) != null && rtd.getEventType() == EventHandler.EventType.RS_ZK_REGION_OPENED) break;
            Thread.sleep(100L);
        }
        ZKAssign.deleteOpenedNode((ZooKeeperWatcher)zkw, (String)region.getEncodedName());
        LOG.debug((Object)("\n\nRegion of enabled table was open at steady-state on dead RS\n" + region + "\n\n"));
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)deadServerName);
        hrsDead.openRegion(region);
        while (true) {
            if ((rtd = ZKAssign.getData((ZooKeeperWatcher)zkw, (String)region.getEncodedName())) != null && rtd.getEventType() == EventHandler.EventType.RS_ZK_REGION_OPENED) break;
            Thread.sleep(100L);
        }
        ZKAssign.deleteOpenedNode((ZooKeeperWatcher)zkw, (String)region.getEncodedName());
        LOG.debug((Object)("\n\nRegion of disabled table was open at steady-state on dead RS\n" + region + "\n\n"));
        this.log("Done mocking data up in ZK");
        this.log("Killing RS " + deadServerName);
        hrsDead.abort("Killing for unit test");
        this.log("RS " + deadServerName + " killed");
        this.log("Starting up a new master");
        master = cluster.startMaster().getMaster();
        this.log("Waiting for master to be ready");
        cluster.waitForActiveAndReadyMaster();
        this.log("Master is ready");
        region = enabledRegions.remove(0);
        regionsThatShouldBeOnline.add(region);
        master.assignmentManager.regionsInTransition.put(region.getEncodedName(), new AssignmentManager.RegionState(region, AssignmentManager.RegionState.State.PENDING_OPEN, 0L));
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)master.getServerName());
        region = disabledRegions.remove(0);
        regionsThatShouldBeOffline.add(region);
        master.assignmentManager.regionsInTransition.put(region.getEncodedName(), new AssignmentManager.RegionState(region, AssignmentManager.RegionState.State.PENDING_OPEN, 0L));
        ZKAssign.createNodeOffline((ZooKeeperWatcher)zkw, (HRegionInfo)region, (String)master.getServerName());
        this.log("Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        this.log("No more RIT in ZK");
        long now = System.currentTimeMillis();
        long maxTime = 120000L;
        boolean done = master.assignmentManager.waitUntilNoRegionsInTransition(120000L);
        if (!done) {
            LOG.info((Object)("rit=" + master.assignmentManager.getRegionsInTransition()));
        }
        long elapsed = System.currentTimeMillis() - now;
        Assert.assertTrue((String)("Elapsed=" + elapsed + ", maxTime=" + 120000L + ", done=" + done), (elapsed < 120000L ? 1 : 0) != 0);
        this.log("No more RIT in RIT map, doing final test verification");
        TreeSet onlineRegions = new TreeSet();
        for (JVMClusterUtil.RegionServerThread rst : cluster.getRegionServerThreads()) {
            onlineRegions.addAll(rst.getRegionServer().getOnlineRegions());
        }
        for (HRegionInfo hri : regionsThatShouldBeOnline) {
            Assert.assertTrue((String)("region=" + hri.getRegionNameAsString()), (boolean)onlineRegions.contains(hri));
        }
        for (HRegionInfo hri : regionsThatShouldBeOffline) {
            Assert.assertFalse((boolean)onlineRegions.contains(hri));
        }
        this.log("Done with verification, all passed, shutting down cluster");
        TEST_UTIL.shutdownMiniCluster();
    }

    private void log(String string) {
        LOG.info((Object)("\n\n" + string + " \n\n"));
    }
}

