/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.Assert;
import org.junit.Test;

public class TestMasterRestartAfterDisablingTable {
    private static final Log LOG = LogFactory.getLog(TestMasterRestartAfterDisablingTable.class);

    @Test
    public void testForCheckingIfEnableAndDisableWorksFineAfterSwitch() throws Exception {
        int NUM_MASTERS = 2;
        boolean NUM_RS = true;
        int NUM_REGIONS_TO_CREATE = 4;
        this.log("Starting cluster");
        Configuration conf = HBaseConfiguration.create();
        conf.setInt("hbase.master.assignment.timeoutmonitor.period", 2000);
        conf.setInt("hbase.master.assignment.timeoutmonitor.timeout", 5000);
        HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility(conf);
        TEST_UTIL.startMiniCluster(2, 1);
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        this.log("Waiting for active/ready master");
        cluster.waitForActiveAndReadyMaster();
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(conf, "testmasterRestart", null);
        HMaster master = cluster.getMaster();
        byte[] table = Bytes.toBytes((String)"tableRestart");
        byte[] family = Bytes.toBytes((String)"family");
        this.log("Creating table with 4 regions");
        HTable ht = TEST_UTIL.createTable(table, family);
        int numRegions = TEST_UTIL.createMultiRegions(conf, ht, family, 4);
        numRegions += 2;
        this.log("Waiting for no more RIT\n");
        this.blockUntilNoRIT(zkw, master);
        this.log("Disabling table\n");
        TEST_UTIL.getHBaseAdmin().disableTable(table);
        NavigableSet<String> regions = this.getAllOnlineRegions(cluster);
        Assert.assertEquals((String)"The number of regions for the table tableRestart should be 0 and onlythe catalog tables should be present.", (long)2L, (long)regions.size());
        List<JVMClusterUtil.MasterThread> masterThreads = cluster.getMasterThreads();
        JVMClusterUtil.MasterThread activeMaster = null;
        activeMaster = masterThreads.get(0).getMaster().isActiveMaster() ? masterThreads.get(0) : masterThreads.get(1);
        activeMaster.getMaster().stop("stopping the active master so that the backup can become active");
        cluster.hbaseCluster.waitOnMaster(activeMaster);
        cluster.waitForActiveAndReadyMaster();
        this.log("Enabling table\n");
        TEST_UTIL.getHBaseAdmin().enableTable(table);
        this.log("Waiting for no more RIT\n");
        this.blockUntilNoRIT(zkw, master);
        this.log("Verifying there are " + numRegions + " assigned on cluster\n");
        regions = this.getAllOnlineRegions(cluster);
        Assert.assertEquals((String)"The assigned regions were not onlined after master switch except for the catalog tables.", (long)6L, (long)regions.size());
    }

    private void log(String msg) {
        LOG.debug((Object)("\n\nTRR: " + msg + "\n"));
    }

    private void blockUntilNoRIT(ZooKeeperWatcher zkw, HMaster master) throws KeeperException, InterruptedException {
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        master.assignmentManager.waitUntilNoRegionsInTransition(60000L);
    }

    private NavigableSet<String> getAllOnlineRegions(MiniHBaseCluster cluster) throws IOException {
        TreeSet<String> online = new TreeSet<String>();
        for (JVMClusterUtil.RegionServerThread rst : cluster.getLiveRegionServerThreads()) {
            for (HRegionInfo region : rst.getRegionServer().getOnlineRegions()) {
                online.add(region.getRegionNameAsString());
            }
        }
        return online;
    }
}

