/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.handler.OpenedRegionHandler;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.MockServer;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKTable;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestOpenedRegionHandler {
    private static final Log LOG = LogFactory.getLog(TestOpenedRegionHandler.class);
    private static HBaseTestingUtility TEST_UTIL;
    private static final int NUM_MASTERS = 1;
    private static final int NUM_RS = 1;
    private static Configuration conf;
    private static Configuration resetConf;
    private static ZooKeeperWatcher zkw;

    @Before
    public void setUp() throws Exception {
        conf = HBaseConfiguration.create();
        TEST_UTIL = new HBaseTestingUtility(conf);
    }

    @After
    public void tearDown() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        TEST_UTIL = new HBaseTestingUtility(resetConf);
    }

    @Test
    public void testOpenedRegionHandlerOnMasterRestart() throws Exception {
        TestOpenedRegionHandler.log("Starting cluster");
        resetConf = conf;
        conf.setInt("hbase.master.assignment.timeoutmonitor.period", 2000);
        conf.setInt("hbase.master.assignment.timeoutmonitor.timeout", 5000);
        TEST_UTIL.startMiniCluster(1, 1);
        String tableName = "testOpenedRegionHandlerOnMasterRestart";
        MiniHBaseCluster cluster = this.createRegions(tableName);
        this.abortMaster(cluster);
        HRegionServer regionServer = cluster.getRegionServer(0);
        HRegion region = this.getRegionBeingServed(cluster, regionServer);
        zkw = HBaseTestingUtility.createAndForceNodeToOpenedState(TEST_UTIL, region, regionServer.getServerName());
        TestOpenedRegionHandler.log("Starting up a new master");
        cluster.startMaster().getMaster();
        TestOpenedRegionHandler.log("Waiting for master to be ready");
        cluster.waitForActiveAndReadyMaster();
        TestOpenedRegionHandler.log("Master is ready");
        TestOpenedRegionHandler.log("Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShouldNotCompeleteOpenedRegionSuccessfullyIfVersionMismatches() throws Exception {
        try {
            TEST_UTIL.startMiniZKCluster();
            MockServer server = new MockServer();
            HTableDescriptor htd = new HTableDescriptor("testShouldNotCompeleteOpenedRegionSuccessfullyIfVersionMismatches");
            HRegionInfo hri = new HRegionInfo(htd, HConstants.EMPTY_END_ROW, HConstants.EMPTY_END_ROW);
            HRegion region = HRegion.createHRegion((HRegionInfo)hri, (Path)HBaseTestingUtility.getTestDir(), (Configuration)server.getConfiguration());
            Assert.assertNotNull((Object)region);
            AssignmentManager am = (AssignmentManager)Mockito.mock(AssignmentManager.class);
            Mockito.when((Object)am.isRegionInTransition(hri)).thenReturn((Object)new AssignmentManager.RegionState(region.getRegionInfo(), AssignmentManager.RegionState.State.OPEN, System.currentTimeMillis()));
            zkw = HBaseTestingUtility.createAndForceNodeToOpenedState(TEST_UTIL, region, server.getServerName());
            Mockito.when((Object)am.getZKTable()).thenReturn((Object)new ZKTable(zkw));
            Stat stat = new Stat();
            String nodeName = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
            ZKUtil.getDataAndWatch((ZooKeeperWatcher)zkw, (String)nodeName, (Stat)stat);
            OpenedRegionHandler handler = new OpenedRegionHandler((Server)server, am, region.getRegionInfo(), new HServerInfo(new HServerAddress(new InetSocketAddress(1111)), 0, ""), stat.getVersion());
            ZKAssign.transitionNode((ZooKeeperWatcher)zkw, (HRegionInfo)region.getRegionInfo(), (String)server.getServerName(), (EventHandler.EventType)EventHandler.EventType.RS_ZK_REGION_OPENED, (EventHandler.EventType)EventHandler.EventType.RS_ZK_REGION_OPENED, (int)stat.getVersion());
            boolean expectedException = false;
            try {
                handler.process();
            }
            catch (Exception e) {
                expectedException = true;
            }
            Assert.assertFalse((String)"The process method should not throw any exception.", (boolean)expectedException);
            List znodes = ZKUtil.listChildrenAndWatchForNewChildren((ZooKeeperWatcher)zkw, (String)TestOpenedRegionHandler.zkw.assignmentZNode);
            String regionName = (String)znodes.get(0);
            Assert.assertEquals((String)"The region should not be opened successfully.", (Object)regionName, (Object)region.getRegionInfo().getEncodedName());
        }
        finally {
            TEST_UTIL.shutdownMiniZKCluster();
        }
    }

    private MiniHBaseCluster createRegions(String tableName) throws InterruptedException, ZooKeeperConnectionException, IOException, KeeperException {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        TestOpenedRegionHandler.log("Waiting for active/ready master");
        cluster.waitForActiveAndReadyMaster();
        zkw = new ZooKeeperWatcher(conf, "testOpenedRegionHandler", null);
        byte[] table = Bytes.toBytes((String)tableName);
        byte[] family = Bytes.toBytes((String)"family");
        TEST_UTIL.createTable(table, family);
        TestOpenedRegionHandler.log("Waiting for no more RIT");
        ZKAssign.blockUntilNoRIT((ZooKeeperWatcher)zkw);
        return cluster;
    }

    private void abortMaster(MiniHBaseCluster cluster) {
        TestOpenedRegionHandler.log("Aborting master");
        cluster.abortMaster(0);
        cluster.waitOnMaster(0);
        TestOpenedRegionHandler.log("Master has aborted");
    }

    private HRegion getRegionBeingServed(MiniHBaseCluster cluster, HRegionServer regionServer) {
        Collection onlineRegionsLocalContext = regionServer.getOnlineRegionsLocalContext();
        Iterator iterator = onlineRegionsLocalContext.iterator();
        HRegion region = null;
        while (iterator.hasNext() && ((region = (HRegion)iterator.next()).getRegionInfo().isMetaRegion() || region.getRegionInfo().isRootRegion())) {
        }
        return region;
    }

    private static void log(String msg) {
        LOG.debug((Object)("\n\nTRR: " + msg + "\n"));
    }
}

