/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.ReadWriteConsistencyControl;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.JUnitCore;

public class MemStoreScanPerformance {
    private MemStore m;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testTenColumns() {
        ReadWriteConsistencyControl.resetThreadReadPoint();
        long totalScanTime = 0L;
        long totalRows = 0L;
        long totalLoadTime = 0L;
        for (int size = 50000; size < 160000; size += 25000) {
            this.m = new MemStore();
            long start = System.currentTimeMillis();
            for (int i = 0; i < size; ++i) {
                byte[] row = MemStoreScanPerformance.format(i);
                for (int j = 0; j < 10; ++j) {
                    byte[] column = MemStoreScanPerformance.format(j);
                    this.m.add(new KeyValue(row, column, column));
                }
            }
            KeyValue searched = new KeyValue(MemStoreScanPerformance.format(5), MemStoreScanPerformance.format(5), MemStoreScanPerformance.format(5));
            totalLoadTime += System.currentTimeMillis() - start;
            System.out.println("Loaded in " + (System.currentTimeMillis() - start) + " ms");
            for (int i = 0; i < 10; ++i) {
                try {
                    KeyValue kv;
                    start = System.currentTimeMillis();
                    KeyValueScanner scanner = (KeyValueScanner)this.m.getScanners().get(0);
                    scanner.seek(searched);
                    while ((kv = scanner.next()) != null) {
                        kv = scanner.peek();
                    }
                    totalScanTime += System.currentTimeMillis() - start;
                    totalRows += (long)size;
                    System.out.println("Scan with size " + size + ": " + (System.currentTimeMillis() - start) + " ms");
                    continue;
                }
                catch (IOException e) {
                    throw new Error(e);
                }
            }
        }
        System.out.println("Total load time: " + totalLoadTime + " ms (i.e:" + totalLoadTime / 1000L + " seconds)");
        System.out.println("Total scan time: " + totalScanTime + " ms (i.e:" + totalScanTime / 1000L + " seconds)");
        System.out.println("Rows scanned per seconds: " + totalRows * 1000L / totalScanTime);
        System.out.println("Rows loaded per seconds: " + totalRows * 1000L / totalLoadTime);
    }

    private static byte[] format(int number) {
        byte[] b = new byte[10];
        int d = Math.abs(number);
        for (int i = b.length - 1; i >= 0; --i) {
            b[i] = (byte)(d % 10 + 48);
            d /= 10;
        }
        return b;
    }

    public static void main(String[] args) {
        JUnitCore.main((String[])new String[]{MemStoreScanPerformance.class.getName()});
    }
}

