/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.PriorityCompactionQueue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPriorityCompactionQueue {
    static final Log LOG = LogFactory.getLog(TestPriorityCompactionQueue.class);

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
    }

    protected void getAndCheckRegion(PriorityCompactionQueue pq, HRegion checkRegion) {
        HRegion r = pq.remove();
        if (r != checkRegion) {
            Assert.assertTrue((String)("Didn't get expected " + checkRegion + " got " + r), (boolean)r.equals((Object)checkRegion));
        }
    }

    protected void addRegion(PriorityCompactionQueue pq, HRegion r, int p) {
        pq.add(r, p);
        try {
            Thread.sleep(1L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    @Test
    public void testPriorityQueue() throws InterruptedException {
        PriorityCompactionQueue pq = new PriorityCompactionQueue();
        DummyHRegion r1 = new DummyHRegion("r1");
        DummyHRegion r2 = new DummyHRegion("r2");
        DummyHRegion r3 = new DummyHRegion("r3");
        DummyHRegion r4 = new DummyHRegion("r4");
        DummyHRegion r5 = new DummyHRegion("r5");
        this.addRegion(pq, r1, 0);
        this.addRegion(pq, r2, 0);
        this.addRegion(pq, r3, 0);
        this.addRegion(pq, r4, 0);
        this.addRegion(pq, r5, 0);
        this.getAndCheckRegion(pq, r1);
        this.getAndCheckRegion(pq, r2);
        this.getAndCheckRegion(pq, r3);
        this.getAndCheckRegion(pq, r4);
        this.getAndCheckRegion(pq, r5);
        this.addRegion(pq, r1, 0);
        this.addRegion(pq, r2, 1);
        this.addRegion(pq, r3, 0);
        this.addRegion(pq, r4, 1);
        this.addRegion(pq, r5, 0);
        this.getAndCheckRegion(pq, r1);
        this.getAndCheckRegion(pq, r3);
        this.getAndCheckRegion(pq, r5);
        this.getAndCheckRegion(pq, r2);
        this.getAndCheckRegion(pq, r4);
        this.addRegion(pq, r1, 1);
        this.addRegion(pq, r2, 1);
        this.addRegion(pq, r3, 1);
        this.addRegion(pq, r4, 1);
        this.addRegion(pq, r5, 0);
        this.getAndCheckRegion(pq, r5);
        this.getAndCheckRegion(pq, r1);
        this.getAndCheckRegion(pq, r2);
        this.getAndCheckRegion(pq, r3);
        this.getAndCheckRegion(pq, r4);
        this.addRegion(pq, r1, 1);
        this.addRegion(pq, r2, 0);
        this.addRegion(pq, r3, 1);
        Thread.sleep(1000L);
        this.addRegion(pq, r4, 1);
        this.addRegion(pq, r5, 0);
        this.getAndCheckRegion(pq, r2);
        this.getAndCheckRegion(pq, r5);
        this.getAndCheckRegion(pq, r1);
        this.getAndCheckRegion(pq, r3);
        this.getAndCheckRegion(pq, r4);
        pq = new PriorityCompactionQueue();
        this.addRegion(pq, r1, 1);
        this.addRegion(pq, r2, 1);
        this.addRegion(pq, r3, 1);
        this.addRegion(pq, r4, 1);
        this.addRegion(pq, r5, 1);
        this.addRegion(pq, r3, 0);
        this.getAndCheckRegion(pq, r3);
        this.getAndCheckRegion(pq, r1);
        this.getAndCheckRegion(pq, r2);
        this.getAndCheckRegion(pq, r4);
        this.getAndCheckRegion(pq, r5);
        Assert.assertTrue((String)"Queue should be empty.", (pq.size() == 0 ? 1 : 0) != 0);
        this.addRegion(pq, r1, 1);
        this.addRegion(pq, r2, 1);
        this.addRegion(pq, r3, 1);
        this.addRegion(pq, r4, 1);
        this.addRegion(pq, r5, 1);
        this.addRegion(pq, r1, 1);
        this.addRegion(pq, r2, 1);
        this.addRegion(pq, r3, 1);
        this.addRegion(pq, r4, 1);
        this.addRegion(pq, r5, 1);
        this.getAndCheckRegion(pq, r1);
        this.getAndCheckRegion(pq, r2);
        this.getAndCheckRegion(pq, r3);
        this.getAndCheckRegion(pq, r4);
        this.getAndCheckRegion(pq, r5);
        Assert.assertTrue((String)"Queue should be empty.", (pq.size() == 0 ? 1 : 0) != 0);
        this.addRegion(pq, r1, 1);
        this.addRegion(pq, r2, -1);
        this.addRegion(pq, r3, 0);
        this.addRegion(pq, r4, -2);
        this.getAndCheckRegion(pq, r4);
        this.getAndCheckRegion(pq, r2);
        this.getAndCheckRegion(pq, r3);
        this.getAndCheckRegion(pq, r1);
        Assert.assertTrue((String)"Queue should be empty.", (pq.size() == 0 ? 1 : 0) != 0);
    }

    class DummyHRegion
    extends HRegion {
        String name;

        DummyHRegion(String name) {
            this.name = name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(DummyHRegion r) {
            return this.name.equals(r.name);
        }

        public String toString() {
            return "[DummyHRegion " + this.name + "]";
        }

        public String getRegionNameAsString() {
            return this.name;
        }
    }
}

