/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.regionserver.ReadWriteConsistencyControl;

public class TestReadWriteConsistencyControl
extends TestCase {
    public void testParallelism() throws Exception {
        int i;
        final ReadWriteConsistencyControl rwcc = new ReadWriteConsistencyControl();
        final AtomicBoolean finished = new AtomicBoolean(false);
        final AtomicBoolean readerFailed = new AtomicBoolean(false);
        final AtomicLong failedAt = new AtomicLong();
        Runnable reader = new Runnable(){

            @Override
            public void run() {
                long prev = rwcc.memstoreReadPoint();
                while (!finished.get()) {
                    long newPrev = rwcc.memstoreReadPoint();
                    if (newPrev >= prev) continue;
                    System.out.println("Reader got out of order, prev: " + prev + " next was: " + newPrev);
                    readerFailed.set(true);
                    failedAt.set(newPrev);
                    return;
                }
            }
        };
        int n = 20;
        Thread[] writers = new Thread[n];
        AtomicBoolean[] statuses = new AtomicBoolean[n];
        Thread readThread = new Thread(reader);
        for (int i2 = 0; i2 < n; ++i2) {
            statuses[i2] = new AtomicBoolean(true);
            writers[i2] = new Thread(new Writer(finished, rwcc, statuses[i2]));
            writers[i2].start();
        }
        readThread.start();
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        finished.set(true);
        readThread.join();
        for (i = 0; i < n; ++i) {
            writers[i].join();
        }
        TestReadWriteConsistencyControl.assertFalse((boolean)readerFailed.get());
        for (i = 0; i < n; ++i) {
            TestReadWriteConsistencyControl.assertTrue((boolean)statuses[i].get());
        }
    }

    static class Writer
    implements Runnable {
        final AtomicBoolean finished;
        final ReadWriteConsistencyControl rwcc;
        final AtomicBoolean status;
        private Random rnd = new Random();
        public boolean failed = false;

        Writer(AtomicBoolean finished, ReadWriteConsistencyControl rwcc, AtomicBoolean status) {
            this.finished = finished;
            this.rwcc = rwcc;
            this.status = status;
        }

        @Override
        public void run() {
            while (!this.finished.get()) {
                ReadWriteConsistencyControl.WriteEntry e = this.rwcc.beginMemstoreInsert();
                int sleepTime = this.rnd.nextInt(500);
                try {
                    if (sleepTime > 0) {
                        Thread.sleep(0L, sleepTime * 1000);
                    }
                }
                catch (InterruptedException e1) {
                    // empty catch block
                }
                try {
                    this.rwcc.completeMemstoreInsert(e);
                }
                catch (RuntimeException ex) {
                    System.out.println(ex.toString());
                    ex.printStackTrace();
                    this.status.set(false);
                    return;
                }
            }
        }
    }
}

