/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ipc.HBaseRpcMetrics;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.MetricsContext;
import org.apache.hadoop.metrics.MetricsUtil;
import org.apache.hadoop.metrics.spi.AbstractMetricsContext;
import org.apache.hadoop.metrics.spi.OutputRecord;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestRpcMetrics {
    private static Map<String, Boolean> METRICS = new HashMap<String, Boolean>();
    private static HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Log LOG = LogFactory.getLog(TestRpcMetrics.class);

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        ContextFactory factory = ContextFactory.getFactory();
        factory.setAttribute("rpc.class", (Object)MockMetricsContext.class.getName());
        MetricsContext ctx = MetricsUtil.getContext((String)"rpc");
        Assert.assertTrue((String)"Wrong MetricContext implementation class", (boolean)(ctx instanceof MockMetricsContext));
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testCustomMetrics() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.regionserver.port", 0);
        TestRegionServer rs = new TestRegionServer(TEST_UTIL.getConfiguration());
        rs.incTest(5);
        Thread.sleep(1000L);
        String metricName = HBaseRpcMetrics.getMetricName(TestMetrics.class, (String)"test");
        Assert.assertTrue((String)("Metric should have set incremented for " + metricName), (boolean)this.wasSet(metricName + "_num_ops"));
    }

    public boolean wasSet(String name) {
        return METRICS.get(name) != null ? METRICS.get(name) : false;
    }

    public static class MockMetricsContext
    extends AbstractMetricsContext {
        public MockMetricsContext() {
            this.setPeriod(1);
        }

        protected void emitRecord(String contextName, String recordName, OutputRecord outputRecord) throws IOException {
            for (String name : outputRecord.getMetricNames()) {
                Number val = outputRecord.getMetric(name);
                if (val == null || val.intValue() <= 0) continue;
                METRICS.put(name, Boolean.TRUE);
                LOG.debug((Object)("Set metric " + name + " to " + val));
            }
        }
    }

    public static class TestRegionServer
    extends HRegionServer {
        public TestRegionServer(Configuration conf) throws IOException, InterruptedException {
            super(conf);
            this.getRpcMetrics().createMetrics(new Class[]{TestMetrics.class}, true);
        }

        public void incTest(int amt) {
            HBaseRpcMetrics metrics = this.getRpcMetrics();
            metrics.inc(HBaseRpcMetrics.getMetricName(TestMetrics.class, (String)"test"), amt);
        }
    }

    public static interface TestMetrics {
        public void test();
    }
}

