/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.JVMClusterUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestSplitTransactionOnCluster {
    private static final Log LOG = LogFactory.getLog(TestSplitTransactionOnCluster.class);
    private HBaseAdmin admin = null;
    private MiniHBaseCluster cluster = null;
    private static final HBaseTestingUtility TESTING_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void before() throws Exception {
        TESTING_UTIL.getConfiguration().setInt("hbase.balancer.period", 60000);
        TESTING_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void after() throws Exception {
        TESTING_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws IOException {
        TESTING_UTIL.ensureSomeRegionServersAvailable(2);
        this.admin = new HBaseAdmin(TESTING_UTIL.getConfiguration());
        this.cluster = TESTING_UTIL.getMiniHBaseCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=600000L)
    public void testShutdownSimpleFixup() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes((String)"testShutdownSimpleFixup");
        HTable t = TESTING_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        HRegionInfo hri = regions.get(0).getRegionInfo();
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.balanceSwitch(false);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = server.getOnlineRegions().size();
            this.split(hri, server, regionCount);
            List<HRegion> daughters = this.cluster.getRegions(tableName);
            Assert.assertTrue((daughters.size() >= 2 ? 1 : 0) != 0);
            this.removeDaughterFromMeta(daughters.get(0).getRegionName());
            this.cluster.abortRegionServer(tableRegionIndex);
            while (server.getOnlineRegions().size() > 0) {
                LOG.info((Object)"Waiting on server to go down");
                Thread.sleep(100L);
            }
            while (this.cluster.getRegions(tableName).size() < daughters.size()) {
                LOG.info((Object)"Waiting for repair to happen");
                Thread.sleep(1000L);
            }
            regions = this.cluster.getRegions(tableName);
            for (HRegion r : regions) {
                Assert.assertTrue((boolean)daughters.contains(r));
            }
        }
        finally {
            this.admin.balanceSwitch(true);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShutdownFixupWhenDaughterHasSplit() throws IOException, InterruptedException {
        byte[] tableName = Bytes.toBytes((String)"testShutdownFixupWhenDaughterHasSplit");
        HTable t = TESTING_UTIL.createTable(tableName, HConstants.CATALOG_FAMILY);
        List<HRegion> regions = this.cluster.getRegions(tableName);
        Assert.assertEquals((long)1L, (long)regions.size());
        HRegionInfo hri = regions.get(0).getRegionInfo();
        int tableRegionIndex = this.ensureTableRegionNotOnSameServerAsMeta(this.admin, hri);
        this.admin.balanceSwitch(false);
        this.cluster.getMaster().setCatalogJanitorEnabled(false);
        try {
            TESTING_UTIL.loadTable(t, HConstants.CATALOG_FAMILY);
            HRegionServer server = this.cluster.getRegionServer(tableRegionIndex);
            this.printOutRegions(server, "Initial regions: ");
            int regionCount = server.getOnlineRegions().size();
            this.split(hri, server, regionCount);
            List<HRegion> daughters = this.cluster.getRegions(tableName);
            Assert.assertTrue((daughters.size() >= 2 ? 1 : 0) != 0);
            server.reportSplit(hri, daughters.get(0).getRegionInfo(), daughters.get(1).getRegionInfo());
            LOG.info((Object)"Repeating split message. HBASE-3892");
            regionCount = server.getOnlineRegions().size();
            this.split(daughters.get(0).getRegionInfo(), server, regionCount);
            daughters = this.cluster.getRegions(tableName);
            this.cluster.abortRegionServer(tableRegionIndex);
            while (server.getOnlineRegions().size() > 0) {
                LOG.info((Object)"Waiting on server to go down");
                Thread.sleep(100L);
            }
            while (this.cluster.getRegions(tableName).size() < daughters.size()) {
                LOG.info((Object)"Waiting for repair to happen");
                Thread.sleep(1000L);
            }
            regions = this.cluster.getRegions(tableName);
            Assert.assertEquals((long)daughters.size(), (long)regions.size());
            for (HRegion r : regions) {
                Assert.assertTrue((boolean)daughters.contains(r));
            }
        }
        finally {
            this.admin.balanceSwitch(true);
            this.cluster.getMaster().setCatalogJanitorEnabled(true);
        }
    }

    private void split(HRegionInfo hri, HRegionServer server, int regionCount) throws IOException, InterruptedException {
        this.admin.split(hri.getRegionNameAsString());
        while (server.getOnlineRegions().size() <= regionCount) {
            LOG.debug((Object)"Waiting on region to split");
            Thread.sleep(100L);
        }
    }

    private void removeDaughterFromMeta(byte[] regionName) throws IOException {
        HTable metaTable = new HTable(TESTING_UTIL.getConfiguration(), HConstants.META_TABLE_NAME);
        Delete d = new Delete(regionName);
        LOG.info((Object)("Deleted " + Bytes.toString((byte[])regionName)));
        metaTable.delete(d);
    }

    private int ensureTableRegionNotOnSameServerAsMeta(HBaseAdmin admin, HRegionInfo hri) throws UnknownRegionException, MasterNotRunningException, ZooKeeperConnectionException, InterruptedException {
        MiniHBaseCluster cluster = TESTING_UTIL.getMiniHBaseCluster();
        int metaServerIndex = cluster.getServerWithMeta();
        Assert.assertTrue((metaServerIndex != -1 ? 1 : 0) != 0);
        HRegionServer metaRegionServer = cluster.getRegionServer(metaServerIndex);
        int tableRegionIndex = cluster.getServerWith(hri.getRegionName());
        Assert.assertTrue((tableRegionIndex != -1 ? 1 : 0) != 0);
        HRegionServer tableRegionServer = cluster.getRegionServer(tableRegionIndex);
        if (metaRegionServer.getServerName().equals(tableRegionServer.getServerName())) {
            HRegionServer hrs = this.getOtherRegionServer(cluster, metaRegionServer);
            admin.move(hri.getEncodedNameAsBytes(), Bytes.toBytes((String)hrs.getServerName()));
        }
        while ((tableRegionIndex = cluster.getServerWith(hri.getRegionName())) == -1 || tableRegionIndex == metaServerIndex) {
            LOG.debug((Object)("Waiting on region move off the .META. server; current index " + tableRegionIndex));
            Thread.sleep(100L);
        }
        tableRegionIndex = cluster.getServerWith(hri.getRegionName());
        Assert.assertTrue((tableRegionIndex != -1 ? 1 : 0) != 0);
        Assert.assertNotSame((Object)metaServerIndex, (Object)tableRegionIndex);
        return tableRegionIndex;
    }

    private HRegionServer getOtherRegionServer(MiniHBaseCluster cluster, HRegionServer notThisOne) {
        for (JVMClusterUtil.RegionServerThread rst : cluster.getRegionServerThreads()) {
            HRegionServer hrs = rst.getRegionServer();
            if (hrs.getServerName().equals(notThisOne.getServerName()) || hrs.isStopping() || hrs.isStopped()) continue;
            return hrs;
        }
        return null;
    }

    private void printOutRegions(HRegionServer hrs, String prefix) {
        List regions = hrs.getOnlineRegions();
        for (HRegionInfo region : regions) {
            LOG.info((Object)(prefix + region.getRegionNameAsString()));
        }
    }
}

