/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestCase;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hdfs.MiniDFSCluster;

public class TestWideScanner
extends HBaseTestCase {
    private final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    static final byte[] A = Bytes.toBytes((String)"A");
    static final byte[] B = Bytes.toBytes((String)"B");
    static final byte[] C = Bytes.toBytes((String)"C");
    static byte[][] COLUMNS = new byte[][]{A, B, C};
    static final Random rng = new Random();
    static final HTableDescriptor TESTTABLEDESC = new HTableDescriptor("testwidescan");
    public static final HRegionInfo REGION_INFO;
    MiniDFSCluster cluster = null;
    HRegion r;

    @Override
    public void setUp() throws Exception {
        this.cluster = new MiniDFSCluster(this.conf, 2, true, (String[])null);
        this.conf.set("hbase.rootdir", this.cluster.getFileSystem().getHomeDirectory().toString());
        super.setUp();
    }

    private int addWideContent(HRegion region) throws IOException {
        int count = 0;
        for (char c = 'a'; c <= 'c'; c = (char)(c + '\u0001')) {
            byte[] row = Bytes.toBytes((String)("ab" + c));
            long ts = System.currentTimeMillis();
            for (int i = 0; i < 100; ++i) {
                byte[] b = Bytes.toBytes((String)String.format("%10d", i));
                for (int j = 0; j < 100; ++j) {
                    Put put = new Put(row);
                    put.add(COLUMNS[rng.nextInt(COLUMNS.length)], b, ++ts, b);
                    region.put(put);
                    ++count;
                }
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWideScanBatching() throws IOException {
        int batch = 256;
        try {
            boolean more;
            this.r = this.createNewHRegion(REGION_INFO.getTableDesc(), null, null);
            int inserted = this.addWideContent(this.r);
            ArrayList results = new ArrayList();
            Scan scan = new Scan();
            scan.addFamily(A);
            scan.addFamily(B);
            scan.addFamily(C);
            scan.setMaxVersions(100);
            scan.setBatch(256);
            InternalScanner s = this.r.getScanner(scan);
            int total = 0;
            int i = 0;
            do {
                more = s.next(results);
                this.LOG.info((Object)("iteration #" + ++i + ", results.size=" + results.size()));
                TestWideScanner.assertTrue((results.size() <= 256 ? 1 : 0) != 0);
                total += results.size();
                if (results.size() > 0) {
                    byte[] row = ((KeyValue)results.get(0)).getRow();
                    for (KeyValue kv : results) {
                        TestWideScanner.assertTrue((boolean)Bytes.equals((byte[])row, (byte[])kv.getRow()));
                    }
                }
                results.clear();
                for (StoreScanner ss : ((HRegion.RegionScanner)s).storeHeap.getHeap()) {
                    ss.updateReaders();
                }
            } while (more);
            this.LOG.info((Object)("inserted " + inserted + ", scanned " + total));
            TestWideScanner.assertEquals((int)total, (int)inserted);
            s.close();
        }
        finally {
            this.r.close();
            this.r.getLog().closeAndDelete();
            TestWideScanner.shutdownDfs(this.cluster);
        }
    }

    static {
        TESTTABLEDESC.addFamily(new HColumnDescriptor(A, 100, Compression.Algorithm.NONE.getName(), false, true, 8192, Integer.MAX_VALUE, StoreFile.BloomType.NONE.toString(), 0));
        TESTTABLEDESC.addFamily(new HColumnDescriptor(B, 100, Compression.Algorithm.NONE.getName(), false, true, 8192, Integer.MAX_VALUE, StoreFile.BloomType.NONE.toString(), 0));
        TESTTABLEDESC.addFamily(new HColumnDescriptor(C, 100, Compression.Algorithm.NONE.getName(), false, true, 8192, Integer.MAX_VALUE, StoreFile.BloomType.NONE.toString(), 0));
        REGION_INFO = new HRegionInfo(TESTTABLEDESC, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY);
    }
}

