/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.handler;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.handler.OpenRegionHandler;
import org.apache.hadoop.hbase.util.MockRegionServerServices;
import org.apache.hadoop.hbase.util.MockServer;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestOpenRegionHandler {
    private static final HBaseTestingUtility HTU = new HBaseTestingUtility();

    @BeforeClass
    public static void before() throws Exception {
        HTU.startMiniZKCluster();
    }

    @AfterClass
    public static void after() throws IOException {
        HTU.shutdownMiniZKCluster();
    }

    @Test
    public void testOpenRegionHandlerYankingRegionFromUnderIt() throws IOException, KeeperException.NodeExistsException, KeeperException {
        MockServer server = new MockServer();
        MockRegionServerServices rss = new MockRegionServerServices();
        HTableDescriptor htd = new HTableDescriptor("testOpenRegionHandlerYankingRegionFromUnderIt");
        final HRegionInfo hri = new HRegionInfo(htd, HConstants.EMPTY_END_ROW, HConstants.EMPTY_END_ROW);
        OpenRegionHandler handler = new OpenRegionHandler(server, rss, hri){

            HRegion openRegion() {
                HRegion region = super.openRegion();
                ZooKeeperWatcher zkw = this.server.getZooKeeper();
                String node = ZKAssign.getNodeName((ZooKeeperWatcher)zkw, (String)hri.getEncodedName());
                try {
                    ZKUtil.deleteNodeFailSilent((ZooKeeperWatcher)zkw, (String)node);
                }
                catch (KeeperException e) {
                    throw new RuntimeException("Ugh failed delete of " + node, e);
                }
                return region;
            }
        };
        handler.process();
        ZKAssign.createNodeOffline((ZooKeeperWatcher)server.getZooKeeper(), (HRegionInfo)hri, (String)server.getServerName());
        handler.process();
    }
}

