/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.SequenceFileLogReader;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.io.Writable;

public class FaultySequenceFileLogReader
extends SequenceFileLogReader {
    Queue<HLog.Entry> nextQueue = new LinkedList<HLog.Entry>();
    int numberOfFileEntries = 0;

    FailureType getFailureType() {
        return FailureType.valueOf(this.conf.get("faultysequencefilelogreader.failuretype", "NONE"));
    }

    public HLog.Entry next(HLog.Entry reuse) throws IOException {
        HLog.Entry e;
        this.entryStart = this.reader.getPosition();
        boolean b = true;
        if (this.nextQueue.isEmpty()) {
            while (b) {
                HLogKey key = HLog.newKey((Configuration)this.conf);
                WALEdit val = new WALEdit();
                HLog.Entry e2 = new HLog.Entry(key, val);
                b = this.reader.next((Writable)e2.getKey(), (Writable)e2.getEdit());
                this.nextQueue.offer(e2);
                ++this.numberOfFileEntries;
            }
        }
        if (this.nextQueue.size() == this.numberOfFileEntries && this.getFailureType() == FailureType.BEGINNING) {
            throw this.addFileInfoToException(new IOException("fake Exception"));
        }
        if (this.nextQueue.size() == this.numberOfFileEntries / 2 && this.getFailureType() == FailureType.MIDDLE) {
            throw this.addFileInfoToException(new IOException("fake Exception"));
        }
        if (this.nextQueue.size() == 1 && this.getFailureType() == FailureType.END) {
            throw this.addFileInfoToException(new IOException("fake Exception"));
        }
        if (this.nextQueue.peek() != null) {
            ++this.edit;
        }
        if ((e = this.nextQueue.poll()).getEdit().isEmpty()) {
            return null;
        }
        return e;
    }

    static enum FailureType {
        BEGINNING,
        MIDDLE,
        END,
        NONE;

    }
}

