/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.wal.HLog;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.regionserver.wal.WALObserver;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestWALObserver {
    protected static final Log LOG = LogFactory.getLog(TestWALObserver.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] SOME_BYTES = Bytes.toBytes((String)"t");
    private static FileSystem fs;
    private static Path oldLogDir;
    private static Path logDir;
    private static Configuration conf;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hbase.regionserver.maxlogs", 5);
        fs = FileSystem.get((Configuration)conf);
        oldLogDir = new Path(HBaseTestingUtility.getTestDir(), ".oldlogs");
        logDir = new Path(HBaseTestingUtility.getTestDir(), ".logs");
    }

    @Before
    public void setUp() throws Exception {
        fs.delete(logDir, true);
        fs.delete(oldLogDir, true);
    }

    @After
    public void tearDown() throws Exception {
        this.setUp();
    }

    @Test
    public void testActionListener() throws Exception {
        DummyWALObserver observer = new DummyWALObserver();
        ArrayList<DummyWALObserver> list = new ArrayList<DummyWALObserver>();
        list.add(observer);
        DummyWALObserver laterobserver = new DummyWALObserver();
        HLog hlog = new HLog(fs, logDir, oldLogDir, conf, list, null);
        HRegionInfo hri = new HRegionInfo(new HTableDescriptor(SOME_BYTES), SOME_BYTES, SOME_BYTES, false);
        for (int i = 0; i < 20; ++i) {
            byte[] b = Bytes.toBytes((String)(i + ""));
            KeyValue kv = new KeyValue(b, b, b);
            WALEdit edit = new WALEdit();
            edit.add(kv);
            HLogKey key = new HLogKey(b, b, 0L, 0L);
            hlog.append(hri, key, edit);
            if (i == 10) {
                hlog.registerWALActionsListener((WALObserver)laterobserver);
            }
            if (i % 2 != 0) continue;
            hlog.rollWriter();
        }
        hlog.close();
        hlog.closeAndDelete();
        Assert.assertEquals((long)11L, (long)observer.logRollCounter);
        Assert.assertEquals((long)5L, (long)laterobserver.logRollCounter);
        Assert.assertEquals((long)2L, (long)observer.closedCount);
    }

    static class DummyWALObserver
    implements WALObserver {
        public int logRollCounter = 0;
        public int closedCount = 0;

        DummyWALObserver() {
        }

        public void logRolled(Path newFile) {
            ++this.logRollCounter;
        }

        public void logRollRequested() {
        }

        public void visitLogEntryBeforeWrite(HRegionInfo info, HLogKey logKey, WALEdit logEdit) {
        }

        public void logCloseRequested() {
            ++this.closedCount;
        }
    }
}

