/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PageFilter;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.rest.client.Client;
import org.apache.hadoop.hbase.rest.client.Cluster;
import org.apache.hadoop.hbase.rest.client.RemoteAdmin;
import org.apache.hadoop.hbase.rest.client.RemoteHTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Hash;
import org.apache.hadoop.hbase.util.MurmurHash;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.lib.reduce.LongSumReducer;
import org.apache.hadoop.util.LineReader;

public class PerformanceEvaluation {
    protected static final Log LOG = LogFactory.getLog((String)PerformanceEvaluation.class.getName());
    private static final int ROW_LENGTH = 1000;
    private static final int ONE_GB = 1048576000;
    private static final int ROWS_PER_GB = 0x100000;
    public static final byte[] TABLE_NAME = Bytes.toBytes((String)"TestTable");
    public static final byte[] FAMILY_NAME = Bytes.toBytes((String)"info");
    public static final byte[] QUALIFIER_NAME = Bytes.toBytes((String)"data");
    protected static final HTableDescriptor TABLE_DESCRIPTOR = new HTableDescriptor(TABLE_NAME);
    protected Map<String, CmdDescriptor> commands = new TreeMap<String, CmdDescriptor>();
    protected static Cluster cluster;
    protected static String accessToken;
    volatile Configuration conf;
    private boolean nomapred = false;
    private int N = 1;
    private int R = 0x100000;
    private int B = 100;
    private static final Path PERF_EVAL_DIR;
    public static final Pattern LINE_PATTERN;

    public PerformanceEvaluation(Configuration c) {
        this.conf = c;
        this.addCommandDescriptor(RandomReadTest.class, "randomRead", "Run random read test");
        this.addCommandDescriptor(RandomSeekScanTest.class, "randomSeekScan", "Run random seek and scan 100 test");
        this.addCommandDescriptor(RandomScanWithRange10Test.class, "scanRange10", "Run random seek scan with both start and stop row (max 10 rows)");
        this.addCommandDescriptor(RandomScanWithRange100Test.class, "scanRange100", "Run random seek scan with both start and stop row (max 100 rows)");
        this.addCommandDescriptor(RandomScanWithRange1000Test.class, "scanRange1000", "Run random seek scan with both start and stop row (max 1000 rows)");
        this.addCommandDescriptor(RandomScanWithRange10000Test.class, "scanRange10000", "Run random seek scan with both start and stop row (max 10000 rows)");
        this.addCommandDescriptor(RandomWriteTest.class, "randomWrite", "Run random write test");
        this.addCommandDescriptor(SequentialReadTest.class, "sequentialRead", "Run sequential read test");
        this.addCommandDescriptor(SequentialWriteTest.class, "sequentialWrite", "Run sequential write test");
        this.addCommandDescriptor(ScanTest.class, "scan", "Run scan test (read every row)");
        this.addCommandDescriptor(FilteredScanTest.class, "filterScan", "Run scan test using a filter to find a specific row based on it's value (make sure to use --rows=20)");
    }

    protected void addCommandDescriptor(Class<? extends Test> cmdClass, String name, String description) {
        CmdDescriptor cmdDescriptor = new CmdDescriptor(cmdClass, name, description);
        this.commands.put(name, cmdDescriptor);
    }

    private boolean checkTable() throws IOException {
        RemoteAdmin admin = new RemoteAdmin(new Client(cluster), this.conf, accessToken);
        HTableDescriptor tableDescriptor = this.getTableDescriptor();
        if (!admin.isTableAvailable(tableDescriptor.getName())) {
            admin.createTable(tableDescriptor);
            return true;
        }
        return false;
    }

    protected HTableDescriptor getTableDescriptor() {
        return TABLE_DESCRIPTOR;
    }

    private void runNIsMoreThanOne(Class<? extends Test> cmd) throws IOException, InterruptedException, ClassNotFoundException {
        this.checkTable();
        if (this.nomapred) {
            this.doMultipleClients(cmd);
        } else {
            this.doMapReduce(cmd);
        }
    }

    private void doMultipleClients(final Class<? extends Test> cmd) throws IOException {
        ArrayList<Thread> threads = new ArrayList<Thread>(this.N);
        final int perClientRows = this.R / this.N;
        for (int i = 0; i < this.N; ++i) {
            Thread t = new Thread(Integer.toString(i)){

                @Override
                public void run() {
                    super.run();
                    PerformanceEvaluation pe = new PerformanceEvaluation(PerformanceEvaluation.this.conf);
                    int index = Integer.parseInt(this.getName());
                    try {
                        long elapsedTime = pe.runOneClient(cmd, index * perClientRows, perClientRows, PerformanceEvaluation.this.R, PerformanceEvaluation.this.B, new Status(){

                            @Override
                            public void setStatus(String msg) throws IOException {
                                LOG.info((Object)("client-" + this.getName() + " " + msg));
                            }
                        });
                        LOG.info((Object)("Finished " + this.getName() + " in " + elapsedTime + "ms writing " + perClientRows + " rows"));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            };
            threads.add(t);
        }
        for (Thread t : threads) {
            t.start();
        }
        for (Thread t : threads) {
            while (t.isAlive()) {
                try {
                    t.join();
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)("Interrupted, continuing" + e.toString()));
                }
            }
        }
    }

    private void doMapReduce(Class<? extends Test> cmd) throws IOException, InterruptedException, ClassNotFoundException {
        Path inputDir = this.writeInputFile(this.conf);
        this.conf.set("EvaluationMapTask.command", cmd.getName());
        this.conf.set("EvaluationMapTask.performanceEvalImpl", this.getClass().getName());
        Job job = new Job(this.conf);
        job.setJarByClass(PerformanceEvaluation.class);
        job.setJobName("HBase Performance Evaluation");
        job.setInputFormatClass(PeInputFormat.class);
        PeInputFormat.setInputPaths((Job)job, (Path[])new Path[]{inputDir});
        job.setOutputKeyClass(LongWritable.class);
        job.setOutputValueClass(LongWritable.class);
        job.setMapperClass(EvaluationMapTask.class);
        job.setReducerClass(LongSumReducer.class);
        job.setNumReduceTasks(1);
        job.setOutputFormatClass(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((Job)job, (Path)new Path(inputDir, "outputs"));
        job.waitForCompletion(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path writeInputFile(Configuration c) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)c);
        if (!fs.exists(PERF_EVAL_DIR)) {
            fs.mkdirs(PERF_EVAL_DIR);
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        Path subdir = new Path(PERF_EVAL_DIR, formatter.format(new Date()));
        fs.mkdirs(subdir);
        Path inputFile = new Path(subdir, "input.txt");
        PrintStream out = new PrintStream((OutputStream)fs.create(inputFile));
        TreeMap<Integer, String> m = new TreeMap<Integer, String>();
        Hash h = MurmurHash.getInstance();
        int perClientRows = this.R / this.N;
        try {
            for (int i = 0; i < 10; ++i) {
                for (int j = 0; j < this.N; ++j) {
                    String s = "startRow=" + (j * perClientRows + i * (perClientRows / 10)) + ", perClientRunRows=" + perClientRows / 10 + ", totalRows=" + this.R + ", clients=" + this.N + ", rowsPerPut=" + this.B;
                    int hash = h.hash(Bytes.toBytes((String)s));
                    m.put(hash, s);
                }
            }
            for (Map.Entry e : m.entrySet()) {
                out.println((String)e.getValue());
            }
        }
        finally {
            out.close();
        }
        return subdir;
    }

    public static byte[] format(int number) {
        byte[] b = new byte[10];
        int d = Math.abs(number);
        for (int i = b.length - 1; i >= 0; --i) {
            b[i] = (byte)(d % 10 + 48);
            d /= 10;
        }
        return b;
    }

    public static byte[] generateValue(Random r) {
        byte[] b = new byte[1000];
        r.nextBytes(b);
        return b;
    }

    static byte[] getRandomRow(Random random, int totalRows) {
        return PerformanceEvaluation.format(random.nextInt(Integer.MAX_VALUE) % totalRows);
    }

    long runOneClient(Class<? extends Test> cmd, int startRow, int perClientRunRows, int totalRows, int rowsPerPut, Status status) throws IOException {
        status.setStatus("Start " + cmd + " at offset " + startRow + " for " + perClientRunRows + " rows");
        long totalElapsedTime = 0L;
        Test t = null;
        TestOptions options = new TestOptions(startRow, perClientRunRows, totalRows, this.getTableDescriptor().getName(), rowsPerPut);
        try {
            Constructor<? extends Test> constructor = cmd.getDeclaredConstructor(Configuration.class, TestOptions.class, Status.class);
            t = constructor.newInstance(this.conf, options, status);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Invalid command class: " + cmd.getName() + ".  It does not provide a constructor as described by" + "the javadoc comment.  Available constructors are: " + Arrays.toString(cmd.getConstructors()));
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to construct command class", e);
        }
        totalElapsedTime = t.test();
        status.setStatus("Finished " + cmd + " in " + totalElapsedTime + "ms at offset " + startRow + " for " + perClientRunRows + " rows");
        return totalElapsedTime;
    }

    private void runNIsOne(Class<? extends Test> cmd) {
        Status status = new Status(){

            @Override
            public void setStatus(String msg) throws IOException {
                LOG.info((Object)msg);
            }
        };
        try {
            this.checkTable();
            this.runOneClient(cmd, 0, this.R, this.R, this.B, status);
        }
        catch (Exception e) {
            LOG.error((Object)"Failed", (Throwable)e);
        }
    }

    private void runTest(Class<? extends Test> cmd) throws IOException, InterruptedException, ClassNotFoundException {
        if (this.N == 1) {
            this.runNIsOne(cmd);
        } else {
            this.runNIsMoreThanOne(cmd);
        }
    }

    protected void printUsage() {
        this.printUsage(null);
    }

    protected void printUsage(String message) {
        if (message != null && message.length() > 0) {
            System.err.println(message);
        }
        System.err.println("Usage: java " + this.getClass().getName() + " \\");
        System.err.println("  [--option] [--option=value] <command> <nclients>");
        System.err.println();
        System.err.println("Options:");
        System.err.println(" host          String. Specify Stargate endpoint.");
        System.err.println(" token         String. API access token.");
        System.err.println(" rows          Integer. Rows each client runs. Default: One million");
        System.err.println(" rowsPerPut    Integer. Rows each Stargate (multi)Put. Default: 100");
        System.err.println(" nomapred      (Flag) Run multiple clients using threads (rather than use mapreduce)");
        System.err.println();
        System.err.println("Command:");
        for (CmdDescriptor command : this.commands.values()) {
            System.err.println(String.format(" %-15s %s", command.getName(), command.getDescription()));
        }
        System.err.println();
        System.err.println("Args:");
        System.err.println(" nclients      Integer. Required. Total number of clients (and HRegionServers)");
        System.err.println("               running: 1 <= value <= 500");
        System.err.println("Examples:");
        System.err.println(" To run a single evaluation client:");
        System.err.println(" $ bin/hbase " + this.getClass().getName() + " sequentialWrite 1");
    }

    private void getArgs(int start, String[] args) {
        if (start + 1 > args.length) {
            throw new IllegalArgumentException("must supply the number of clients");
        }
        this.N = Integer.parseInt(args[start]);
        if (this.N < 1) {
            throw new IllegalArgumentException("Number of clients must be > 1");
        }
        this.R *= this.N;
    }

    public int doCommandLine(String[] args) {
        int errCode = -1;
        if (args.length < 1) {
            this.printUsage();
            return errCode;
        }
        try {
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equals("-h")) {
                    this.printUsage();
                    errCode = 0;
                } else {
                    String nmr = "--nomapred";
                    if (cmd.startsWith("--nomapred")) {
                        this.nomapred = true;
                        continue;
                    }
                    String rows = "--rows=";
                    if (cmd.startsWith("--rows=")) {
                        this.R = Integer.parseInt(cmd.substring("--rows=".length()));
                        continue;
                    }
                    String rowsPerPut = "--rowsPerPut=";
                    if (cmd.startsWith("--rowsPerPut=")) {
                        this.B = Integer.parseInt(cmd.substring("--rowsPerPut=".length()));
                        continue;
                    }
                    String host = "--host=";
                    if (cmd.startsWith("--host=")) {
                        cluster.add(cmd.substring("--host=".length()));
                        continue;
                    }
                    String token = "--token=";
                    if (cmd.startsWith("--token=")) {
                        accessToken = cmd.substring("--token=".length());
                        continue;
                    }
                    Class<? extends Test> cmdClass = this.determineCommandClass(cmd);
                    if (cmdClass != null) {
                        this.getArgs(i + 1, args);
                        if (cluster.isEmpty()) {
                            String s = this.conf.get("stargate.hostname", "localhost");
                            if (s.contains(":")) {
                                cluster.add(s);
                            } else {
                                cluster.add(s, this.conf.getInt("stargate.port", 8080));
                            }
                        }
                        this.runTest(cmdClass);
                        errCode = 0;
                    } else {
                        this.printUsage();
                    }
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errCode;
    }

    private Class<? extends Test> determineCommandClass(String cmd) {
        CmdDescriptor descriptor = this.commands.get(cmd);
        return descriptor != null ? descriptor.getCmdClass() : null;
    }

    public static void main(String[] args) {
        Configuration c = HBaseConfiguration.create();
        System.exit(new PerformanceEvaluation(c).doCommandLine(args));
    }

    static {
        TABLE_DESCRIPTOR.addFamily(new HColumnDescriptor(FAMILY_NAME));
        cluster = new Cluster();
        accessToken = null;
        PERF_EVAL_DIR = new Path("performance_evaluation");
        LINE_PATTERN = Pattern.compile("startRow=(\\d+),\\s+perClientRunRows=(\\d+),\\s+totalRows=(\\d+),\\s+clients=(\\d+),\\s+rowsPerPut=(\\d+)");
    }

    static class FilteredScanTest
    extends Test {
        protected static final Log LOG = LogFactory.getLog((String)FilteredScanTest.class.getName());

        FilteredScanTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void testRow(int i) throws IOException {
            byte[] value = PerformanceEvaluation.generateValue(this.rand);
            Scan scan = this.constructScan(value);
            ResultScanner scanner = null;
            try {
                scanner = this.table.getScanner(scan);
                while (scanner.next() != null) {
                }
            }
            finally {
                if (scanner != null) {
                    scanner.close();
                }
            }
        }

        protected Scan constructScan(byte[] valuePrefix) throws IOException {
            SingleColumnValueFilter filter = new SingleColumnValueFilter(FAMILY_NAME, QUALIFIER_NAME, CompareFilter.CompareOp.EQUAL, (WritableByteArrayComparable)new BinaryComparator(valuePrefix));
            Scan scan = new Scan();
            scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            scan.setFilter((Filter)filter);
            return scan;
        }
    }

    static class SequentialWriteTest
    extends Test {
        int rowsPerPut;

        SequentialWriteTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
            this.rowsPerPut = options.getRowsPerPut();
        }

        @Override
        void testTimed() throws IOException {
            int lastRow = this.startRow + this.perClientRunRows;
            ArrayList<Put> puts = new ArrayList<Put>();
            for (int i = this.startRow; i < lastRow; i += this.rowsPerPut) {
                for (int j = 0; j < this.rowsPerPut; ++j) {
                    Put put = new Put(PerformanceEvaluation.format(i + j));
                    byte[] value = PerformanceEvaluation.generateValue(this.rand);
                    put.add(FAMILY_NAME, QUALIFIER_NAME, value);
                    puts.add(put);
                    if (this.status == null || i <= 0 || i % this.getReportingPeriod() != 0) continue;
                    this.status.setStatus(this.generateStatus(this.startRow, i, lastRow));
                }
                this.table.put(puts);
            }
        }
    }

    static class SequentialReadTest
    extends Test {
        SequentialReadTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Get get = new Get(PerformanceEvaluation.format(i));
            get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            this.table.get(get);
        }
    }

    static class ScanTest
    extends Test {
        private ResultScanner testScanner;

        ScanTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testSetup() throws IOException {
            super.testSetup();
        }

        @Override
        void testTakedown() throws IOException {
            if (this.testScanner != null) {
                this.testScanner.close();
            }
            super.testTakedown();
        }

        @Override
        void testRow(int i) throws IOException {
            if (this.testScanner == null) {
                Scan scan = new Scan(PerformanceEvaluation.format(this.startRow));
                scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
                this.testScanner = this.table.getScanner(scan);
            }
            this.testScanner.next();
        }
    }

    static class RandomWriteTest
    extends Test {
        int rowsPerPut;

        RandomWriteTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
            this.rowsPerPut = options.getRowsPerPut();
        }

        @Override
        void testTimed() throws IOException {
            int lastRow = this.startRow + this.perClientRunRows;
            ArrayList<Put> puts = new ArrayList<Put>();
            for (int i = this.startRow; i < lastRow; i += this.rowsPerPut) {
                for (int j = 0; j < this.rowsPerPut; ++j) {
                    byte[] row = PerformanceEvaluation.getRandomRow(this.rand, this.totalRows);
                    Put put = new Put(row);
                    byte[] value = PerformanceEvaluation.generateValue(this.rand);
                    put.add(FAMILY_NAME, QUALIFIER_NAME, value);
                    puts.add(put);
                    if (this.status == null || i <= 0 || i % this.getReportingPeriod() != 0) continue;
                    this.status.setStatus(this.generateStatus(this.startRow, i, lastRow));
                }
                this.table.put(puts);
            }
        }
    }

    static class RandomReadTest
    extends Test {
        RandomReadTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Get get = new Get(PerformanceEvaluation.getRandomRow(this.rand, this.totalRows));
            get.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            this.table.get(get);
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.perClientRunRows / 100;
            return period == 0 ? this.perClientRunRows : period;
        }
    }

    static class RandomScanWithRange10000Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange10000Test(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(10000);
        }
    }

    static class RandomScanWithRange1000Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange1000Test(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(1000);
        }
    }

    static class RandomScanWithRange100Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange100Test(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(100);
        }
    }

    static class RandomScanWithRange10Test
    extends RandomScanWithRangeTest {
        RandomScanWithRange10Test(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        protected Pair<byte[], byte[]> getStartAndStopRow() {
            return this.generateStartAndStopRows(10);
        }
    }

    static abstract class RandomScanWithRangeTest
    extends Test {
        RandomScanWithRangeTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Pair<byte[], byte[]> startAndStopRow = this.getStartAndStopRow();
            Scan scan = new Scan((byte[])startAndStopRow.getFirst(), (byte[])startAndStopRow.getSecond());
            scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            ResultScanner s = this.table.getScanner(scan);
            int count = 0;
            Result rr = null;
            while ((rr = s.next()) != null) {
                ++count;
            }
            if (i % 100 == 0) {
                LOG.info((Object)String.format("Scan for key range %s - %s returned %s rows", Bytes.toString((byte[])((byte[])startAndStopRow.getFirst())), Bytes.toString((byte[])((byte[])startAndStopRow.getSecond())), count));
            }
            s.close();
        }

        protected abstract Pair<byte[], byte[]> getStartAndStopRow();

        protected Pair<byte[], byte[]> generateStartAndStopRows(int maxRange) {
            int start = this.rand.nextInt(Integer.MAX_VALUE) % this.totalRows;
            int stop = start + maxRange;
            return new Pair((Object)PerformanceEvaluation.format(start), (Object)PerformanceEvaluation.format(stop));
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.perClientRunRows / 100;
            return period == 0 ? this.perClientRunRows : period;
        }
    }

    static class RandomSeekScanTest
    extends Test {
        RandomSeekScanTest(Configuration conf, TestOptions options, Status status) {
            super(conf, options, status);
        }

        @Override
        void testRow(int i) throws IOException {
            Scan scan = new Scan(PerformanceEvaluation.getRandomRow(this.rand, this.totalRows));
            scan.addColumn(FAMILY_NAME, QUALIFIER_NAME);
            scan.setFilter((Filter)new WhileMatchFilter((Filter)new PageFilter(120L)));
            ResultScanner s = this.table.getScanner(scan);
            Result rr = null;
            while ((rr = s.next()) != null) {
            }
            s.close();
        }

        @Override
        protected int getReportingPeriod() {
            int period = this.perClientRunRows / 100;
            return period == 0 ? this.perClientRunRows : period;
        }
    }

    static abstract class Test {
        private static final Random randomSeed = new Random(System.currentTimeMillis());
        protected final Random rand = new Random(Test.nextRandomSeed());
        protected final int startRow;
        protected final int perClientRunRows;
        protected final int totalRows;
        protected final Status status;
        protected byte[] tableName;
        protected RemoteHTable table;
        protected volatile Configuration conf;

        private static long nextRandomSeed() {
            return randomSeed.nextLong();
        }

        Test(Configuration conf, TestOptions options, Status status) {
            this.startRow = options.getStartRow();
            this.perClientRunRows = options.getPerClientRunRows();
            this.totalRows = options.getTotalRows();
            this.status = status;
            this.tableName = options.getTableName();
            this.table = null;
            this.conf = conf;
        }

        protected String generateStatus(int sr, int i, int lr) {
            return sr + "/" + i + "/" + lr;
        }

        protected int getReportingPeriod() {
            int period = this.perClientRunRows / 10;
            return period == 0 ? this.perClientRunRows : period;
        }

        void testSetup() throws IOException {
            this.table = new RemoteHTable(new Client(cluster), this.conf, this.tableName, accessToken);
        }

        void testTakedown() throws IOException {
            this.table.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long test() throws IOException {
            long elapsedTime;
            this.testSetup();
            long startTime = System.currentTimeMillis();
            try {
                this.testTimed();
                elapsedTime = System.currentTimeMillis() - startTime;
            }
            finally {
                this.testTakedown();
            }
            return elapsedTime;
        }

        void testTimed() throws IOException {
            int lastRow = this.startRow + this.perClientRunRows;
            for (int i = this.startRow; i < lastRow; ++i) {
                this.testRow(i);
                if (this.status == null || i <= 0 || i % this.getReportingPeriod() != 0) continue;
                this.status.setStatus(this.generateStatus(this.startRow, i, lastRow));
            }
        }

        void testRow(int i) throws IOException {
        }
    }

    static class TestOptions {
        private int startRow;
        private int perClientRunRows;
        private int totalRows;
        private byte[] tableName;
        private int rowsPerPut;

        TestOptions() {
        }

        TestOptions(int startRow, int perClientRunRows, int totalRows, byte[] tableName, int rowsPerPut) {
            this.startRow = startRow;
            this.perClientRunRows = perClientRunRows;
            this.totalRows = totalRows;
            this.tableName = tableName;
            this.rowsPerPut = rowsPerPut;
        }

        public int getStartRow() {
            return this.startRow;
        }

        public int getPerClientRunRows() {
            return this.perClientRunRows;
        }

        public int getTotalRows() {
            return this.totalRows;
        }

        public byte[] getTableName() {
            return this.tableName;
        }

        public int getRowsPerPut() {
            return this.rowsPerPut;
        }
    }

    static class CmdDescriptor {
        private Class<? extends Test> cmdClass;
        private String name;
        private String description;

        CmdDescriptor(Class<? extends Test> cmdClass, String name, String description) {
            this.cmdClass = cmdClass;
            this.name = name;
            this.description = description;
        }

        public Class<? extends Test> getCmdClass() {
            return this.cmdClass;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class EvaluationMapTask
    extends Mapper<NullWritable, PeInputSplit, LongWritable, LongWritable> {
        public static final String CMD_KEY = "EvaluationMapTask.command";
        public static final String PE_KEY = "EvaluationMapTask.performanceEvalImpl";
        private Class<? extends Test> cmd;
        private PerformanceEvaluation pe;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.cmd = this.forName(context.getConfiguration().get(CMD_KEY), Test.class);
            Class<PerformanceEvaluation> peClass = this.forName(context.getConfiguration().get(PE_KEY), PerformanceEvaluation.class);
            try {
                this.pe = peClass.getConstructor(Configuration.class).newInstance(context.getConfiguration());
            }
            catch (Exception e) {
                throw new IllegalStateException("Could not instantiate PE instance", e);
            }
        }

        private <Type> Class<? extends Type> forName(String className, Class<Type> type) {
            Class<Type> clazz = null;
            try {
                clazz = Class.forName(className).asSubclass(type);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Could not find class for name: " + className, e);
            }
            return clazz;
        }

        protected void map(NullWritable key, PeInputSplit value, final Mapper.Context context) throws IOException, InterruptedException {
            Status status = new Status(){

                @Override
                public void setStatus(String msg) {
                    context.setStatus(msg);
                }
            };
            long elapsedTime = this.pe.runOneClient(this.cmd, value.getStartRow(), value.getRows(), value.getTotalRows(), value.getRowsPerPut(), status);
            context.getCounter((Enum)Counter.ELAPSED_TIME).increment(elapsedTime);
            context.getCounter((Enum)Counter.ROWS).increment((long)value.rows);
            context.write((Object)new LongWritable((long)value.startRow), (Object)new LongWritable(elapsedTime));
            context.progress();
        }
    }

    public static class PeInputFormat
    extends FileInputFormat<NullWritable, PeInputSplit> {
        public List<InputSplit> getSplits(JobContext job) throws IOException {
            ArrayList<InputSplit> splitList = new ArrayList<InputSplit>();
            for (FileStatus file : this.listStatus(job)) {
                Text lineText;
                Path path = file.getPath();
                FileSystem fs = path.getFileSystem(job.getConfiguration());
                FSDataInputStream fileIn = fs.open(path);
                LineReader in = new LineReader((InputStream)fileIn, job.getConfiguration());
                int lineLen = 0;
                while ((lineLen = in.readLine(lineText = new Text())) > 0) {
                    Matcher m = LINE_PATTERN.matcher(lineText.toString());
                    if (m == null || !m.matches()) continue;
                    int startRow = Integer.parseInt(m.group(1));
                    int rows = Integer.parseInt(m.group(2));
                    int totalRows = Integer.parseInt(m.group(3));
                    int clients = Integer.parseInt(m.group(4));
                    int rowsPerPut = Integer.parseInt(m.group(5));
                    LOG.debug((Object)("split[" + splitList.size() + "] " + " startRow=" + startRow + " rows=" + rows + " totalRows=" + totalRows + " clients=" + clients + " rowsPerPut=" + rowsPerPut));
                    PeInputSplit newSplit = new PeInputSplit(startRow, rows, totalRows, clients, rowsPerPut);
                    splitList.add(newSplit);
                }
                in.close();
            }
            LOG.info((Object)("Total # of splits: " + splitList.size()));
            return splitList;
        }

        public RecordReader<NullWritable, PeInputSplit> createRecordReader(InputSplit split, TaskAttemptContext context) {
            return new PeRecordReader();
        }

        public static class PeRecordReader
        extends RecordReader<NullWritable, PeInputSplit> {
            private boolean readOver = false;
            private PeInputSplit split = null;
            private NullWritable key = null;
            private PeInputSplit value = null;

            public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                this.readOver = false;
                this.split = (PeInputSplit)split;
            }

            public boolean nextKeyValue() throws IOException, InterruptedException {
                if (this.readOver) {
                    return false;
                }
                this.key = NullWritable.get();
                this.value = this.split;
                this.readOver = true;
                return true;
            }

            public NullWritable getCurrentKey() throws IOException, InterruptedException {
                return this.key;
            }

            public PeInputSplit getCurrentValue() throws IOException, InterruptedException {
                return this.value;
            }

            public float getProgress() throws IOException, InterruptedException {
                if (this.readOver) {
                    return 1.0f;
                }
                return 0.0f;
            }

            public void close() throws IOException {
            }
        }
    }

    public static class PeInputSplit
    extends InputSplit
    implements Writable {
        private int startRow = 0;
        private int rows = 0;
        private int totalRows = 0;
        private int clients = 0;
        private int rowsPerPut = 1;

        public PeInputSplit() {
            this.startRow = 0;
            this.rows = 0;
            this.totalRows = 0;
            this.clients = 0;
            this.rowsPerPut = 1;
        }

        public PeInputSplit(int startRow, int rows, int totalRows, int clients, int rowsPerPut) {
            this.startRow = startRow;
            this.rows = rows;
            this.totalRows = totalRows;
            this.clients = clients;
            this.rowsPerPut = 1;
        }

        public void readFields(DataInput in) throws IOException {
            this.startRow = in.readInt();
            this.rows = in.readInt();
            this.totalRows = in.readInt();
            this.clients = in.readInt();
            this.rowsPerPut = in.readInt();
        }

        public void write(DataOutput out) throws IOException {
            out.writeInt(this.startRow);
            out.writeInt(this.rows);
            out.writeInt(this.totalRows);
            out.writeInt(this.clients);
            out.writeInt(this.rowsPerPut);
        }

        public long getLength() throws IOException, InterruptedException {
            return 0L;
        }

        public String[] getLocations() throws IOException, InterruptedException {
            return new String[0];
        }

        public int getStartRow() {
            return this.startRow;
        }

        public int getRows() {
            return this.rows;
        }

        public int getTotalRows() {
            return this.totalRows;
        }

        public int getClients() {
            return this.clients;
        }

        public int getRowsPerPut() {
            return this.rowsPerPut;
        }
    }

    static interface Status {
        public void setStatus(String var1) throws IOException;
    }

    protected static enum Counter {
        ELAPSED_TIME,
        ROWS;

    }
}

