/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest.model;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.rest.model.TableListModel;
import org.apache.hadoop.hbase.rest.model.TableModel;
import org.apache.hadoop.hbase.util.Base64;

public class TestTableListModel
extends TestCase {
    private static final String TABLE1 = "table1";
    private static final String TABLE2 = "table2";
    private static final String TABLE3 = "table3";
    private static final String AS_XML = "<TableList><table name=\"table1\"/><table name=\"table2\"/><table name=\"table3\"/></TableList>";
    private static final String AS_PB = "CgZ0YWJsZTEKBnRhYmxlMgoGdGFibGUz";
    private JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{TableListModel.class, TableModel.class});

    private TableListModel buildTestModel() {
        TableListModel model = new TableListModel();
        model.add(new TableModel(TABLE1));
        model.add(new TableModel(TABLE2));
        model.add(new TableModel(TABLE3));
        return model;
    }

    private String toXML(TableListModel model) throws JAXBException {
        StringWriter writer = new StringWriter();
        this.context.createMarshaller().marshal((Object)model, (Writer)writer);
        return writer.toString();
    }

    private TableListModel fromXML(String xml) throws JAXBException {
        return (TableListModel)this.context.createUnmarshaller().unmarshal((Reader)new StringReader(xml));
    }

    private byte[] toPB(TableListModel model) {
        return model.createProtobufOutput();
    }

    private TableListModel fromPB(String pb) throws IOException {
        return (TableListModel)new TableListModel().getObjectFromMessage(Base64.decode((String)AS_PB));
    }

    private void checkModel(TableListModel model) {
        Iterator tables = model.getTables().iterator();
        TableModel table = (TableModel)tables.next();
        TestTableListModel.assertEquals((String)table.getName(), (String)TABLE1);
        table = (TableModel)tables.next();
        TestTableListModel.assertEquals((String)table.getName(), (String)TABLE2);
        table = (TableModel)tables.next();
        TestTableListModel.assertEquals((String)table.getName(), (String)TABLE3);
        TestTableListModel.assertFalse((boolean)tables.hasNext());
    }

    public void testBuildModel() throws Exception {
        this.checkModel(this.buildTestModel());
    }

    public void testFromXML() throws Exception {
        this.checkModel(this.fromXML(AS_XML));
    }

    public void testFromPB() throws Exception {
        this.checkModel(this.fromPB(AS_PB));
    }
}

