/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.io.Writable;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestHBaseFsck {
    final Log LOG = LogFactory.getLog(this.getClass());
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Configuration conf = TEST_UTIL.getConfiguration();
    private static final byte[] FAM = Bytes.toBytes((String)"fam");
    private HTable tbl;
    private static final byte[][] splits = new byte[][]{Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C")};

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    private HRegionInfo createRegion(Configuration conf, HTableDescriptor htd, byte[] startKey, byte[] endKey) throws IOException {
        HTable meta = new HTable(conf, HConstants.META_TABLE_NAME);
        HRegionInfo hri = new HRegionInfo(htd, startKey, endKey);
        Put put = new Put(hri.getRegionName());
        put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
        meta.put(put);
        return hri;
    }

    public void dumpMeta(HTableDescriptor htd) throws IOException {
        List<byte[]> metaRows = TEST_UTIL.getMetaTableRows(htd.getName());
        for (byte[] row : metaRows) {
            this.LOG.info((Object)Bytes.toString((byte[])row));
        }
    }

    private void deleteRegion(Configuration conf, HTableDescriptor htd, byte[] startKey, byte[] endKey) throws IOException {
        this.LOG.info((Object)"Before delete:");
        this.dumpMeta(htd);
        Map hris = this.tbl.getRegionsInfo();
        for (Map.Entry e : hris.entrySet()) {
            HRegionInfo hri = (HRegionInfo)e.getKey();
            HServerAddress hsa = (HServerAddress)e.getValue();
            if (Bytes.compareTo((byte[])hri.getStartKey(), (byte[])startKey) == 0 && Bytes.compareTo((byte[])hri.getEndKey(), (byte[])endKey) == 0) {
                this.LOG.info((Object)("RegionName: " + hri.getRegionNameAsString()));
                byte[] deleteRow = hri.getRegionName();
                TEST_UTIL.getHBaseAdmin().unassign(deleteRow, true);
                this.LOG.info((Object)("deleting hdfs data: " + hri.toString() + hsa.toString()));
                Path rootDir = new Path(conf.get("hbase.rootdir"));
                FileSystem fs = rootDir.getFileSystem(conf);
                Path p = new Path(rootDir + "/" + htd.getNameAsString(), hri.getEncodedName());
                fs.delete(p, true);
                HTable meta = new HTable(conf, HConstants.META_TABLE_NAME);
                Delete delete = new Delete(deleteRow);
                meta.delete(delete);
            }
            this.LOG.info((Object)(hri.toString() + hsa.toString()));
        }
        TEST_UTIL.getMetaTableRows(htd.getName());
        this.LOG.info((Object)"After delete:");
        this.dumpMeta(htd);
    }

    HTable setupTable(String tablename) throws Exception {
        HTableDescriptor desc = new HTableDescriptor(tablename);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toString((byte[])FAM));
        desc.addFamily(hcd);
        TEST_UTIL.getHBaseAdmin().createTable(desc, splits);
        this.tbl = new HTable(TEST_UTIL.getConfiguration(), tablename);
        return this.tbl;
    }

    void deleteTable(String tablename) throws IOException {
        HBaseAdmin admin = TEST_UTIL.getHBaseAdmin();
        byte[] tbytes = Bytes.toBytes((String)tablename);
        admin.disableTable(tbytes);
        admin.deleteTable(tbytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHBaseFsckClean() throws Exception {
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        String table = "tableClean";
        try {
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
            this.setupTable(table);
            hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertNoErrors(hbck);
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDupeStartKey() throws Exception {
        HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
        String table = "tableDupeStartKey";
        try {
            this.setupTable(table);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            HRegionInfo hriDupe = this.createRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A"), Bytes.toBytes((String)"A2"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriDupe);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriDupe);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS});
            Assert.assertEquals((long)2L, (long)hbck.getOverlapGroups(table).size());
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDegenerateRegions() throws Exception {
        String table = "tableDegenerateRegions";
        try {
            this.setupTable(table);
            HbckTestingUtil.assertNoErrors(HbckTestingUtil.doFsck(conf, false));
            HRegionInfo hriDupe = this.createRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"B"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriDupe);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriDupe);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.DEGENERATE_REGION, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS, HBaseFsck.ErrorReporter.ERROR_CODE.DUPE_STARTKEYS});
            Assert.assertEquals((long)2L, (long)hbck.getOverlapGroups(table).size());
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCoveredStartKey() throws Exception {
        String table = "tableCoveredStartKey";
        try {
            this.setupTable(table);
            HRegionInfo hriOverlap = this.createRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"A2"), Bytes.toBytes((String)"B2"));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriOverlap);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriOverlap);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN, HBaseFsck.ErrorReporter.ERROR_CODE.OVERLAP_IN_REGION_CHAIN});
            Assert.assertEquals((long)3L, (long)hbck.getOverlapGroups(table).size());
        }
        finally {
            this.deleteTable(table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetaHole() throws Exception {
        String table = "tableMetaHole";
        try {
            this.setupTable(table);
            HRegionInfo hriHole = this.createRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"D"), Bytes.toBytes((String)""));
            TEST_UTIL.getHBaseCluster().getMaster().assignRegion(hriHole);
            TEST_UTIL.getHBaseCluster().getMaster().getAssignmentManager().waitForAssignment(hriHole);
            TEST_UTIL.getHBaseAdmin().disableTable(table);
            this.deleteRegion(conf, this.tbl.getTableDescriptor(), Bytes.toBytes((String)"C"), Bytes.toBytes((String)""));
            TEST_UTIL.getHBaseAdmin().enableTable(table);
            HBaseFsck hbck = HbckTestingUtil.doFsck(conf, false);
            HbckTestingUtil.assertErrors(hbck, new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.HOLE_IN_REGION_CHAIN});
            Assert.assertEquals((long)0L, (long)hbck.getOverlapGroups(table).size());
        }
        finally {
            this.deleteTable(table);
        }
    }
}

