/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public class OfflineMetaRebuildTestCore {
    protected static final Log LOG = LogFactory.getLog(OfflineMetaRebuildTestCore.class);
    protected HBaseTestingUtility TEST_UTIL;
    protected Configuration conf;
    private static final byte[] FAM = Bytes.toBytes((String)"fam");
    protected HTable htbl;
    protected static final byte[][] splits = new byte[][]{Bytes.toBytes((String)"A"), Bytes.toBytes((String)"B"), Bytes.toBytes((String)"C")};
    private static final String TABLE_BASE = "tableMetaRebuild";
    private static int tableIdx = 0;
    protected String table = "tableMetaRebuild";

    @Before
    public void setUpBefore() throws Exception {
        this.TEST_UTIL = new HBaseTestingUtility();
        this.TEST_UTIL.getConfiguration().setInt("dfs.datanode.max.xceivers", 9192);
        this.TEST_UTIL.startMiniCluster(3);
        this.conf = this.TEST_UTIL.getConfiguration();
        Assert.assertEquals((long)0L, (long)this.TEST_UTIL.getHBaseAdmin().listTables().length);
        this.table = "tableMetaRebuild-" + tableIdx;
        ++tableIdx;
        this.htbl = this.setupTable(this.table);
        this.populateTable(this.htbl);
        Assert.assertEquals((long)4L, (long)this.scanMeta());
        LOG.info((Object)("Table " + this.table + " has " + this.tableRowCount(this.conf, this.table) + " entries."));
        Assert.assertEquals((long)16L, (long)this.tableRowCount(this.conf, this.table));
        this.TEST_UTIL.getHBaseAdmin().disableTable(this.table);
        Assert.assertEquals((long)1L, (long)this.TEST_UTIL.getHBaseAdmin().listTables().length);
    }

    @After
    public void tearDownAfter() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
        HConnectionManager.deleteConnection((Configuration)this.conf, (boolean)true);
    }

    private HTable setupTable(String tablename) throws Exception {
        HTableDescriptor desc = new HTableDescriptor(tablename);
        HColumnDescriptor hcd = new HColumnDescriptor(Bytes.toString((byte[])FAM));
        desc.addFamily(hcd);
        this.TEST_UTIL.getHBaseAdmin().createTable(desc, splits);
        return new HTable(this.TEST_UTIL.getConfiguration(), tablename);
    }

    private void dumpMeta(HTableDescriptor htd) throws IOException {
        List<byte[]> metaRows = this.TEST_UTIL.getMetaTableRows(htd.getName());
        for (byte[] row : metaRows) {
            LOG.info((Object)Bytes.toString((byte[])row));
        }
    }

    private void populateTable(HTable tbl) throws IOException {
        byte[] values = new byte[]{65, 66, 67, 68};
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < values.length; ++j) {
                Put put = new Put(new byte[]{values[i], values[j]});
                put.add(Bytes.toBytes((String)"fam"), new byte[0], new byte[]{values[i], values[j]});
                tbl.put(put);
            }
        }
        tbl.flushCommits();
    }

    void deleteTable(HBaseAdmin admin, String tablename) throws IOException {
        try {
            byte[] tbytes = Bytes.toBytes((String)tablename);
            admin.disableTable(tbytes);
            admin.deleteTable(tbytes);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void deleteRegion(Configuration conf, HTable tbl, byte[] startKey, byte[] endKey) throws IOException {
        LOG.info((Object)"Before delete:");
        HTableDescriptor htd = tbl.getTableDescriptor();
        this.dumpMeta(htd);
        Map hris = tbl.getRegionsInfo();
        for (Map.Entry e : hris.entrySet()) {
            HRegionInfo hri = (HRegionInfo)e.getKey();
            HServerAddress hsa = (HServerAddress)e.getValue();
            if (Bytes.compareTo((byte[])hri.getStartKey(), (byte[])startKey) == 0 && Bytes.compareTo((byte[])hri.getEndKey(), (byte[])endKey) == 0) {
                LOG.info((Object)("RegionName: " + hri.getRegionNameAsString()));
                byte[] deleteRow = hri.getRegionName();
                this.TEST_UTIL.getHBaseAdmin().unassign(deleteRow, true);
                LOG.info((Object)("deleting hdfs data: " + hri.toString() + hsa.toString()));
                Path rootDir = new Path(conf.get("hbase.rootdir"));
                FileSystem fs = rootDir.getFileSystem(conf);
                Path p = new Path(rootDir + "/" + htd.getNameAsString(), hri.getEncodedName());
                fs.delete(p, true);
                HTable meta = new HTable(conf, HConstants.META_TABLE_NAME);
                Delete delete = new Delete(deleteRow);
                meta.delete(delete);
            }
            LOG.info((Object)(hri.toString() + hsa.toString()));
        }
        this.TEST_UTIL.getMetaTableRows(htd.getName());
        LOG.info((Object)"After delete:");
        this.dumpMeta(htd);
    }

    protected HRegionInfo createRegion(Configuration conf, HTable htbl, byte[] startKey, byte[] endKey) throws IOException {
        HTable meta = new HTable(conf, HConstants.META_TABLE_NAME);
        HTableDescriptor htd = htbl.getTableDescriptor();
        HRegionInfo hri = new HRegionInfo(htd, startKey, endKey);
        LOG.info((Object)("manually adding regioninfo and hdfs data: " + hri.toString()));
        Path rootDir = new Path(conf.get("hbase.rootdir"));
        FileSystem fs = rootDir.getFileSystem(conf);
        Path p = new Path(rootDir + "/" + htd.getNameAsString(), hri.getEncodedName());
        fs.mkdirs(p);
        Path riPath = new Path(p, ".regioninfo");
        FSDataOutputStream out = fs.create(riPath);
        hri.write((DataOutput)out);
        out.close();
        Put put = new Put(hri.getRegionName());
        put.add(HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, Writables.getBytes((Writable)hri));
        meta.put(put);
        meta.flushCommits();
        return hri;
    }

    protected void wipeOutMeta() throws IOException {
        HBaseAdmin admin = this.TEST_UTIL.getHBaseAdmin();
        Scan s = new Scan();
        HTable meta = new HTable(this.conf, HConstants.META_TABLE_NAME);
        ResultScanner scanner = meta.getScanner(s);
        ArrayList<Delete> dels = new ArrayList<Delete>();
        for (Result r : scanner) {
            Delete d = new Delete(r.getRow());
            dels.add(d);
            admin.unassign(r.getRow(), true);
        }
        meta.delete(dels);
        meta.flushCommits();
    }

    protected int tableRowCount(Configuration conf, String table) throws IOException {
        HTable t = new HTable(conf, table);
        Scan st = new Scan();
        ResultScanner rst = t.getScanner(st);
        int count = 0;
        for (Result rt : rst) {
            ++count;
        }
        return count;
    }

    protected int scanMeta() throws IOException {
        int count = 0;
        HTable meta = new HTable(this.conf, HTableDescriptor.META_TABLEDESC.getName());
        ResultScanner scanner = meta.getScanner(new Scan());
        LOG.info((Object)("Table: " + Bytes.toString((byte[])meta.getTableName())));
        for (Result res : scanner) {
            LOG.info((Object)Bytes.toString((byte[])res.getRow()));
            ++count;
        }
        return count;
    }
}

