/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import java.util.Arrays;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.util.hbck.OfflineMetaRebuildTestCore;
import org.junit.Assert;
import org.junit.Test;

public class TestOfflineMetaRebuildHole
extends OfflineMetaRebuildTestCore {
    @Test(timeout=120000L)
    public void testMetaRebuildHoleFail() throws Exception {
        byte[] startKey = splits[1];
        byte[] endKey = splits[2];
        this.deleteRegion(this.conf, this.htbl, startKey, endKey);
        this.wipeOutMeta();
        Assert.assertEquals((long)0L, (long)this.scanMeta());
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(this.conf, false), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED});
        this.TEST_UTIL.shutdownMiniHBaseCluster();
        this.TEST_UTIL.shutdownMiniZKCluster();
        HBaseFsck fsck = new HBaseFsck(this.conf);
        Assert.assertFalse((boolean)fsck.rebuildMeta());
        this.TEST_UTIL.startMiniZKCluster();
        this.TEST_UTIL.restartHBaseCluster(3);
        Assert.assertEquals((long)0L, (long)this.scanMeta());
        Object[] htbls = this.TEST_UTIL.getHBaseAdmin().listTables();
        LOG.info((Object)("Tables present after restart: " + Arrays.toString(htbls)));
        Assert.assertEquals((long)0L, (long)htbls.length);
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(this.conf, false), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED});
    }
}

