/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.hbck;

import com.google.common.collect.Multimap;
import java.util.Arrays;
import org.apache.hadoop.hbase.util.HBaseFsck;
import org.apache.hadoop.hbase.util.hbck.HbckTestingUtil;
import org.apache.hadoop.hbase.util.hbck.OfflineMetaRebuildTestCore;
import org.junit.Assert;
import org.junit.Test;

public class TestOfflineMetaRebuildOverlap
extends OfflineMetaRebuildTestCore {
    @Test(timeout=120000L)
    public void testMetaRebuildOverlapFail() throws Exception {
        byte[] startKey = splits[0];
        byte[] endKey = splits[2];
        this.createRegion(this.conf, this.htbl, startKey, endKey);
        this.wipeOutMeta();
        Assert.assertEquals((long)0L, (long)this.scanMeta());
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(this.conf, false), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED});
        this.TEST_UTIL.shutdownMiniHBaseCluster();
        this.TEST_UTIL.shutdownMiniZKCluster();
        HBaseFsck fsck = new HBaseFsck(this.conf);
        Assert.assertFalse((boolean)fsck.rebuildMeta());
        Multimap problems = fsck.getOverlapGroups(this.table);
        Assert.assertEquals((long)1L, (long)problems.keySet().size());
        Assert.assertEquals((long)3L, (long)problems.size());
        this.TEST_UTIL.startMiniZKCluster();
        this.TEST_UTIL.restartHBaseCluster(3);
        Assert.assertEquals((long)0L, (long)this.scanMeta());
        Object[] htbls = this.TEST_UTIL.getHBaseAdmin().listTables();
        LOG.info((Object)("Tables present after restart: " + Arrays.toString(htbls)));
        Assert.assertEquals((long)0L, (long)htbls.length);
        HbckTestingUtil.assertErrors(HbckTestingUtil.doFsck(this.conf, false), new HBaseFsck.ErrorReporter.ERROR_CODE[]{HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED, HBaseFsck.ErrorReporter.ERROR_CODE.NOT_IN_META_OR_DEPLOYED});
    }
}

