/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.zookeeper.TestZooKeeperNodeTracker;
import org.apache.hadoop.hbase.zookeeper.ZKTable;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestZKTable {
    private static final Log LOG = LogFactory.getLog(TestZooKeeperNodeTracker.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniZKCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testTableStates() throws ZooKeeperConnectionException, IOException, KeeperException {
        String name = "testDisabled";
        Abortable abortable = new Abortable(){

            public void abort(String why, Throwable e) {
                LOG.info((Object)why, e);
            }
        };
        ZooKeeperWatcher zkw = new ZooKeeperWatcher(TEST_UTIL.getConfiguration(), "testDisabled", abortable);
        ZKTable zkt = new ZKTable(zkw);
        Assert.assertTrue((boolean)zkt.isEnabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisablingTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isEnablingTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisablingOrDisabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisabledOrEnablingTable("testDisabled"));
        zkt.setDisablingTable("testDisabled");
        Assert.assertTrue((boolean)zkt.isDisablingTable("testDisabled"));
        Assert.assertTrue((boolean)zkt.isDisablingOrDisabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.getDisabledTables().contains("testDisabled"));
        zkt.setDisabledTable("testDisabled");
        Assert.assertTrue((boolean)zkt.isDisabledTable("testDisabled"));
        Assert.assertTrue((boolean)zkt.isDisablingOrDisabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisablingTable("testDisabled"));
        Assert.assertTrue((boolean)zkt.getDisabledTables().contains("testDisabled"));
        zkt.setEnablingTable("testDisabled");
        Assert.assertTrue((boolean)zkt.isEnablingTable("testDisabled"));
        Assert.assertTrue((boolean)zkt.isDisabledOrEnablingTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isDisabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.getDisabledTables().contains("testDisabled"));
        zkt.setEnabledTable("testDisabled");
        Assert.assertTrue((boolean)zkt.isEnabledTable("testDisabled"));
        Assert.assertFalse((boolean)zkt.isEnablingTable("testDisabled"));
    }
}

