// Autogenerated Jamon implementation
// /home/lhofhans/dev/0.94.10mvn/target/checkout/src/main/jamon/org/apache/hadoop/hbase/tmpl/master/MasterStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.master;

// 35, 1
import java.util.*;
// 36, 1
import org.apache.hadoop.util.StringUtils;
// 37, 1
import org.apache.hadoop.hbase.util.Bytes;
// 38, 1
import org.apache.hadoop.hbase.util.JvmVersion;
// 39, 1
import org.apache.hadoop.hbase.util.FSUtils;
// 40, 1
import org.apache.hadoop.hbase.master.HMaster;
// 41, 1
import org.apache.hadoop.hbase.master.AssignmentManager;
// 42, 1
import org.apache.hadoop.hbase.master.ServerManager;
// 43, 1
import org.apache.hadoop.hbase.HConstants;
// 44, 1
import org.apache.hadoop.hbase.HServerLoad;
// 45, 1
import org.apache.hadoop.hbase.ServerName;
// 46, 1
import org.apache.hadoop.hbase.client.HBaseAdmin;
// 47, 1
import org.apache.hadoop.hbase.client.HConnectionManager;
// 48, 1
import org.apache.hadoop.hbase.HTableDescriptor;
// 49, 1
import org.apache.hadoop.hbase.HBaseConfiguration;
// 50, 1
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos.SnapshotDescription;

public class MasterStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.Intf

{
  private final HMaster master;
  private final HBaseAdmin admin;
  private final List<ServerName> servers;
  private final ServerManager serverManager;
  private final Map<String,Integer> frags;
  private final Set<ServerName> deadServers;
  private final AssignmentManager assignmentManager;
  private final boolean showAppendWarning;
  private final ServerName metaLocation;
  private final String filter;
  private final ServerName rootLocation;
  private final String format;
  protected static org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getServers__IsNotDefault())
    {
      p_implData.setServers(null);
    }
    if(! p_implData.getServerManager__IsNotDefault())
    {
      p_implData.setServerManager(null);
    }
    if(! p_implData.getFrags__IsNotDefault())
    {
      p_implData.setFrags(null);
    }
    if(! p_implData.getDeadServers__IsNotDefault())
    {
      p_implData.setDeadServers(null);
    }
    if(! p_implData.getAssignmentManager__IsNotDefault())
    {
      p_implData.setAssignmentManager(null);
    }
    if(! p_implData.getShowAppendWarning__IsNotDefault())
    {
      p_implData.setShowAppendWarning(false);
    }
    if(! p_implData.getMetaLocation__IsNotDefault())
    {
      p_implData.setMetaLocation(null);
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    if(! p_implData.getRootLocation__IsNotDefault())
    {
      p_implData.setRootLocation(null);
    }
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    return p_implData;
  }
  public MasterStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    master = p_implData.getMaster();
    admin = p_implData.getAdmin();
    servers = p_implData.getServers();
    serverManager = p_implData.getServerManager();
    frags = p_implData.getFrags();
    deadServers = p_implData.getDeadServers();
    assignmentManager = p_implData.getAssignmentManager();
    showAppendWarning = p_implData.getShowAppendWarning();
    metaLocation = p_implData.getMetaLocation();
    filter = p_implData.getFilter();
    rootLocation = p_implData.getRootLocation();
    format = p_implData.getFormat();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 52, 1
    if (format.equals("json") )
    {
      // 52, 30
      jamonWriter.write("\n  ");
      // 53, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_2 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_2.setFormat("json" );
        __jamon__var_2.setFilter(filter);
        __jamon__var_2.renderNoFlush(jamonWriter);
      }
      // 53, 68
      jamonWriter.write("\n  ");
      // 54, 3
      return; 
    }
    // 55, 7
    jamonWriter.write("\n");
    // 56, 1
    
ServerManager serverManager = master.getServerManager();
AssignmentManager assignmentManager = master.getAssignmentManager();

    // 61, 1
    jamonWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!-- Commenting out DOCTYPE so our blue outline shows on hadoop 0.20.205.0, etc.\n     See tail of HBASE-2110 for explaination.\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> \n-->\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n<title>HBase Master: ");
    // 69, 22
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName()), jamonWriter);
    // 69, 50
    jamonWriter.write("</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hbase.css\" />\n</head>\n<body>\n<a id=\"logo\" href=\"http://wiki.apache.org/lucene-hadoop/Hbase\"><img src=\"/static/hbase_logo.png\" alt=\"HBase Logo\" title=\"HBase Logo\" /></a>\n<h1 id=\"page_title\">Master: ");
    // 74, 29
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getHostname()), jamonWriter);
    // 74, 71
    jamonWriter.write(":");
    // 74, 72
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(master.getServerName().getPort()), jamonWriter);
    // 74, 110
    jamonWriter.write("</h1>\n<p id=\"links_menu\">\n  <a href=\"/logs/\">Local logs</a>,\n  <a href=\"/stacks\">Thread Dump</a>,\n  <a href=\"/logLevel\">Log Level</a>,\n  <a href=\"/dump\">Debug dump</a>,\n");
    // 80, 1
    if (HBaseConfiguration.isShowConfInServlet())
    {
      // 80, 48
      jamonWriter.write("\n  <a href=\"/conf\">HBase Configuration</a>\n");
    }
    // 82, 7
    jamonWriter.write("\n</p>\n\n<!-- Various warnings that cluster admins should be aware of -->\n");
    // 86, 1
    if (JvmVersion.isBadJvmVersion() )
    {
      // 86, 37
      jamonWriter.write("\n  <div class=\"warning\">\n  Your current JVM version ");
      // 88, 28
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(System.getProperty("java.version")), jamonWriter);
      // 88, 68
      jamonWriter.write(" is known to be\n  unstable with HBase. Please see the\n  <a href=\"http://wiki.apache.org/hadoop/Hbase/Troubleshooting#A18\">HBase wiki</a>\n  for details.\n  </div>\n");
    }
    // 93, 7
    jamonWriter.write("\n");
    // 94, 1
    if (showAppendWarning )
    {
      // 94, 26
      jamonWriter.write(" \n  <div class=\"warning\">\n  You are currently running the HMaster without HDFS append support enabled.\n  This may result in data loss.\n  Please see the <a href=\"http://wiki.apache.org/hadoop/Hbase/HdfsSyncSupport\">HBase wiki</a>\n  for details.\n  </div>\n");
    }
    // 101, 7
    jamonWriter.write("\n\n<hr id=\"head_rule\" />\n<h2>Attributes</h2>\n<table id=\"attributes_table\">\n<tr><th>Attribute Name</th><th>Value</th><th>Description</th></tr>\n<tr><td>HBase Version</td><td>");
    // 107, 31
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 107, 90
    jamonWriter.write(", r");
    // 107, 93
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 107, 153
    jamonWriter.write("</td><td>HBase version and revision</td></tr>\n<tr><td>HBase Compiled</td><td>");
    // 108, 32
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 108, 88
    jamonWriter.write(", ");
    // 108, 90
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 108, 146
    jamonWriter.write("</td><td>When HBase version was compiled and by whom</td></tr>\n<tr><td>Hadoop Version</td><td>");
    // 109, 32
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getVersion()), jamonWriter);
    // 109, 85
    jamonWriter.write(", r");
    // 109, 88
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getRevision()), jamonWriter);
    // 109, 142
    jamonWriter.write("</td><td>Hadoop version and revision</td></tr>\n<tr><td>Hadoop Compiled</td><td>");
    // 110, 33
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getDate()), jamonWriter);
    // 110, 83
    jamonWriter.write(", ");
    // 110, 85
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.util.VersionInfo.getUser()), jamonWriter);
    // 110, 135
    jamonWriter.write("</td><td>When Hadoop version was compiled and by whom</td></tr>\n<tr><td>HBase Root Directory</td><td>");
    // 111, 38
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(FSUtils.getRootDir(master.getConfiguration()).toString()), jamonWriter);
    // 111, 100
    jamonWriter.write("</td><td>Location of HBase home directory</td></tr>\n<tr><td>Zookeeper Quorum</td><td>");
    // 112, 34
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(master.getZooKeeperWatcher().getQuorum()), jamonWriter);
    // 112, 80
    jamonWriter.write("</td><td>Addresses of all registered ZK servers. For more, see <a href=\"/zk.jsp\">zk dump</a>.</td></tr>\n<tr><td>HMaster Start Time</td><td>");
    // 113, 36
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterStartTime())), jamonWriter);
    // 113, 79
    jamonWriter.write("</td><td>Date stamp of when this HMaster was started</td></tr>\n\n");
    // 115, 1
    if (master.isActiveMaster() )
    {
      // 115, 32
      jamonWriter.write("\n  <tr><td>HMaster Active Time</td><td>");
      // 116, 39
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(master.getMasterActiveTime())), jamonWriter);
      // 116, 83
      jamonWriter.write("</td><td>Date stamp of when this HMaster became active</td></tr>\n  <tr><td>Load average</td><td>");
      // 117, 32
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.limitDecimalTo2((serverManager != null) ? serverManager.getAverageLoad() : 0)), jamonWriter);
      // 117, 127
      jamonWriter.write("</td><td>Average number of regions per regionserver. Naive computation.</td></tr>\n  <tr><td>HBase Cluster ID</td><td>");
      // 118, 36
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(master.getClusterId() != null ? master.getClusterId() : "Not set"), jamonWriter);
      // 118, 107
      jamonWriter.write("<td>Unique identifier generated for each HBase cluster</td></tr>\n  ");
      // 119, 3
      if (frags != null )
      {
        // 119, 24
        jamonWriter.write("\n          <tr><td>Fragmentation</td><td>");
        // 120, 41
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(frags.get("-TOTAL-") != null ? frags.get("-TOTAL-").intValue() + "%" : "n/a"), jamonWriter);
        // 120, 123
        jamonWriter.write("</td><td>Overall fragmentation of all tables, including .META. and -ROOT-.</td></tr>\n  ");
      }
      // 121, 9
      jamonWriter.write("\n  <tr>\n    <td>\n     Coprocessors</td><td>");
      // 124, 27
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(java.util.Arrays.toString(master.getCoprocessors())), jamonWriter);
      // 124, 84
      jamonWriter.write("\n    </td>\n    <td>Coprocessors currently loaded loaded by the master</td>\n  </tr>\n");
    }
    // 128, 7
    jamonWriter.write("\n</table>\n\n");
    // 131, 1
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_3 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_3.setFilter(filter );
      __jamon__var_3.renderNoFlush(jamonWriter);
    }
    // 131, 49
    jamonWriter.write("\n\n");
    // 133, 1
    if ((rootLocation != null) )
    {
      // 133, 31
      jamonWriter.write("\n");
      // 134, 1
      {
        // 134, 1
        __jamon_innerUnit__catalogTables(jamonWriter);
      }
      // 134, 20
      jamonWriter.write("\n");
    }
    // 135, 7
    jamonWriter.write("\n");
    // 136, 1
    if ((metaLocation != null) )
    {
      // 136, 31
      jamonWriter.write("\n");
      // 137, 1
      {
        // 137, 1
        __jamon_innerUnit__userTables(jamonWriter);
      }
      // 137, 17
      jamonWriter.write("\n");
    }
    // 138, 7
    jamonWriter.write("\n");
    // 139, 1
    {
      // 139, 1
      __jamon_innerUnit__userSnapshots(jamonWriter);
    }
    // 139, 20
    jamonWriter.write("\n");
    // 140, 1
    if ((servers != null) )
    {
      // 140, 26
      jamonWriter.write("\n");
      // 141, 1
      {
        // 141, 1
        __jamon_innerUnit__regionServers(jamonWriter);
      }
      // 141, 20
      jamonWriter.write("\n");
    }
    // 142, 7
    jamonWriter.write("\n");
    // 143, 1
    if ((deadServers != null) )
    {
      // 143, 30
      jamonWriter.write("\n");
      // 144, 1
      {
        // 144, 1
        __jamon_innerUnit__deadRegionServers(jamonWriter);
      }
      // 144, 24
      jamonWriter.write("\n");
    }
    // 145, 7
    jamonWriter.write("\n");
    // 146, 1
    if ((assignmentManager != null) )
    {
      // 146, 36
      jamonWriter.write("\n");
      // 147, 1
      {
        org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl __jamon__var_4 = new org.apache.hadoop.hbase.tmpl.master.AssignmentManagerStatusTmpl(this.getTemplateManager());
        __jamon__var_4.renderNoFlush(jamonWriter, assignmentManager);
      }
      // 147, 70
      jamonWriter.write("\n");
    }
    // 148, 7
    jamonWriter.write("\n");
    // 149, 1
    if ((master != null) )
    {
      // 149, 25
      jamonWriter.write("\n    ");
      // 150, 5
      {
        org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl __jamon__var_5 = new org.apache.hadoop.hbase.tmpl.master.BackupMasterStatusTmpl(this.getTemplateManager());
        __jamon__var_5.renderNoFlush(jamonWriter, master );
      }
      // 150, 50
      jamonWriter.write("\n");
    }
    // 151, 7
    jamonWriter.write("\n\n</body>\n</html>\n\n");
    // 300, 1
    
   HConnectionManager.deleteConnection(admin.getConfiguration(), false);

  }
  
  
  // 216, 1
  private void __jamon_innerUnit__userSnapshots(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 217, 1
    
   List<SnapshotDescription> snapshots = admin.listSnapshots();

    // 220, 1
    if ((snapshots != null && snapshots.size() > 0))
    {
      // 220, 51
      jamonWriter.write("\n<table>\n<tr>\n    <th>Snapshot</th>\n    <th>Table</th>\n    <th>Creation Time</th>\n    <th>Type</th>\n</tr>\n");
      // 228, 1
      for (SnapshotDescription snapshotDesc : snapshots)
      {
        // 228, 53
        jamonWriter.write("\n<tr>\n    <td><a href=\"snapshot.jsp?name=");
        // 230, 36
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 230, 64
        jamonWriter.write("\">");
        // 230, 66
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getName()), jamonWriter);
        // 230, 94
        jamonWriter.write("</a></td>\n    <td><a href=\"table.jsp?name=");
        // 231, 33
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getTable()), jamonWriter);
        // 231, 62
        jamonWriter.write("\">");
        // 231, 64
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getTable()), jamonWriter);
        // 231, 93
        jamonWriter.write("</a></td>\n    <td>");
        // 232, 9
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(snapshotDesc.getCreationTime())), jamonWriter);
        // 232, 55
        jamonWriter.write("</td>\n    <td>");
        // 233, 9
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(snapshotDesc.getType()), jamonWriter);
        // 233, 37
        jamonWriter.write("</td>\n</tr>\n");
      }
      // 235, 8
      jamonWriter.write("\n\n<p> ");
      // 237, 5
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(snapshots.size()), jamonWriter);
      // 237, 27
      jamonWriter.write(" snapshot(s) in set.</p>\n</table>\n");
    }
    // 239, 7
    jamonWriter.write("\n");
  }
  
  
  // 156, 1
  private void __jamon_innerUnit__catalogTables(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 157, 1
    jamonWriter.write("<h2>Tables</h2>\n<table>\n<tr>\n    <th>Catalog Table</th>\n    ");
    // 161, 5
    if ((frags != null) )
    {
      // 161, 28
      jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n    ");
    }
    // 163, 11
    jamonWriter.write("\n    <th>Description</th>\n</tr>\n<tr>\n    <td><a href=\"table.jsp?name=");
    // 167, 33
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toString(HConstants.ROOT_TABLE_NAME)), jamonWriter);
    // 167, 81
    jamonWriter.write("\">");
    // 167, 83
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toString(HConstants.ROOT_TABLE_NAME)), jamonWriter);
    // 167, 131
    jamonWriter.write("</a></td>\n  ");
    // 168, 3
    if ((frags != null))
    {
      // 168, 25
      jamonWriter.write("\n        <td align=\"center\">");
      // 169, 28
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(frags.get("-ROOT-") != null ? frags.get("-ROOT-").intValue() + "%" : "n/a"), jamonWriter);
      // 169, 108
      jamonWriter.write("</td>\n  ");
    }
    // 170, 9
    jamonWriter.write("\n    <td>The -ROOT- table holds references to all .META. regions.</td>\n</tr>\n  ");
    // 173, 3
    if ((metaLocation != null) )
    {
      // 173, 33
      jamonWriter.write("\n<tr>\n    <td><a href=\"table.jsp?name=");
      // 175, 33
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toString(HConstants.META_TABLE_NAME)), jamonWriter);
      // 175, 81
      jamonWriter.write("\">");
      // 175, 83
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toString(HConstants.META_TABLE_NAME)), jamonWriter);
      // 175, 131
      jamonWriter.write("</a></td>\n    ");
      // 176, 5
      if ((frags != null))
      {
        // 176, 27
        jamonWriter.write("\n        <td align=\"center\">");
        // 177, 28
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(".META.") != null ? frags.get(".META.").intValue() + "%" : "n/a"), jamonWriter);
        // 177, 108
        jamonWriter.write("</td>\n    ");
      }
      // 178, 11
      jamonWriter.write("\n    <td>The .META. table holds references to all User Table regions</td>\n</tr>\n  \n  ");
    }
    // 182, 9
    jamonWriter.write("\n</table>\n");
  }
  
  
  // 186, 1
  private void __jamon_innerUnit__userTables(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 187, 1
    
   HTableDescriptor[] tables = admin.listTables();

    // 190, 1
    if ((tables != null && tables.length > 0))
    {
      // 190, 45
      jamonWriter.write("\n<table>\n<tr>\n    <th>User Table</th>\n");
      // 194, 1
      if ((frags != null) )
      {
        // 194, 24
        jamonWriter.write("\n        <th title=\"Fragmentation - Will be 0% after a major compaction and fluctuate during normal usage.\">Frag.</th>\n");
      }
      // 196, 7
      jamonWriter.write("\n    <th>Online Regions</th>\n    <th>Description</th>\n</tr>\n");
      // 200, 1
      for (HTableDescriptor htDesc : tables)
      {
        // 200, 41
        jamonWriter.write("\n<tr>\n    <td><a href=table.jsp?name=");
        // 202, 32
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.getNameAsString()), jamonWriter);
        // 202, 62
        jamonWriter.write(">");
        // 202, 63
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.getNameAsString()), jamonWriter);
        // 202, 93
        jamonWriter.write("</a> </td>\n    ");
        // 203, 5
        if ((frags != null) )
        {
          // 203, 28
          jamonWriter.write("\n        <td align=\"center\">");
          // 204, 28
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(frags.get(htDesc.getNameAsString()) != null ? frags.get(htDesc.getNameAsString()).intValue() + "%" : "n/a"), jamonWriter);
          // 204, 140
          jamonWriter.write("</td>\n    ");
        }
        // 205, 11
        jamonWriter.write("\n    <td>");
        // 206, 9
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(master.getAssignmentManager().getRegionsOfTable(htDesc.getName()).size()), jamonWriter);
        // 206, 87
        jamonWriter.write("\n    <td>");
        // 207, 9
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(htDesc.toStringCustomizedValues()), jamonWriter);
        // 207, 48
        jamonWriter.write("</td>\n</tr>\n");
      }
      // 209, 8
      jamonWriter.write("\n\n<p> ");
      // 211, 5
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(tables.length), jamonWriter);
      // 211, 24
      jamonWriter.write(" table(s) in set. [<a href=tablesDetailed.jsp>Details</a>]</p>\n</table>\n");
    }
    // 213, 7
    jamonWriter.write("\n");
  }
  
  
  // 242, 1
  private void __jamon_innerUnit__regionServers(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 243, 1
    jamonWriter.write("<h2>Region Servers</h2>\n");
    // 244, 1
    if ((servers != null && servers.size() > 0))
    {
      // 244, 47
      jamonWriter.write("\n");
      // 245, 1
      
     int totalRegions = 0;
     int totalRequests = 0; 

      // 250, 1
      jamonWriter.write("<table>\n<tr><th rowspan=\"");
      // 251, 18
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(servers.size() + 1), jamonWriter);
      // 251, 41
      jamonWriter.write("\"></th><th>ServerName</th><th>Start time</th><th>Load</th></tr>\n");
      // 252, 1
      
   ServerName [] serverNames = servers.toArray(new ServerName[servers.size()]);
     Arrays.sort(serverNames);
     for (ServerName serverName: serverNames) {
       // TODO: this is incorrect since this conf might differ from RS to RS
       // or be set to 0 to get ephemeral ports
       int infoPort = master.getConfiguration().getInt("hbase.regionserver.info.port", 60030);
       String url = "http://" + serverName.getHostname() + ":" + infoPort + "/";
       HServerLoad hsl = master.getServerManager().getLoad(serverName);
       String loadStr = hsl == null? "-": hsl.toString();
       if (hsl != null) {
         totalRegions += hsl.getNumberOfRegions();
         totalRequests += hsl.getNumberOfRequests();
       }
       long startcode = serverName.getStartcode();

      // 268, 1
      jamonWriter.write("<tr><td><a href=\"");
      // 268, 18
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 268, 27
      jamonWriter.write("\">");
      // 268, 29
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName), jamonWriter);
      // 268, 45
      jamonWriter.write("</a></td><td>");
      // 268, 58
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(startcode)), jamonWriter);
      // 268, 83
      jamonWriter.write("</td><td>");
      // 268, 92
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(loadStr), jamonWriter);
      // 268, 105
      jamonWriter.write("</td></tr>\n");
      // 269, 1
      
    }

      // 272, 1
      jamonWriter.write("<tr><th>Total: </th><td>servers: ");
      // 272, 34
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(servers.size()), jamonWriter);
      // 272, 54
      jamonWriter.write("</td><td></td><td>requestsPerSecond=");
      // 272, 90
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRequests), jamonWriter);
      // 272, 109
      jamonWriter.write(", numberOfOnlineRegions=");
      // 272, 133
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(totalRegions), jamonWriter);
      // 272, 151
      jamonWriter.write("</td></tr>\n</table>\n\n<p>Load is requests per second and count of regions loaded</p>\n");
    }
    // 276, 7
    jamonWriter.write("\n");
  }
  
  
  // 279, 1
  private void __jamon_innerUnit__deadRegionServers(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 280, 1
    jamonWriter.write("<h3>Dead Region Servers</h3>\n");
    // 281, 1
    if ((deadServers != null && deadServers.size() > 0))
    {
      // 281, 55
      jamonWriter.write("\n\n<table>\n<tr><th rowspan=\"");
      // 284, 18
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(deadServers.size() + 1), jamonWriter);
      // 284, 45
      jamonWriter.write("\"></th><th>ServerName</th></tr>\n");
      // 285, 1
      
   ServerName [] deadServerNames = deadServers.toArray(new ServerName[deadServers.size()]);
     Arrays.sort(deadServerNames);
     for (ServerName deadServerName: deadServerNames) {
       int infoPort = master.getConfiguration().getInt("hbase.regionserver.info.port", 60030);

      // 291, 1
      jamonWriter.write("<tr><td>");
      // 291, 9
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(deadServerName), jamonWriter);
      // 291, 29
      jamonWriter.write("</td></tr>\n");
      // 292, 1
      
    }

      // 295, 1
      jamonWriter.write("<tr><th>Total: </th><td>servers: ");
      // 295, 34
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(deadServers.size()), jamonWriter);
      // 295, 58
      jamonWriter.write("</td></tr>\n</table>\n");
    }
    // 297, 7
    jamonWriter.write("\n");
  }
  
  
}
