// Autogenerated Jamon implementation
// /home/lars/dev/0.94.14mvn/target/checkout/src/main/jamon/org/apache/hadoop/hbase/tmpl/common/TaskMonitorTmpl.jamon

package org.apache.hadoop.hbase.tmpl.common;

// 21, 1
import java.util.*;
// 22, 1
import org.apache.hadoop.hbase.monitoring.*;
// 23, 1
import org.apache.hadoop.util.StringUtils;

public class TaskMonitorTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.Intf

{
  private final String format;
  private final TaskMonitor taskMonitor;
  private final String filter;
  protected static org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.ImplData p_implData)
  {
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getTaskMonitor__IsNotDefault())
    {
      p_implData.setTaskMonitor(TaskMonitor.get());
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    return p_implData;
  }
  public TaskMonitorTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    format = p_implData.getFormat();
    taskMonitor = p_implData.getTaskMonitor();
    filter = p_implData.getFilter();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 30, 1
    
List<? extends MonitoredTask> tasks = taskMonitor.getTasks();
Iterator<? extends MonitoredTask> iter = tasks.iterator();
// apply requested filter
while (iter.hasNext()) {
  MonitoredTask t = iter.next();
  if (filter.equals("general")) {
    if (t instanceof MonitoredRPCHandler)
      iter.remove();
  } else if (filter.equals("handler")) {
    if (!(t instanceof MonitoredRPCHandler))
      iter.remove();
  } else if (filter.equals("rpc")) {
    if (!(t instanceof MonitoredRPCHandler) || 
        !((MonitoredRPCHandler) t).isRPCRunning())
      iter.remove();
  } else if (filter.equals("operation")) {
    if (!(t instanceof MonitoredRPCHandler) || 
        !((MonitoredRPCHandler) t).isOperationRunning())
      iter.remove();
  }
}
long now = System.currentTimeMillis();
Collections.reverse(tasks);
boolean first = true;

    // 56, 1
    if (format.equals("json"))
    {
      // 56, 29
      jamonWriter.write("\n[");
      // 57, 2
      for (MonitoredTask task : tasks)
      {
        // 57, 36
        if (first)
        {
          // 57, 48
          first = false;
        }
        // 57, 77
        else
        {
          // 57, 84
          jamonWriter.write(",");
        }
        // 57, 91
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.toJSON()), jamonWriter);
      }
      // 57, 117
      jamonWriter.write("]\n");
    }
    // 58, 1
    else
    {
      // 58, 8
      jamonWriter.write("\n<h2>Tasks</h2>\n  <div id=\"tasks_menu\">\n    <a href=\"?filter=all\">Show All Monitored Tasks</a>\n    <a href=\"?filter=general\">Show non-RPC Tasks</a>\n    <a href=\"?filter=handler\">Show All RPC Handler Tasks</a>\n    <a href=\"?filter=rpc\">Show Active RPC Calls</a>\n    <a href=\"?filter=operation\">Show Client Operations</a>\n    <a href=\"?format=json&filter=");
      // 66, 34
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(filter), jamonWriter);
      // 66, 46
      jamonWriter.write("\">View as JSON</a>\n  </div>\n  ");
      // 68, 3
      if (tasks.isEmpty())
      {
        // 68, 25
        jamonWriter.write("\n    No tasks currently running on this node.\n  ");
      }
      // 70, 3
      else
      {
        // 70, 10
        jamonWriter.write("\n    <table>\n    <tr>\n      <th>Start Time</th>\n      <th>Description</th>\n      <th>State</th>\n      <th>Status</th>\n    </tr>\n    ");
        // 78, 5
        for (MonitoredTask task : tasks )
        {
          // 78, 40
          jamonWriter.write("\n    <tr class=\"task-monitor-");
          // 79, 29
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getState()), jamonWriter);
          // 79, 50
          jamonWriter.write("\">\n      <td>");
          // 80, 11
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(task.getStartTime())), jamonWriter);
          // 80, 46
          jamonWriter.write("</td>\n      <td>");
          // 81, 11
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getDescription()), jamonWriter);
          // 81, 38
          jamonWriter.write("</td>\n      <td>");
          // 82, 11
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getState()), jamonWriter);
          // 82, 32
          jamonWriter.write("\n          (since ");
          // 83, 18
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.formatTimeDiff(now, task.getStateTime())), jamonWriter);
          // 83, 76
          jamonWriter.write(" ago)\n      </td>\n      <td>");
          // 85, 11
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(task.getStatus()), jamonWriter);
          // 85, 33
          jamonWriter.write("\n          (since ");
          // 86, 18
          org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(StringUtils.formatTimeDiff(now, task.getStatusTime())), jamonWriter);
          // 86, 77
          jamonWriter.write(" \n          ago)</td>\n    </tr>\n    ");
        }
        // 89, 12
        jamonWriter.write("\n    </table>\n\n  ");
      }
      // 92, 9
      jamonWriter.write("\n");
    }
    // 93, 7
    jamonWriter.write("\n");
  }
  
  
}
