// Autogenerated Jamon implementation
// /home/lars/dev/0.94.14mvn/target/checkout/src/main/jamon/org/apache/hadoop/hbase/tmpl/regionserver/RSStatusTmpl.jamon

package org.apache.hadoop.hbase.tmpl.regionserver;

// 26, 1
import java.util.*;
// 27, 1
import java.io.IOException;
// 28, 1
import org.apache.hadoop.io.Text;
// 29, 1
import org.apache.hadoop.hbase.regionserver.HRegionServer;
// 30, 1
import org.apache.hadoop.hbase.regionserver.HRegion;
// 31, 1
import org.apache.hadoop.hbase.regionserver.metrics.RegionServerMetrics;
// 32, 1
import org.apache.hadoop.hbase.util.Bytes;
// 33, 1
import org.apache.hadoop.hbase.HConstants;
// 34, 1
import org.apache.hadoop.hbase.HServerInfo;
// 35, 1
import org.apache.hadoop.hbase.HServerLoad;
// 36, 1
import org.apache.hadoop.hbase.HRegionInfo;
// 37, 1
import org.apache.hadoop.hbase.ServerName;
// 38, 1
import org.apache.hadoop.hbase.HBaseConfiguration;

public class RSStatusTmplImpl
  extends org.jamon.AbstractTemplateImpl
  implements org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.Intf

{
  private final HRegionServer regionServer;
  private final String format;
  private final String filter;
  protected static org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData __jamon_setOptionalArguments(org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData p_implData)
  {
    if(! p_implData.getFormat__IsNotDefault())
    {
      p_implData.setFormat("html");
    }
    if(! p_implData.getFilter__IsNotDefault())
    {
      p_implData.setFilter("general");
    }
    return p_implData;
  }
  public RSStatusTmplImpl(org.jamon.TemplateManager p_templateManager, org.apache.hadoop.hbase.tmpl.regionserver.RSStatusTmpl.ImplData p_implData)
  {
    super(p_templateManager, __jamon_setOptionalArguments(p_implData));
    regionServer = p_implData.getRegionServer();
    format = p_implData.getFormat();
    filter = p_implData.getFilter();
  }
  
  public void renderNoFlush(@SuppressWarnings({"unused","hiding"}) final java.io.Writer jamonWriter)
    throws java.io.IOException
  {
    // 40, 1
    if (format.equals("json") )
    {
      // 40, 30
      jamonWriter.write("\n  ");
      // 41, 3
      {
        org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_0 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
        __jamon__var_0.setFilter(filter);
        __jamon__var_0.setFormat("json" );
        __jamon__var_0.renderNoFlush(jamonWriter);
      }
      // 41, 68
      jamonWriter.write("\n  ");
      // 42, 3
      return; 
    }
    // 43, 7
    jamonWriter.write("\n");
    // 44, 1
    
  HServerInfo serverInfo = null;
  ServerName serverName = null;
  try {
    serverInfo = regionServer.getHServerInfo();
    serverName = regionServer.getServerName();
  } catch (IOException e) {
    e.printStackTrace();
  }
  RegionServerMetrics metrics = regionServer.getMetrics();
  List<HRegionInfo> onlineRegions = regionServer.getOnlineRegions();
  int interval = regionServer.getConfiguration().getInt("hbase.regionserver.msginterval", 3000)/1000;
  int masterInfoPort = regionServer.getConfiguration().getInt("hbase.master.info.port", 60010);

    // 58, 1
    jamonWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<!-- Commenting out DOCTYPE so our blue outline shows on hadoop 0.20.205.0, etc.\n     See tail of HBASE-2110 for explaination.\n<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \n  \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\"> \n-->\n<html xmlns=\"http://www.w3.org/1999/xhtml\">\n<head><meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>\n<title>HBase Region Server: ");
    // 66, 29
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName), jamonWriter);
    // 66, 45
    jamonWriter.write(":");
    // 66, 46
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverInfo.getServerAddress().getPort()), jamonWriter);
    // 66, 91
    jamonWriter.write("</title>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"/static/hbase.css\" />\n</head>\n\n<body>\n<a id=\"logo\" href=\"http://wiki.apache.org/lucene-hadoop/Hbase\"><img src=\"/static/hbase_logo.png\" alt=\"HBase Logo\" title=\"HBase Logo\" /></a>\n<h1 id=\"page_title\">RegionServer: ");
    // 72, 35
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(serverName), jamonWriter);
    // 72, 51
    jamonWriter.write("</h1>\n<p id=\"links_menu\">\n  <a href=\"/logs/\">Local logs</a>,\n  <a href=\"/stacks\">Thread Dump</a>,\n  <a href=\"/logLevel\">Log Level</a>,\n  <a href=\"/dump\">Debug dump</a>,\n");
    // 78, 1
    if (HBaseConfiguration.isShowConfInServlet() )
    {
      // 78, 49
      jamonWriter.write("\n  <a href=\"/conf\">HBase Configuration</a>\n");
    }
    // 80, 7
    jamonWriter.write("\n</p>\n<hr id=\"head_rule\" />\n\n<h2>Attributes</h2>\n<table id=\"attributes_table\">\n<col style=\"width: 10%;\"/>\n<col />\n<col style=\"width: 20%;\"/>\n<tr><th>Attribute Name</th><th>Value</th><th>Description</th></tr>\n<tr><td>HBase Version</td><td>");
    // 90, 31
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getVersion()), jamonWriter);
    // 90, 90
    jamonWriter.write(", r");
    // 90, 93
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getRevision()), jamonWriter);
    // 90, 153
    jamonWriter.write("</td><td>HBase version and revision</td></tr>\n<tr><td>HBase Compiled</td><td>");
    // 91, 32
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getDate()), jamonWriter);
    // 91, 88
    jamonWriter.write(", ");
    // 91, 90
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(org.apache.hadoop.hbase.util.VersionInfo.getUser()), jamonWriter);
    // 91, 146
    jamonWriter.write("</td><td>When HBase version was compiled and by whom</td></tr>\n<tr><td>Metrics</td><td>");
    // 92, 25
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(metrics.toString()), jamonWriter);
    // 92, 49
    jamonWriter.write("</td><td>RegionServer Metrics; file and heap sizes are in megabytes</td></tr>\n<tr><td>Zookeeper Quorum</td><td>");
    // 93, 34
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(regionServer.getZooKeeper().getQuorum()), jamonWriter);
    // 93, 79
    jamonWriter.write("</td><td>Addresses of all registered ZK servers</td></tr>\n<tr>\n  <td>Coprocessors</td>\n  <td>\n    ");
    // 97, 5
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(java.util.Arrays.toString(regionServer.getCoprocessors())), jamonWriter);
    // 97, 68
    jamonWriter.write("\n  </td>\n  <td>Coprocessors currently loaded by this regionserver</td></tr>\n<tr><td>RS Start Time</td><td>");
    // 100, 31
    org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(new Date(regionServer.getStartcode())), jamonWriter);
    // 100, 74
    jamonWriter.write("</td><td>Date stamp of when this region server was started</td></tr>\n</tr>\n<tr><td>HBase Master</td><td>\n");
    // 103, 1
    if ((masterInfoPort < 0) )
    {
      // 103, 29
      jamonWriter.write("\nNo hbase.master.info.port found\n");
    }
    // 105, 1
    else
    {
      // 105, 8
      jamonWriter.write("\n");
      // 106, 1
      
String host = regionServer.getMasterAddressManager().getMasterAddress().getHostname() + ":" + masterInfoPort;
String url = "http://" + host + "/";

      // 110, 1
      jamonWriter.write("<a href=\"");
      // 110, 10
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(url), jamonWriter);
      // 110, 19
      jamonWriter.write("\">");
      // 110, 21
      org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(host), jamonWriter);
      // 110, 31
      jamonWriter.write("</a>\n");
    }
    // 111, 7
    jamonWriter.write("\n</td><td>Address of HBase Master</td></tr>\n</table>\n\n");
    // 115, 1
    {
      org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl __jamon__var_1 = new org.apache.hadoop.hbase.tmpl.common.TaskMonitorTmpl(this.getTemplateManager());
      __jamon__var_1.setFilter(filter );
      __jamon__var_1.renderNoFlush(jamonWriter);
    }
    // 115, 49
    jamonWriter.write("\n\n<h2>Regions</h2>\n");
    // 118, 1
    if ((onlineRegions != null && onlineRegions.size() > 0) )
    {
      // 118, 60
      jamonWriter.write("\n<table>\n<tr><th>Region Name</th><th>Start Key</th><th>End Key</th><th>Metrics</th></tr>\n");
      // 121, 1
         
  Collections.sort(onlineRegions);

      // 124, 1
      for (HRegionInfo r: onlineRegions )
      {
        // 124, 38
        jamonWriter.write("\n");
        // 125, 1
         
        HServerLoad.RegionLoad load = regionServer.createRegionLoad(r.getEncodedName());

        // 128, 1
        jamonWriter.write("<tr><td>");
        // 128, 9
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(r.getRegionNameAsString()), jamonWriter);
        // 128, 40
        jamonWriter.write("</td>\n    <td>");
        // 129, 9
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(r.getStartKey())), jamonWriter);
        // 129, 52
        jamonWriter.write("</td><td>");
        // 129, 61
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(Bytes.toStringBinary(r.getEndKey())), jamonWriter);
        // 129, 102
        jamonWriter.write("</td>\n    <td>");
        // 130, 9
        org.jamon.escaping.Escaping.HTML.write(org.jamon.emit.StandardEmitter.valueOf(load == null? "null": load.toString()), jamonWriter);
        // 130, 52
        jamonWriter.write("</td>\n    </tr>\n");
      }
      // 132, 8
      jamonWriter.write("\n</table>\n<p>Region names are made of the containing table's name, a comma,\nthe start key, a comma, and a randomly generated region id.  To illustrate,\nthe region named\n<em>domains,apache.org,5464829424211263407</em> is party to the table \n<em>domains</em>, has an id of <em>5464829424211263407</em> and the first key\nin the region is <em>apache.org</em>.  The <em>-ROOT-</em>\nand <em>.META.</em> 'tables' are internal sytem tables (or 'catalog' tables in db-speak).\nThe -ROOT- keeps a list of all regions in the .META. table.  The .META. table\nkeeps a list of all regions in the system. The empty key is used to denote\ntable start and table end.  A region with an empty start key is the first region in a table.\nIf region has both an empty start and an empty end key, its the only region in the table.  See\n<a href=\"http://hbase.org\">HBase Home</a> for further explication.<p>\n");
    }
    // 146, 1
    else
    {
      // 146, 8
      jamonWriter.write("\n<p>Not serving regions</p>\n");
    }
    // 148, 7
    jamonWriter.write("\n</body>\n</html>\n");
  }
  
  
}
