/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.asyncfs;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.BindException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CipherSuite;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.AsyncFSTestBase;
import org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.FanOutOneBlockAsyncDFSOutputHelper;
import org.apache.hadoop.hbase.io.asyncfs.TestFanOutOneBlockAsyncDFSOutput;
import org.apache.hadoop.hbase.io.asyncfs.monitor.StreamSlowMonitor;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoop;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
@Category(value={MiscTests.class, LargeTests.class})
public class TestSaslFanOutOneBlockAsyncDFSOutput
extends AsyncFSTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(TestSaslFanOutOneBlockAsyncDFSOutput.class);
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSaslFanOutOneBlockAsyncDFSOutput.class);
    private static DistributedFileSystem FS;
    private static EventLoopGroup EVENT_LOOP_GROUP;
    private static Class<? extends Channel> CHANNEL_CLASS;
    private static int READ_TIMEOUT_MS;
    private static final File KEYTAB_FILE;
    private static MiniKdc KDC;
    private static String HOST;
    private static String USERNAME;
    private static String PRINCIPAL;
    private static String HTTP_PRINCIPAL;
    private static String TEST_KEY_NAME;
    private static StreamSlowMonitor MONITOR;
    @Rule
    public TestName name = new TestName();
    @Parameterized.Parameter(value=0)
    public String protection;
    @Parameterized.Parameter(value=1)
    public String encryptionAlgorithm;
    @Parameterized.Parameter(value=2)
    public String cipherSuite;
    private Path testDirOnTestFs;
    private Path entryptionTestDirOnTestFs;

    @Parameterized.Parameters(name="{index}: protection={0}, encryption={1}, cipherSuite={2}")
    public static Iterable<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (String protection : Arrays.asList("authentication", "integrity", "privacy")) {
            for (String encryptionAlgorithm : Arrays.asList("", "3des", "rc4")) {
                for (String cipherSuite : Arrays.asList("", CipherSuite.AES_CTR_NOPADDING.getName())) {
                    params.add(new Object[]{protection, encryptionAlgorithm, cipherSuite});
                }
            }
        }
        return params;
    }

    private static void setUpKeyProvider(Configuration conf) throws Exception {
        URI keyProviderUri = new URI("jceks://file" + UTIL.getDataTestDir("test.jks").toUri().toString());
        conf.set("dfs.encryption.key.provider.uri", keyProviderUri.toString());
        KeyProvider keyProvider = KeyProviderFactory.get((URI)keyProviderUri, (Configuration)conf);
        keyProvider.createKey(TEST_KEY_NAME, KeyProvider.options((Configuration)conf));
        keyProvider.flush();
        keyProvider.close();
    }

    private static MiniKdc setupMiniKdc(File keytabFile) throws Exception {
        boolean bindException;
        Properties conf = MiniKdc.createConf();
        conf.put("debug", (Object)true);
        MiniKdc kdc = null;
        File dir = null;
        int numTries = 0;
        do {
            try {
                bindException = false;
                dir = new File(UTIL.getDataTestDir("kdc").toUri().getPath());
                kdc = new MiniKdc(conf, dir);
                kdc.start();
            }
            catch (BindException e) {
                FileUtils.deleteDirectory(dir);
                if (++numTries == 3) {
                    LOG.error("Failed setting up MiniKDC. Tried " + numTries + " times.");
                    throw e;
                }
                LOG.error("BindException encountered when setting up MiniKdc. Trying again.");
                bindException = true;
            }
        } while (bindException);
        System.setProperty("hbase.regionserver.keytab.file", keytabFile.getAbsolutePath());
        return kdc;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        EVENT_LOOP_GROUP = new NioEventLoopGroup();
        CHANNEL_CLASS = NioSocketChannel.class;
        UTIL.getConfiguration().setInt("dfs.client.socket-timeout", READ_TIMEOUT_MS);
        KDC = TestSaslFanOutOneBlockAsyncDFSOutput.setupMiniKdc(KEYTAB_FILE);
        USERNAME = UserGroupInformation.getLoginUser().getShortUserName();
        PRINCIPAL = USERNAME + "/" + HOST;
        HTTP_PRINCIPAL = "HTTP/" + HOST;
        KDC.createPrincipal(KEYTAB_FILE, new String[]{PRINCIPAL, HTTP_PRINCIPAL});
        TestSaslFanOutOneBlockAsyncDFSOutput.setUpKeyProvider(UTIL.getConfiguration());
        HBaseKerberosUtils.setSecuredConfiguration(UTIL.getConfiguration(), PRINCIPAL + "@" + KDC.getRealm(), HTTP_PRINCIPAL + "@" + KDC.getRealm());
        HBaseKerberosUtils.setSSLConfiguration(UTIL, TestSaslFanOutOneBlockAsyncDFSOutput.class);
        MONITOR = StreamSlowMonitor.create((Configuration)UTIL.getConfiguration(), (String)"testMonitor");
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        if (EVENT_LOOP_GROUP != null) {
            EVENT_LOOP_GROUP.shutdownGracefully().get();
        }
        if (KDC != null) {
            KDC.stop();
        }
        TestSaslFanOutOneBlockAsyncDFSOutput.shutdownMiniDFSCluster();
    }

    private void createEncryptionZone() throws Exception {
        Method method = DistributedFileSystem.class.getMethod("createEncryptionZone", Path.class, String.class);
        method.invoke((Object)FS, this.entryptionTestDirOnTestFs, TEST_KEY_NAME);
    }

    @Before
    public void setUp() throws Exception {
        UTIL.getConfiguration().set("dfs.data.transfer.protection", this.protection);
        if (StringUtils.isBlank((CharSequence)this.encryptionAlgorithm) && StringUtils.isBlank((CharSequence)this.cipherSuite)) {
            UTIL.getConfiguration().setBoolean("dfs.encrypt.data.transfer", false);
        } else {
            UTIL.getConfiguration().setBoolean("dfs.encrypt.data.transfer", true);
        }
        if (StringUtils.isBlank((CharSequence)this.encryptionAlgorithm)) {
            UTIL.getConfiguration().unset("dfs.encrypt.data.transfer.algorithm");
        } else {
            UTIL.getConfiguration().set("dfs.encrypt.data.transfer.algorithm", this.encryptionAlgorithm);
        }
        if (StringUtils.isBlank((CharSequence)this.cipherSuite)) {
            UTIL.getConfiguration().unset("dfs.encrypt.data.transfer.cipher.suites");
        } else {
            UTIL.getConfiguration().set("dfs.encrypt.data.transfer.cipher.suites", this.cipherSuite);
        }
        TestSaslFanOutOneBlockAsyncDFSOutput.startMiniDFSCluster(3);
        FS = CLUSTER.getFileSystem();
        this.testDirOnTestFs = new Path("/" + this.name.getMethodName().replaceAll("[^0-9a-zA-Z]", "_"));
        FS.mkdirs(this.testDirOnTestFs);
        this.entryptionTestDirOnTestFs = new Path("/" + this.testDirOnTestFs.getName() + "_enc");
        FS.mkdirs(this.entryptionTestDirOnTestFs);
        this.createEncryptionZone();
    }

    @After
    public void tearDown() throws IOException {
        TestSaslFanOutOneBlockAsyncDFSOutput.shutdownMiniDFSCluster();
    }

    private Path getTestFile() {
        return new Path(this.testDirOnTestFs, "test");
    }

    private Path getEncryptionTestFile() {
        return new Path(this.entryptionTestDirOnTestFs, "test");
    }

    private void test(Path file) throws IOException, InterruptedException, ExecutionException {
        EventLoop eventLoop = EVENT_LOOP_GROUP.next();
        FanOutOneBlockAsyncDFSOutput out = FanOutOneBlockAsyncDFSOutputHelper.createOutput((DistributedFileSystem)FS, (Path)file, (boolean)true, (boolean)false, (short)3, (long)FS.getDefaultBlockSize(), (EventLoopGroup)eventLoop, CHANNEL_CLASS, (StreamSlowMonitor)MONITOR);
        TestFanOutOneBlockAsyncDFSOutput.writeAndVerify((FileSystem)FS, file, (AsyncFSOutput)out);
    }

    @Test
    public void test() throws IOException, InterruptedException, ExecutionException {
        this.test(this.getTestFile());
        this.test(this.getEncryptionTestFile());
    }

    static {
        READ_TIMEOUT_MS = 200000;
        KEYTAB_FILE = new File(UTIL.getDataTestDir("keytab").toUri().getPath());
        HOST = "localhost";
        TEST_KEY_NAME = "test_key";
    }
}

