/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.util.Addressing;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class HRegionLocation
implements Comparable<HRegionLocation> {
    private final HRegionInfo regionInfo;
    private final ServerName serverName;
    private final long seqNum;
    private String cachedString = null;
    private String cachedHostnamePort;

    public HRegionLocation(HRegionInfo regionInfo, ServerName serverName) {
        this(regionInfo, serverName, -1L);
    }

    public HRegionLocation(HRegionInfo regionInfo, ServerName serverName, long seqNum) {
        this.regionInfo = regionInfo;
        this.serverName = serverName;
        this.seqNum = seqNum;
    }

    public synchronized String toString() {
        if (this.cachedString == null) {
            this.cachedString = "region=" + this.regionInfo.getRegionNameAsString() + ", hostname=" + this.serverName + ", seqNum=" + this.seqNum;
        }
        return this.cachedString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof HRegionLocation)) {
            return false;
        }
        return this.compareTo((HRegionLocation)o) == 0;
    }

    public int hashCode() {
        return this.serverName.hashCode();
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public String getHostname() {
        return this.serverName.getHostname();
    }

    public int getPort() {
        return this.serverName.getPort();
    }

    public long getSeqNum() {
        return this.seqNum;
    }

    public synchronized String getHostnamePort() {
        if (this.cachedHostnamePort == null) {
            this.cachedHostnamePort = Addressing.createHostAndPortStr((String)this.getHostname(), (int)this.getPort());
        }
        return this.cachedHostnamePort;
    }

    public ServerName getServerName() {
        return this.serverName;
    }

    @Override
    public int compareTo(HRegionLocation o) {
        return this.serverName.compareTo(o.getServerName());
    }
}

