/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ClientScanner;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.ServerCallable;
import org.apache.hadoop.hbase.client.UnmodifyableHTableDescriptor;
import org.apache.hadoop.hbase.client.coprocessor.Batch;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RegionCoprocessorRpcChannel;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.RequestConverter;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class HTable
implements HTableInterface {
    private static final Log LOG = LogFactory.getLog(HTable.class);
    private HConnection connection;
    private final byte[] tableName;
    private volatile Configuration configuration;
    private final ArrayList<Put> writeBuffer = new ArrayList();
    private long writeBufferSize;
    private boolean clearBufferOnFail;
    private boolean autoFlush;
    private long currentWriteBufferSize;
    protected int scannerCaching;
    private int maxKeyValueSize;
    private ExecutorService pool;
    private boolean closed;
    private int operationTimeout;
    private final boolean cleanupPoolOnClose;
    private final boolean cleanupConnectionOnClose;

    public HTable(Configuration conf, String tableName) throws IOException {
        this(conf, Bytes.toBytes((String)tableName));
    }

    public HTable(Configuration conf, byte[] tableName) throws IOException {
        this.tableName = tableName;
        this.cleanupConnectionOnClose = true;
        this.cleanupPoolOnClose = true;
        if (conf == null) {
            this.connection = null;
            return;
        }
        this.connection = HConnectionManager.getConnection(conf);
        this.configuration = conf;
        int maxThreads = conf.getInt("hbase.htable.threads.max", Integer.MAX_VALUE);
        if (maxThreads == 0) {
            maxThreads = 1;
        }
        long keepAliveTime = conf.getLong("hbase.htable.threads.keepalivetime", 60L);
        this.pool = new ThreadPoolExecutor(1, maxThreads, keepAliveTime, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), Threads.newDaemonThreadFactory((String)"hbase-table"));
        ((ThreadPoolExecutor)this.pool).allowCoreThreadTimeOut(true);
        this.finishSetup();
    }

    public HTable(Configuration conf, byte[] tableName, ExecutorService pool) throws IOException {
        this.connection = HConnectionManager.getConnection(conf);
        this.configuration = conf;
        this.pool = pool;
        this.tableName = tableName;
        this.cleanupPoolOnClose = false;
        this.cleanupConnectionOnClose = true;
        this.finishSetup();
    }

    public HTable(byte[] tableName, HConnection connection, ExecutorService pool) throws IOException {
        if (pool == null || pool.isShutdown()) {
            throw new IllegalArgumentException("Pool is null or shut down.");
        }
        if (connection == null || connection.isClosed()) {
            throw new IllegalArgumentException("Connection is null or closed.");
        }
        this.tableName = tableName;
        this.cleanupConnectionOnClose = false;
        this.cleanupPoolOnClose = false;
        this.connection = connection;
        this.configuration = connection.getConfiguration();
        this.pool = pool;
        this.finishSetup();
    }

    private void finishSetup() throws IOException {
        this.connection.locateRegion(this.tableName, HConstants.EMPTY_START_ROW);
        this.operationTimeout = HTableDescriptor.isMetaTable(this.tableName) ? Integer.MAX_VALUE : this.configuration.getInt("hbase.client.operation.timeout", Integer.MAX_VALUE);
        this.writeBufferSize = this.configuration.getLong("hbase.client.write.buffer", 0x200000L);
        this.clearBufferOnFail = true;
        this.autoFlush = true;
        this.currentWriteBufferSize = 0L;
        this.scannerCaching = this.configuration.getInt(HConstants.HBASE_CLIENT_SCANNER_CACHING, HConstants.DEFAULT_HBASE_CLIENT_SCANNER_CACHING);
        this.maxKeyValueSize = this.configuration.getInt("hbase.client.keyvalue.maxsize", -1);
        this.closed = false;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Deprecated
    public static boolean isTableEnabled(String tableName) throws IOException {
        return HTable.isTableEnabled(Bytes.toBytes((String)tableName));
    }

    @Deprecated
    public static boolean isTableEnabled(byte[] tableName) throws IOException {
        return HTable.isTableEnabled(HBaseConfiguration.create(), tableName);
    }

    @Deprecated
    public static boolean isTableEnabled(Configuration conf, String tableName) throws IOException {
        return HTable.isTableEnabled(conf, Bytes.toBytes((String)tableName));
    }

    @Deprecated
    public static boolean isTableEnabled(Configuration conf, final byte[] tableName) throws IOException {
        return HConnectionManager.execute(new HConnectionManager.HConnectable<Boolean>(conf){

            @Override
            public Boolean connect(HConnection connection) throws IOException {
                return connection.isTableEnabled(tableName);
            }
        });
    }

    public HRegionLocation getRegionLocation(String row) throws IOException {
        return this.connection.getRegionLocation(this.tableName, Bytes.toBytes((String)row), false);
    }

    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        return this.connection.getRegionLocation(this.tableName, row, false);
    }

    public HRegionLocation getRegionLocation(byte[] row, boolean reload) throws IOException {
        return this.connection.getRegionLocation(this.tableName, row, reload);
    }

    @Override
    public byte[] getTableName() {
        return this.tableName;
    }

    @Deprecated
    public HConnection getConnection() {
        return this.connection;
    }

    @Deprecated
    public int getScannerCaching() {
        return this.scannerCaching;
    }

    @Deprecated
    public void setScannerCaching(int scannerCaching) {
        this.scannerCaching = scannerCaching;
    }

    @Override
    public HTableDescriptor getTableDescriptor() throws IOException {
        return new UnmodifyableHTableDescriptor(this.connection.getHTableDescriptor(this.tableName));
    }

    public byte[][] getStartKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getFirst();
    }

    public byte[][] getEndKeys() throws IOException {
        return (byte[][])this.getStartEndKeys().getSecond();
    }

    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        NavigableMap<HRegionInfo, ServerName> regions = this.getRegionLocations();
        ArrayList<byte[]> startKeyList = new ArrayList<byte[]>(regions.size());
        ArrayList<byte[]> endKeyList = new ArrayList<byte[]>(regions.size());
        for (HRegionInfo region : regions.keySet()) {
            startKeyList.add(region.getStartKey());
            endKeyList.add(region.getEndKey());
        }
        return new Pair(startKeyList.toArray((T[])new byte[startKeyList.size()][]), endKeyList.toArray((T[])new byte[endKeyList.size()][]));
    }

    public NavigableMap<HRegionInfo, ServerName> getRegionLocations() throws IOException {
        return MetaScanner.allTableRegions(this.getConfiguration(), this.getTableName(), false);
    }

    public List<HRegionLocation> getRegionsInRange(byte[] startKey, byte[] endKey) throws IOException {
        HRegionLocation regionLocation;
        boolean endKeyIsEndOfTable = Bytes.equals((byte[])endKey, (byte[])HConstants.EMPTY_END_ROW);
        if (Bytes.compareTo((byte[])startKey, (byte[])endKey) > 0 && !endKeyIsEndOfTable) {
            throw new IllegalArgumentException("Invalid range: " + Bytes.toStringBinary((byte[])startKey) + " > " + Bytes.toStringBinary((byte[])endKey));
        }
        ArrayList<HRegionLocation> regionList = new ArrayList<HRegionLocation>();
        byte[] currentKey = startKey;
        do {
            regionLocation = this.getRegionLocation(currentKey, false);
            regionList.add(regionLocation);
        } while (!Bytes.equals((byte[])(currentKey = regionLocation.getRegionInfo().getEndKey()), (byte[])HConstants.EMPTY_END_ROW) && (endKeyIsEndOfTable || Bytes.compareTo((byte[])currentKey, (byte[])endKey) < 0));
        return regionList;
    }

    @Override
    public Result getRowOrBefore(byte[] row, final byte[] family) throws IOException {
        return (Result)new ServerCallable<Result>(this.connection, this.tableName, row, this.operationTimeout){

            @Override
            public Result call() throws IOException {
                return ProtobufUtil.getRowOrBefore(this.server, this.location.getRegionInfo().getRegionName(), this.row, family);
            }
        }.withRetries();
    }

    @Override
    public ResultScanner getScanner(Scan scan) throws IOException {
        if (scan.getCaching() <= 0) {
            scan.setCaching(this.getScannerCaching());
        }
        return new ClientScanner(this.getConfiguration(), scan, this.getTableName(), this.connection);
    }

    @Override
    public ResultScanner getScanner(byte[] family) throws IOException {
        Scan scan = new Scan();
        scan.addFamily(family);
        return this.getScanner(scan);
    }

    @Override
    public ResultScanner getScanner(byte[] family, byte[] qualifier) throws IOException {
        Scan scan = new Scan();
        scan.addColumn(family, qualifier);
        return this.getScanner(scan);
    }

    @Override
    public Result get(final Get get) throws IOException {
        return (Result)new ServerCallable<Result>(this.connection, this.tableName, get.getRow(), this.operationTimeout){

            @Override
            public Result call() throws IOException {
                return ProtobufUtil.get(this.server, this.location.getRegionInfo().getRegionName(), get);
            }
        }.withRetries();
    }

    @Override
    public Result[] get(List<Get> gets) throws IOException {
        try {
            Object[] r1 = this.batch(gets);
            Result[] results = new Result[r1.length];
            int i = 0;
            for (Object o : r1) {
                results[i++] = (Result)o;
            }
            return results;
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void batch(List<? extends Row> actions, Object[] results) throws InterruptedException, IOException {
        this.connection.processBatchCallback(actions, this.tableName, this.pool, results, null);
    }

    @Override
    public Object[] batch(List<? extends Row> actions) throws InterruptedException, IOException {
        Object[] results = new Object[actions.size()];
        this.connection.processBatchCallback(actions, this.tableName, this.pool, results, null);
        return results;
    }

    @Override
    public <R> void batchCallback(List<? extends Row> actions, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.connection.processBatchCallback(actions, this.tableName, this.pool, results, callback);
    }

    @Override
    public <R> Object[] batchCallback(List<? extends Row> actions, Batch.Callback<R> callback) throws IOException, InterruptedException {
        Object[] results = new Object[actions.size()];
        this.connection.processBatchCallback(actions, this.tableName, this.pool, results, callback);
        return results;
    }

    @Override
    public void delete(final Delete delete) throws IOException {
        new ServerCallable<Boolean>(this.connection, this.tableName, delete.getRow(), this.operationTimeout){

            @Override
            public Boolean call() throws IOException {
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.location.getRegionInfo().getRegionName(), delete);
                    ClientProtos.MutateResponse response = this.server.mutate(null, request);
                    return response.getProcessed();
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        }.withRetries();
    }

    @Override
    public void delete(List<Delete> deletes) throws IOException {
        Object[] results = new Object[deletes.size()];
        try {
            this.connection.processBatch(deletes, this.tableName, this.pool, results);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        finally {
            for (int i = results.length - 1; i >= 0; --i) {
                if (!(results[i] instanceof Result)) continue;
                deletes.remove(i);
            }
        }
    }

    @Override
    public void put(Put put) throws IOException {
        this.doPut(put);
        if (this.autoFlush) {
            this.flushCommits();
        }
    }

    @Override
    public void put(List<Put> puts) throws IOException {
        for (Put put : puts) {
            this.doPut(put);
        }
        if (this.autoFlush) {
            this.flushCommits();
        }
    }

    private void doPut(Put put) throws IOException {
        this.validatePut(put);
        this.writeBuffer.add(put);
        this.currentWriteBufferSize += put.heapSize();
        if (this.currentWriteBufferSize > this.writeBufferSize) {
            this.flushCommits();
        }
    }

    @Override
    public void mutateRow(final RowMutations rm) throws IOException {
        new ServerCallable<Void>(this.connection, this.tableName, rm.getRow(), this.operationTimeout){

            @Override
            public Void call() throws IOException {
                try {
                    ClientProtos.MultiRequest request = RequestConverter.buildMultiRequest(this.location.getRegionInfo().getRegionName(), rm);
                    this.server.multi(null, request);
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
                return null;
            }
        }.withRetries();
    }

    @Override
    public Result append(final Append append) throws IOException {
        if (append.numFamilies() == 0) {
            throw new IOException("Invalid arguments to append, no columns specified");
        }
        return (Result)new ServerCallable<Result>(this.connection, this.tableName, append.getRow(), this.operationTimeout){

            @Override
            public Result call() throws IOException {
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.location.getRegionInfo().getRegionName(), append);
                    PayloadCarryingRpcController rpcController = new PayloadCarryingRpcController();
                    ClientProtos.MutateResponse response = this.server.mutate(rpcController, request);
                    if (!response.hasResult()) {
                        return null;
                    }
                    return ProtobufUtil.toResult(response.getResult(), rpcController.cellScanner());
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        }.withRetries();
    }

    @Override
    public Result increment(final Increment increment) throws IOException {
        if (!increment.hasFamilies()) {
            throw new IOException("Invalid arguments to increment, no columns specified");
        }
        return (Result)new ServerCallable<Result>(this.connection, this.tableName, increment.getRow(), this.operationTimeout){

            @Override
            public Result call() throws IOException {
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.location.getRegionInfo().getRegionName(), increment);
                    PayloadCarryingRpcController rpcContoller = new PayloadCarryingRpcController();
                    ClientProtos.MutateResponse response = this.server.mutate(rpcContoller, request);
                    return ProtobufUtil.toResult(response.getResult(), rpcContoller.cellScanner());
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        }.withRetries();
    }

    @Override
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount) throws IOException {
        return this.incrementColumnValue(row, family, qualifier, amount, true);
    }

    @Override
    public long incrementColumnValue(byte[] row, final byte[] family, final byte[] qualifier, final long amount, final boolean writeToWAL) throws IOException {
        NullPointerException npe = null;
        if (row == null) {
            npe = new NullPointerException("row is null");
        } else if (family == null) {
            npe = new NullPointerException("family is null");
        } else if (qualifier == null) {
            npe = new NullPointerException("qualifier is null");
        }
        if (npe != null) {
            throw new IOException("Invalid arguments to incrementColumnValue", npe);
        }
        return (Long)new ServerCallable<Long>(this.connection, this.tableName, row, this.operationTimeout){

            @Override
            public Long call() throws IOException {
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.location.getRegionInfo().getRegionName(), this.row, family, qualifier, amount, writeToWAL);
                    PayloadCarryingRpcController rpcController = new PayloadCarryingRpcController();
                    ClientProtos.MutateResponse response = this.server.mutate(rpcController, request);
                    Result result = ProtobufUtil.toResult(response.getResult(), rpcController.cellScanner());
                    return Bytes.toLong((byte[])result.getValue(family, qualifier));
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        }.withRetries();
    }

    @Override
    public boolean checkAndPut(byte[] row, final byte[] family, final byte[] qualifier, final byte[] value, final Put put) throws IOException {
        return (Boolean)new ServerCallable<Boolean>(this.connection, this.tableName, row, this.operationTimeout){

            @Override
            public Boolean call() throws IOException {
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.location.getRegionInfo().getRegionName(), this.row, family, qualifier, (ByteArrayComparable)new BinaryComparator(value), HBaseProtos.CompareType.EQUAL, put);
                    ClientProtos.MutateResponse response = this.server.mutate(null, request);
                    return response.getProcessed();
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        }.withRetries();
    }

    @Override
    public boolean checkAndDelete(byte[] row, final byte[] family, final byte[] qualifier, final byte[] value, final Delete delete) throws IOException {
        return (Boolean)new ServerCallable<Boolean>(this.connection, this.tableName, row, this.operationTimeout){

            @Override
            public Boolean call() throws IOException {
                try {
                    ClientProtos.MutateRequest request = RequestConverter.buildMutateRequest(this.location.getRegionInfo().getRegionName(), this.row, family, qualifier, (ByteArrayComparable)new BinaryComparator(value), HBaseProtos.CompareType.EQUAL, delete);
                    ClientProtos.MutateResponse response = this.server.mutate(null, request);
                    return response.getProcessed();
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        }.withRetries();
    }

    @Override
    public boolean exists(final Get get) throws IOException {
        return (Boolean)new ServerCallable<Boolean>(this.connection, this.tableName, get.getRow(), this.operationTimeout){

            @Override
            public Boolean call() throws IOException {
                try {
                    ClientProtos.GetRequest request = RequestConverter.buildGetRequest(this.location.getRegionInfo().getRegionName(), get, true);
                    ClientProtos.GetResponse response = this.server.get(null, request);
                    return response.getExists();
                }
                catch (ServiceException se) {
                    throw ProtobufUtil.getRemoteException(se);
                }
            }
        }.withRetries();
    }

    @Override
    public Boolean[] exists(List<Get> gets) throws IOException {
        ArrayList<SortedGet> sortedGetsList = new ArrayList<SortedGet>();
        for (int indexGet = 0; indexGet < gets.size(); ++indexGet) {
            sortedGetsList.add(new SortedGet(gets.get(indexGet), indexGet));
        }
        Collections.sort(sortedGetsList);
        HashMap<Integer, ArrayList<Get>> getsByRegion = new HashMap<Integer, ArrayList<Get>>();
        HashMap<Get, Integer> getToRegionIndexMap = new HashMap<Get, Integer>();
        Pair<byte[][], byte[][]> startEndKeys = this.getStartEndKeys();
        int regionIndex = 0;
        for (SortedGet get : sortedGetsList) {
            while (regionIndex < ((byte[][])startEndKeys.getSecond()).length && Bytes.compareTo((byte[])((byte[][])startEndKeys.getSecond())[regionIndex], (byte[])get.getGet().getRow()) <= 0) {
                ++regionIndex;
            }
            ArrayList<Get> regionGets = (ArrayList<Get>)getsByRegion.get(regionIndex);
            if (regionGets == null) {
                regionGets = new ArrayList<Get>();
                getsByRegion.put(regionIndex, regionGets);
            }
            regionGets.add(get.getGet());
            getToRegionIndexMap.put(get.getGet(), regionIndex);
        }
        HashMap futures = new HashMap(sortedGetsList.size());
        for (final Map.Entry getsByRegionEntry : getsByRegion.entrySet()) {
            Callable<List<Boolean>> callable = new Callable<List<Boolean>>(){

                @Override
                public List<Boolean> call() throws Exception {
                    return (List)new ServerCallable<List<Boolean>>(HTable.this.connection, HTable.this.tableName, ((Get)((List)getsByRegionEntry.getValue()).get(0)).getRow(), HTable.this.operationTimeout){

                        @Override
                        public List<Boolean> call() throws IOException {
                            try {
                                ClientProtos.MultiGetRequest requests = RequestConverter.buildMultiGetRequest(this.location.getRegionInfo().getRegionName(), (List)getsByRegionEntry.getValue(), true, false);
                                ClientProtos.MultiGetResponse responses = this.server.multiGet(null, requests);
                                return responses.getExistsList();
                            }
                            catch (ServiceException se) {
                                throw ProtobufUtil.getRemoteException(se);
                            }
                        }
                    }.withRetries();
                }
            };
            futures.put(getsByRegionEntry.getKey(), this.pool.submit(callable));
        }
        HashMap responses = new HashMap();
        for (Map.Entry sortedGetEntry : getsByRegion.entrySet()) {
            try {
                Future future = (Future)futures.get(sortedGetEntry.getKey());
                List resp = (List)future.get();
                if (resp == null) {
                    LOG.warn((Object)("Failed for gets on region: " + sortedGetEntry.getKey()));
                }
                responses.put(sortedGetEntry.getKey(), resp);
            }
            catch (ExecutionException e) {
                LOG.warn((Object)("Failed for gets on region: " + sortedGetEntry.getKey()));
            }
            catch (InterruptedException e) {
                LOG.warn((Object)("Failed for gets on region: " + sortedGetEntry.getKey()));
                Thread.currentThread().interrupt();
            }
        }
        Boolean[] results = new Boolean[sortedGetsList.size()];
        HashMap<Integer, Integer> indexes = new HashMap<Integer, Integer>();
        for (int i = 0; i < sortedGetsList.size(); ++i) {
            Integer regionInfoIndex = (Integer)getToRegionIndexMap.get(((SortedGet)sortedGetsList.get(i)).getGet());
            Integer index = (Integer)indexes.get(regionInfoIndex);
            if (index == null) {
                index = 0;
            }
            results[((SortedGet)sortedGetsList.get((int)i)).getInitialIndex()] = (Boolean)((List)responses.get(regionInfoIndex)).get(index);
            indexes.put(regionInfoIndex, index + 1);
        }
        return results;
    }

    @Override
    public void flushCommits() throws IOException {
        if (this.writeBuffer.isEmpty()) {
            return;
        }
        Object[] results = new Object[this.writeBuffer.size()];
        boolean success = false;
        try {
            this.connection.processBatch(this.writeBuffer, this.tableName, this.pool, results);
            success = true;
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        finally {
            this.currentWriteBufferSize = 0L;
            if (success || this.clearBufferOnFail) {
                this.writeBuffer.clear();
            } else {
                for (int i = results.length - 1; i >= 0; --i) {
                    if (results[i] instanceof Result) {
                        this.writeBuffer.remove(i);
                        continue;
                    }
                    this.currentWriteBufferSize += this.writeBuffer.get(i).heapSize();
                }
            }
        }
    }

    public <R> void processBatchCallback(List<? extends Row> list, Object[] results, Batch.Callback<R> callback) throws IOException, InterruptedException {
        this.connection.processBatchCallback(list, this.tableName, this.pool, results, callback);
    }

    public void processBatch(List<? extends Row> list, Object[] results) throws IOException, InterruptedException {
        this.processBatchCallback(list, results, null);
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.flushCommits();
        if (this.cleanupPoolOnClose) {
            this.pool.shutdown();
        }
        if (this.cleanupConnectionOnClose && this.connection != null) {
            this.connection.close();
        }
        this.closed = true;
    }

    public void validatePut(Put put) throws IllegalArgumentException {
        if (put.isEmpty()) {
            throw new IllegalArgumentException("No columns to insert");
        }
        if (this.maxKeyValueSize > 0) {
            for (List list : put.getFamilyMap().values()) {
                for (Cell cell : list) {
                    KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
                    if (kv.getLength() <= this.maxKeyValueSize) continue;
                    throw new IllegalArgumentException("KeyValue size too large");
                }
            }
        }
    }

    @Override
    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    @Override
    public void setAutoFlush(boolean autoFlush) {
        this.setAutoFlush(autoFlush, autoFlush);
    }

    @Override
    public void setAutoFlush(boolean autoFlush, boolean clearBufferOnFail) {
        this.autoFlush = autoFlush;
        this.clearBufferOnFail = autoFlush || clearBufferOnFail;
    }

    @Override
    public long getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public void setWriteBufferSize(long writeBufferSize) throws IOException {
        this.writeBufferSize = writeBufferSize;
        if (this.currentWriteBufferSize > writeBufferSize) {
            this.flushCommits();
        }
    }

    public ArrayList<Put> getWriteBuffer() {
        return this.writeBuffer;
    }

    ExecutorService getPool() {
        return this.pool;
    }

    public static void setRegionCachePrefetch(final byte[] tableName, final boolean enable) throws IOException {
        HConnectionManager.execute(new HConnectionManager.HConnectable<Void>(HBaseConfiguration.create()){

            @Override
            public Void connect(HConnection connection) throws IOException {
                connection.setRegionCachePrefetch(tableName, enable);
                return null;
            }
        });
    }

    public static void setRegionCachePrefetch(Configuration conf, final byte[] tableName, final boolean enable) throws IOException {
        HConnectionManager.execute(new HConnectionManager.HConnectable<Void>(conf){

            @Override
            public Void connect(HConnection connection) throws IOException {
                connection.setRegionCachePrefetch(tableName, enable);
                return null;
            }
        });
    }

    public static boolean getRegionCachePrefetch(Configuration conf, final byte[] tableName) throws IOException {
        return HConnectionManager.execute(new HConnectionManager.HConnectable<Boolean>(conf){

            @Override
            public Boolean connect(HConnection connection) throws IOException {
                return connection.getRegionCachePrefetch(tableName);
            }
        });
    }

    public static boolean getRegionCachePrefetch(final byte[] tableName) throws IOException {
        return HConnectionManager.execute(new HConnectionManager.HConnectable<Boolean>(HBaseConfiguration.create()){

            @Override
            public Boolean connect(HConnection connection) throws IOException {
                return connection.getRegionCachePrefetch(tableName);
            }
        });
    }

    public void clearRegionCache() {
        this.connection.clearRegionCache();
    }

    @Override
    public CoprocessorRpcChannel coprocessorService(byte[] row) {
        return new RegionCoprocessorRpcChannel(this.connection, this.tableName, row);
    }

    @Override
    public <T extends Service, R> Map<byte[], R> coprocessorService(Class<T> service, byte[] startKey, byte[] endKey, Batch.Call<T, R> callable) throws ServiceException, Throwable {
        final Map results = Collections.synchronizedMap(new TreeMap(Bytes.BYTES_COMPARATOR));
        this.coprocessorService(service, startKey, endKey, callable, new Batch.Callback<R>(){

            @Override
            public void update(byte[] region, byte[] row, R value) {
                results.put(region, value);
            }
        });
        return results;
    }

    @Override
    public <T extends Service, R> void coprocessorService(final Class<T> service, byte[] startKey, byte[] endKey, final Batch.Call<T, R> callable, final Batch.Callback<R> callback) throws ServiceException, Throwable {
        List<byte[]> keys = this.getStartKeysInRange(startKey, endKey);
        TreeMap futures = new TreeMap(Bytes.BYTES_COMPARATOR);
        for (final byte[] byArray : keys) {
            final RegionCoprocessorRpcChannel channel = new RegionCoprocessorRpcChannel(this.connection, this.tableName, byArray);
            Future future = this.pool.submit(new Callable<R>(){

                @Override
                public R call() throws Exception {
                    Object instance = ProtobufUtil.newServiceStub(service, channel);
                    Object result = callable.call(instance);
                    byte[] region = channel.getLastRegion();
                    if (callback != null) {
                        callback.update(region, byArray, result);
                    }
                    return result;
                }
            });
            futures.put(byArray, future);
        }
        for (Map.Entry entry : futures.entrySet()) {
            try {
                ((Future)entry.getValue()).get();
            }
            catch (ExecutionException ee) {
                LOG.warn((Object)("Error calling coprocessor service " + service.getName() + " for row " + Bytes.toStringBinary((byte[])((byte[])entry.getKey()))), (Throwable)ee);
                throw ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException("Interrupted calling coprocessor service " + service.getName() + " for row " + Bytes.toStringBinary((byte[])((byte[])entry.getKey()))).initCause(ie);
            }
        }
    }

    private List<byte[]> getStartKeysInRange(byte[] start, byte[] end) throws IOException {
        Pair<byte[][], byte[][]> startEndKeys = this.getStartEndKeys();
        byte[][] startKeys = (byte[][])startEndKeys.getFirst();
        byte[][] endKeys = (byte[][])startEndKeys.getSecond();
        if (start == null) {
            start = HConstants.EMPTY_START_ROW;
        }
        if (end == null) {
            end = HConstants.EMPTY_END_ROW;
        }
        ArrayList<byte[]> rangeKeys = new ArrayList<byte[]>();
        for (int i = 0; i < startKeys.length; ++i) {
            if (Bytes.compareTo((byte[])start, (byte[])startKeys[i]) >= 0) {
                if (!Bytes.equals((byte[])endKeys[i], (byte[])HConstants.EMPTY_END_ROW) && Bytes.compareTo((byte[])start, (byte[])endKeys[i]) >= 0) continue;
                rangeKeys.add(start);
                continue;
            }
            if (!Bytes.equals((byte[])end, (byte[])HConstants.EMPTY_END_ROW) && Bytes.compareTo((byte[])startKeys[i], (byte[])end) > 0) break;
            rangeKeys.add(startKeys[i]);
        }
        return rangeKeys;
    }

    public void setOperationTimeout(int operationTimeout) {
        this.operationTimeout = operationTimeout;
    }

    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    private static class SortedGet
    implements Comparable<SortedGet> {
        protected int initialIndex = -1;
        protected Get get;

        public SortedGet(Get get, int initialIndex) {
            this.get = get;
            this.initialIndex = initialIndex;
        }

        public int getInitialIndex() {
            return this.initialIndex;
        }

        @Override
        public int compareTo(SortedGet o) {
            return this.get.compareTo(o.get);
        }

        public Get getGet() {
            return this.get;
        }

        public int hashCode() {
            return this.get.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof SortedGet) {
                return this.get.equals(((SortedGet)obj).get);
            }
            return false;
        }
    }
}

